/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.space.quota;

import com.silverpeas.annotation.Service;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.silverpeas.admin.space.quota.AbstractSpaceQuotaService;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaService;
import org.silverpeas.quota.exception.QuotaException;
import org.silverpeas.quota.model.Quota;
import org.silverpeas.quota.offset.AbstractQuotaCountingOffset;

@Service
public class DefaultDataStorageSpaceQuotaService
extends AbstractSpaceQuotaService<DataStorageSpaceQuotaKey>
implements DataStorageSpaceQuotaService {
    private static long dataStorageInPersonalSpaceQuotaDefaultMaxCount;

    @Override
    protected DataStorageSpaceQuotaKey createKeyFrom(SpaceInst space) {
        return DataStorageSpaceQuotaKey.from(space);
    }

    @Override
    public long getCurrentCount(DataStorageSpaceQuotaKey key) throws QuotaException {
        long currentCount = 0L;
        if (key.getSpace() != null) {
            for (ComponentInst component : key.getSpace().getAllComponentsInst()) {
                File file = new File(FileRepositoryManager.getAbsolutePath(component.getId()));
                if (!file.exists()) continue;
                currentCount += FileUtils.sizeOfDirectory((File)file);
            }
        }
        return currentCount;
    }

    @Override
    public Quota verify(DataStorageSpaceQuotaKey key, AbstractQuotaCountingOffset countingOffset) throws QuotaException {
        Quota quota = new Quota();
        if (key.isValid()) {
            if (key.getSpace().isPersonalSpace()) {
                quota.setId(-1L);
                quota.setMaxCount(dataStorageInPersonalSpaceQuotaDefaultMaxCount);
                quota = super.verify(key, quota, countingOffset);
            } else {
                quota = super.verify(key, countingOffset);
            }
        }
        return quota;
    }

    static {
        ResourceLocator settings = new ResourceLocator("com.silverpeas.jobStartPagePeas.settings.jobStartPagePeasSettings", "");
        dataStorageInPersonalSpaceQuotaDefaultMaxCount = settings.getLong("quota.personalspace.datastorage.default.maxCount", 0L);
        if (dataStorageInPersonalSpaceQuotaDefaultMaxCount < 0L) {
            dataStorageInPersonalSpaceQuotaDefaultMaxCount = 0L;
        }
    }
}

