/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.space.quota.process.check;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.admin.space.SpaceServiceFactory;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.admin.space.quota.process.check.SpaceDataStorageQuotaCountingOffset;
import org.silverpeas.admin.space.quota.process.check.exception.DataStorageQuotaException;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.process.io.IOAccess;
import org.silverpeas.process.io.file.FileHandler;
import org.silverpeas.process.management.AbstractFileProcessCheck;
import org.silverpeas.process.management.ProcessExecutionContext;
import org.silverpeas.quota.exception.QuotaException;

@Named
public class DataStorageQuotaProcessCheck
extends AbstractFileProcessCheck {
    @Inject
    private OrganisationController organizationController;

    @Override
    public void checkFiles(ProcessExecutionContext processExecutionProcess, FileHandler fileHandler) throws Exception {
        if (IOAccess.READ_WRITE.equals((Object)fileHandler.getIoAccess())) {
            for (SpaceInst space : this.indentifyHandledSpaces(processExecutionProcess, fileHandler)) {
                try {
                    SpaceServiceFactory.getDataStorageSpaceQuotaService().verify(DataStorageSpaceQuotaKey.from(space), SpaceDataStorageQuotaCountingOffset.from(space, fileHandler));
                }
                catch (QuotaException quotaException) {
                    ComponentInstLight fromComponent = null;
                    String fromComponentInstanceId = processExecutionProcess.getComponentInstanceId();
                    if (StringUtil.isDefined(fromComponentInstanceId)) {
                        fromComponent = this.organizationController.getComponentInstLight(fromComponentInstanceId);
                    }
                    throw new DataStorageQuotaException(quotaException.getQuota(), space, fromComponent);
                }
            }
        }
    }

    private Collection<SpaceInst> indentifyHandledSpaces(ProcessExecutionContext processExecutionProcess, FileHandler fileHandler) {
        HashSet<String> spaceIds = new HashSet<String>();
        HashSet<String> componentInstanceIds = new HashSet<String>();
        if (StringUtil.isDefined(processExecutionProcess.getComponentInstanceId())) {
            componentInstanceIds.add(processExecutionProcess.getComponentInstanceId());
        }
        componentInstanceIds.addAll(fileHandler.getSessionHandledRootPathNames(true));
        for (String componentInstanceId : componentInstanceIds) {
            ComponentInst component = this.organizationController.getComponentInst(componentInstanceId);
            if (component == null) continue;
            spaceIds.add(component.getDomainFatherId());
        }
        ArrayList<SpaceInst> spaces = new ArrayList<SpaceInst>();
        for (String spaceId : spaceIds) {
            spaces.add(this.organizationController.getSpaceInstById(spaceId));
        }
        return spaces;
    }
}

