/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment;

import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationSender;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;

public class ScheduledReservedFile
implements SchedulerEventListener {
    public static final String ATTACHMENT_JOB_NAME_PROCESS = "A_ProcessReservedFileAttachment";
    private ResourceLocator resources = new ResourceLocator("org.silverpeas.util.attachment.Attachment", "");
    private ResourceLocator generalMessage = new ResourceLocator("org.silverpeas.multilang.generalMultilang", "");

    public void initialize() {
        try {
            String cron = this.resources.getString("cronScheduledReservedFile");
            SchedulerFactory schedulerFactory = SchedulerFactory.getFactory();
            Scheduler scheduler = schedulerFactory.getScheduler();
            scheduler.unscheduleJob(ATTACHMENT_JOB_NAME_PROCESS);
            JobTrigger trigger = JobTrigger.triggerAt(cron);
            scheduler.scheduleJob(ATTACHMENT_JOB_NAME_PROCESS, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverTrace.error("attachment", "ScheduledReservedFile.initialize()", "attachment.EX_CANT_INIT_SCHEDULED_RESERVED_FILE", e);
        }
    }

    public void doScheduledReservedFile() throws AttachmentException {
        SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_ENTER_METHOD");
        try {
            ResourceLocator message = new ResourceLocator("org.silverpeas.util.attachment.multilang.attachment", "fr");
            ResourceLocator message_en = new ResourceLocator("org.silverpea.util.attachment.multilang.attachment", "en");
            StringBuilder messageBody = new StringBuilder();
            StringBuilder messageBody_en = new StringBuilder();
            Calendar calendar = Calendar.getInstance(Locale.FRENCH);
            calendar.add(5, 1);
            Date expiryDate = calendar.getTime();
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "expiryDate = " + expiryDate.toString());
            List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listExpiringDocuments(expiryDate, null);
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "Attachemnts = " + documents.size());
            for (SimpleDocument document : documents) {
                messageBody.append(message.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("'");
                messageBody_en.append(message_en.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("'");
                SilverTrace.info("attachment", "ScheduledAlertUser.doScheduledAlertUser()", "root.MSG_GEN_PARAM_VALUE", "body=" + messageBody.toString());
                this.createMessage(message, messageBody, message_en, messageBody_en, document, false, false);
                messageBody = new StringBuilder();
                messageBody_en = new StringBuilder();
            }
            calendar = Calendar.getInstance(Locale.FRENCH);
            Date alertDate = calendar.getTime();
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "alertDate = " + alertDate.toString());
            documents = AttachmentServiceFactory.getAttachmentService().listDocumentsRequiringWarning(alertDate, null);
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "Attachemnts = " + documents.size());
            messageBody = new StringBuilder();
            messageBody_en = new StringBuilder();
            for (SimpleDocument document : documents) {
                messageBody.append(message.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("' ");
                messageBody_en.append(message_en.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("' ");
                SilverTrace.info("attachment", "ScheduledAlertUser.doScheduledAlertUser()", "root.MSG_GEN_PARAM_VALUE", "body=" + messageBody.toString());
                this.createMessage(message, messageBody, message_en, messageBody_en, document, true, false);
                messageBody = new StringBuilder();
                messageBody_en = new StringBuilder();
            }
            calendar = Calendar.getInstance(Locale.FRENCH);
            Date libDate = calendar.getTime();
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "libDate = " + libDate.toString());
            documents = AttachmentServiceFactory.getAttachmentService().listDocumentsToUnlock(libDate, null);
            SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_PARAM_VALUE", "Attachemnts = " + documents.size());
            messageBody = new StringBuilder();
            messageBody_en = new StringBuilder();
            for (SimpleDocument document : documents) {
                messageBody.append(message.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("'");
                messageBody_en.append(message_en.getString("attachment.notifName")).append(" '").append(document.getFilename()).append("'");
                SilverTrace.info("attachment", "ScheduledAlertUser.doScheduledAlertUser()", "root.MSG_GEN_PARAM_VALUE", "body=" + messageBody.toString());
                this.createMessage(message, messageBody, message_en, messageBody_en, document, false, true);
                messageBody = new StringBuilder();
                messageBody_en = new StringBuilder();
                document.unlock();
                AttachmentServiceFactory.getAttachmentService().updateAttachment(document, false, false);
            }
        }
        catch (Exception e) {
            throw new AttachmentException("ScheduledReservedFile.doScheduledReservedFile()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
        }
        SilverTrace.info("attachment", "ScheduledReservedFile.doScheduledReservedFile()", "root.MSG_GEN_EXIT_METHOD");
    }

    private void createMessage(ResourceLocator message, StringBuilder messageBody, ResourceLocator message_en, StringBuilder messageBody_en, SimpleDocument document, boolean alert, boolean lib) throws AttachmentException {
        Calendar atDate = Calendar.getInstance();
        atDate.setTime(document.getExpiry());
        String jour = "GML.jour" + atDate.get(7);
        String mois = "GML.mois" + atDate.get(2);
        String date = this.generalMessage.getString(jour) + " " + atDate.get(5) + " " + this.generalMessage.getString(mois) + " " + atDate.get(1);
        SilverTrace.info("attachment", "ScheduledReservedFile.createMessage()", "root.MSG_GEN_EXIT_METHOD");
        String subject = this.createMessageSubject(message, alert, lib);
        String body = this.createMessageBody(message, messageBody, date, alert, lib);
        String subject_en = this.createMessageSubject(message_en, alert, lib);
        String body_en = this.createMessageBody(message_en, messageBody_en, date, alert, lib);
        NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, body);
        notifMetaData.addLanguage("en", subject_en, body_en);
        notifMetaData.addUserRecipient(new UserRecipient(document.getEditedBy()));
        String url = URLManager.getURL(null, null, document.getInstanceId()) + "GoToFilesTab?Id=" + document.getForeignId();
        notifMetaData.setLink(url);
        notifMetaData.setComponentId(document.getInstanceId());
        this.notifyUser(notifMetaData, document.getEditedBy(), document.getInstanceId());
    }

    private String createMessageBody(ResourceLocator message, StringBuilder body, String date, boolean alert, boolean lib) {
        if (lib) {
            return body.append(" ").append(message.getString("attachment.notifUserLib")).append("\n\n").toString();
        }
        if (alert) {
            return body.append(" ").append(message.getString("attachment.notifUserAlert")).append(" (").append(date).append(") ").append("\n\n").toString();
        }
        return body.append(" ").append(message.getString("attachment.notifUserExpiry")).append("\n\n").toString();
    }

    private String createMessageSubject(ResourceLocator message, boolean alert, boolean lib) {
        if (lib) {
            return message.getString("attachment.notifSubjectLib");
        }
        if (alert) {
            return message.getString("attachment.notifSubjectAlert");
        }
        return message.getString("attachment.notifSubjectExpiry");
    }

    public void notifyUser(NotificationMetaData notifMetaData, String senderId, String componentId) throws AttachmentException {
        SilverTrace.info("attachment", "AttachmentBmImpl.notifyUser()", "root.MSG_GEN_EXIT_METHOD");
        try {
            SilverTrace.info("attachment", "AttachmentBmImpl.notifyUser()", "root.MSG_GEN_EXIT_METHOD", " senderId = " + senderId + " componentId = " + componentId);
            if (!StringUtil.isDefined(notifMetaData.getSender())) {
                notifMetaData.setSender(senderId);
            }
            NotificationSender notifSender = new NotificationSender(componentId);
            notifSender.notifyUser(notifMetaData);
        }
        catch (NotificationManagerException e) {
            throw new AttachmentException("AttachmentBmImpl.notifyUser()", 4, "attachment.MSG_ATTACHMENT_NOT_EXIST", e);
        }
    }

    @Override
    public void triggerFired(SchedulerEvent anEvent) throws Exception {
        SilverTrace.debug("Attachment", "Attachment_TimeoutManagerImpl.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' is executed");
        this.doScheduledReservedFile();
    }

    @Override
    public void jobSucceeded(SchedulerEvent anEvent) {
        SilverTrace.debug("Attachment", "Attachment_TimeoutManagerImpl.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' was successfull");
    }

    @Override
    public void jobFailed(SchedulerEvent anEvent) {
        SilverTrace.error("Attachment", "Attachment_TimeoutManagerImpl.handleSchedulerEvent", "The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull");
    }
}

