/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment;

import com.silverpeas.annotation.Service;
import com.silverpeas.form.FormException;
import com.silverpeas.form.RecordSet;
import com.silverpeas.jcrutil.BasicDaoFactory;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentService;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.model.UnlockContext;
import org.silverpeas.attachment.notification.AttachmentNotificationService;
import org.silverpeas.attachment.repository.DocumentRepository;
import org.silverpeas.attachment.webdav.WebdavRepository;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEngineProxy;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;

@Service
public class SimpleDocumentService
implements AttachmentService {
    private static final int STEP = 5;
    @Inject
    @Named(value="webdavRepository")
    private WebdavRepository webdavRepository;
    @Inject
    @Named(value="documentRepository")
    private DocumentRepository repository;
    private final ResourceLocator resources = new ResourceLocator("org.silverpeas.util.attachment.Attachment", "");

    @Override
    public void createIndex(SimpleDocument document) {
        this.createIndex(document, null, null);
    }

    @Override
    public void deleteIndex(SimpleDocument document) {
        for (String lang : I18NHelper.getAllSupportedLanguages()) {
            this.deleteIndex(document, lang);
        }
    }

    @Override
    public void createIndex(SimpleDocument document, Date startOfVisibility, Date endOfVisibility) {
        if (this.resources.getBoolean("attachment.index.separately", true)) {
            String language = I18NHelper.checkLanguage(document.getLanguage());
            String objectType = "Attachment" + document.getId() + "_" + language;
            FullIndexEntry indexEntry = new FullIndexEntry(document.getInstanceId(), objectType, document.getForeignId());
            indexEntry.setLang(language);
            indexEntry.setCreationDate(document.getCreated());
            indexEntry.setCreationUser(document.getCreatedBy());
            if (startOfVisibility != null) {
                indexEntry.setStartDate(DateUtil.date2SQLDate(startOfVisibility));
            }
            if (endOfVisibility != null) {
                indexEntry.setEndDate(DateUtil.date2SQLDate(endOfVisibility));
            }
            indexEntry.setTitle(document.getTitle(), language);
            indexEntry.setPreview(document.getDescription(), language);
            indexEntry.setFilename(document.getFilename());
            indexEntry.addFileContent(document.getAttachmentPath(), "UTF-8", document.getContentType(), language);
            if (StringUtil.isDefined(document.getXmlFormId())) {
                this.updateIndexEntryWithXMLFormContent(document.getPk(), document.getXmlFormId(), indexEntry);
            }
            IndexEngineProxy.addIndexEntry(indexEntry);
        }
    }

    private void updateIndexEntryWithXMLFormContent(SimpleDocumentPK pk, String xmlFormName, FullIndexEntry indexEntry) {
        try {
            String objectType = "Attachment";
            PublicationTemplate pub = PublicationTemplateManager.getInstance().getPublicationTemplate(indexEntry.getComponent() + ":" + objectType + ":" + xmlFormName);
            RecordSet set = pub.getRecordSet();
            set.indexRecord(pk.getId(), xmlFormName, indexEntry);
        }
        catch (PublicationTemplateException e) {
            SilverTrace.error("attachment", "AttachmentService.updateIndexEntryWithXMLFormContent()", "", e);
        }
        catch (FormException e) {
            SilverTrace.error("attachment", "AttachmentService.updateIndexEntryWithXMLFormContent()", "", e);
        }
    }

    private void deleteIndex(SimpleDocument document, String lang) {
        SilverTrace.debug("attachment", "DocumentService.deleteIndex", "root.MSG_GEN_ENTER_METHOD", document.getId());
        String language = lang;
        if (language == null) {
            language = I18NHelper.defaultLanguage;
        }
        String objectType = "Attachment" + document.getId() + '_' + language;
        IndexEntryPK indexEntry = new IndexEntryPK(document.getInstanceId(), objectType, document.getForeignId());
        IndexEngineProxy.removeIndexEntry(indexEntry);
    }

    @Override
    public void unindexAttachmentsOfExternalObject(WAPrimaryKey foreignKey) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> docs = this.repository.listDocumentsByForeignId(session, foreignKey.getInstanceId(), foreignKey.getId(), I18NHelper.defaultLanguage);
            for (SimpleDocument doc : docs) {
                this.deleteIndex(doc, I18NHelper.defaultLanguage);
            }
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void addXmlForm(SimpleDocumentPK pk, String language, String xmlFormName) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            SimpleDocument doc = this.repository.findDocumentById(session, pk, language);
            doc.setXmlFormId(xmlFormName);
            this.repository.updateDocument(session, doc);
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public SimpleDocument createAttachment(SimpleDocument document, InputStream content) throws AttachmentException {
        return this.createAttachment(document, content, true);
    }

    @Override
    public SimpleDocument createAttachment(SimpleDocument document, InputStream content, boolean indexIt) {
        return this.createAttachment(document, content, indexIt, true);
    }

    @Override
    public SimpleDocument createAttachment(SimpleDocument document, InputStream content, boolean indexIt, boolean invokeCallback) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            SimpleDocumentPK docPk = this.repository.createDocument(session, document);
            if (invokeCallback && StringUtil.isDefined(document.getCreatedBy())) {
                CallBackManager callBackManager = CallBackManager.get();
                callBackManager.invoke(9, Integer.parseInt(document.getCreatedBy()), document.getInstanceId(), document.getForeignId());
            }
            session.save();
            SimpleDocument createdDocument = this.repository.findDocumentById(session, docPk, document.getLanguage());
            createdDocument.setPublicDocument(document.isPublic());
            SimpleDocument finalDocument = this.repository.unlock(session, createdDocument, false);
            this.repository.storeContent(finalDocument, content, false);
            if (indexIt) {
                this.createIndex(finalDocument);
            }
            SimpleDocument simpleDocument = finalDocument;
            return simpleDocument;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void deleteAttachment(SimpleDocument document) {
        this.deleteAttachment(document, true);
    }

    @Override
    public void deleteAttachment(SimpleDocument document, boolean invokeCallback) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            this.deleteAttachment(session, document, invokeCallback);
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    private void deleteAttachment(Session session, SimpleDocument document, boolean invokeCallback) throws RepositoryException {
        this.repository.fillNodeName(session, document);
        this.repository.deleteDocument(session, document.getPk());
        for (String lang : I18NHelper.getAllSupportedLanguages()) {
            this.deleteIndex(document, lang);
        }
        if (document.isOpenOfficeCompatible() && !document.isReadOnly()) {
            this.webdavRepository.deleteAttachmentNode(session, document);
        }
        if (invokeCallback) {
            AttachmentNotificationService notificationService = AttachmentNotificationService.getService();
            notificationService.notifyOnDeletionOf(document);
        }
    }

    @Override
    public SimpleDocument searchDocumentById(SimpleDocumentPK primaryKey, String lang) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            if (StringUtil.isDefined(primaryKey.getId()) && !StringUtil.isLong(primaryKey.getId())) {
                SimpleDocument simpleDocument = this.repository.findDocumentById(session, primaryKey, lang);
                return simpleDocument;
            }
            SimpleDocument doc = this.repository.findDocumentByOldSilverpeasId(session, primaryKey.getComponentName(), primaryKey.getOldSilverpeasId(), false, lang);
            if (doc == null) {
                doc = this.repository.findDocumentByOldSilverpeasId(session, primaryKey.getComponentName(), primaryKey.getOldSilverpeasId(), true, lang);
            }
            SimpleDocument simpleDocument = doc;
            return simpleDocument;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public List<SimpleDocument> listAllDocumentsByForeignKey(WAPrimaryKey foreignKey, String lang) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> list = this.repository.listAllDocumentsByForeignId(session, foreignKey.getInstanceId(), foreignKey.getId(), lang);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public List<SimpleDocument> listDocumentsByForeignKey(WAPrimaryKey foreignKey, String lang) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> list = this.repository.listDocumentsByForeignId(session, foreignKey.getInstanceId(), foreignKey.getId(), lang);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void updateAttachment(SimpleDocument document, boolean indexIt, boolean invokeCallback) {
        Session session = null;
        try {
            String userId;
            session = BasicDaoFactory.getSystemSession();
            SimpleDocument oldAttachment = this.repository.findDocumentById(session, document.getPk(), document.getLanguage());
            this.repository.fillNodeName(session, document);
            this.repository.updateDocument(session, document);
            if (!oldAttachment.isVersioned() && document.isOpenOfficeCompatible() && document.isReadOnly()) {
                if (!oldAttachment.getFilename().equals(document.getFilename())) {
                    this.webdavRepository.deleteAttachmentNode(session, oldAttachment);
                    this.webdavRepository.createAttachmentNode(session, document);
                } else {
                    this.webdavRepository.updateAttachment(session, document);
                }
            }
            if ((userId = document.getUpdatedBy()) != null && userId.length() > 0 && invokeCallback) {
                CallBackManager callBackManager = CallBackManager.get();
                callBackManager.invoke(10, Integer.parseInt(userId), document.getInstanceId(), document.getForeignId());
            }
            if (indexIt) {
                this.createIndex(document);
            }
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void updateAttachment(SimpleDocument document, InputStream in, boolean indexIt, boolean invokeCallback) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            String owner = document.getEditedBy();
            if (!StringUtil.isDefined(owner)) {
                owner = document.getUpdatedBy();
            }
            boolean checkinRequired = this.repository.lock(session, document, owner);
            this.repository.updateDocument(session, document);
            this.repository.addContent(session, document.getPk(), document.getFile());
            this.repository.fillNodeName(session, document);
            SimpleDocument finalDocument = document;
            if (checkinRequired) {
                finalDocument = this.repository.unlock(session, document, false);
            }
            this.repository.storeContent(finalDocument, in, true);
            if (document.isOpenOfficeCompatible() && finalDocument.isReadOnly()) {
                this.webdavRepository.updateNodeAttachment(session, finalDocument);
            }
            this.repository.duplicateContent(document, finalDocument);
            String userId = finalDocument.getUpdatedBy();
            if (StringUtil.isDefined(userId) && invokeCallback && finalDocument.isPublic()) {
                CallBackManager callBackManager = CallBackManager.get();
                callBackManager.invoke(10, Integer.parseInt(userId), finalDocument.getInstanceId(), finalDocument.getForeignId());
            }
            if (indexIt) {
                this.createIndex(finalDocument);
            }
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void removeContent(SimpleDocument document, String lang, boolean invokeCallback) {
        Session session = null;
        try {
            String userId;
            session = BasicDaoFactory.getSystemSession();
            boolean requireLock = this.repository.lock(session, document, document.getEditedBy());
            this.repository.removeContent(session, document.getPk(), lang);
            if (document.isOpenOfficeCompatible() && document.isReadOnly()) {
                this.webdavRepository.deleteAttachmentNode(session, document);
            }
            if ((userId = document.getCreatedBy()) != null && userId.length() > 0 && invokeCallback) {
                CallBackManager callBackManager = CallBackManager.get();
                callBackManager.invoke(10, Integer.parseInt(userId), document.getInstanceId(), document.getForeignId());
            }
            this.deleteIndex(document, document.getLanguage());
            session.save();
            SimpleDocument finalDocument = document;
            if (requireLock) {
                finalDocument = this.repository.unlock(session, document, false);
                this.repository.duplicateContent(document, finalDocument);
            }
            finalDocument.setLanguage(lang);
            FileUtils.deleteQuietly((File)new File(finalDocument.getAttachmentPath()));
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SimpleDocumentPK cloneDocument(SimpleDocument original, String foreignCloneId) {
        SimpleDocumentPK simpleDocumentPK;
        Session session = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(original.getAttachmentPath());
            session = BasicDaoFactory.getSystemSession();
            SimpleDocumentPK clonePk = this.repository.copyDocument(session, original, (WAPrimaryKey)new ForeignPK(foreignCloneId, original.getInstanceId()));
            SimpleDocument clone = this.repository.findDocumentById(session, clonePk, null);
            this.repository.copyMultilangContent(original, clone);
            this.repository.setClone(session, original, clone);
            session.save();
            simpleDocumentPK = clonePk;
        }
        catch (RepositoryException ex) {
            try {
                throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
                catch (IOException ex2) {
                    throw new AttachmentException(this.getClass().getName(), 4, "", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                BasicDaoFactory.logout(session);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        BasicDaoFactory.logout(session);
        return simpleDocumentPK;
    }

    @Override
    public SimpleDocumentPK copyDocument(SimpleDocument original, ForeignPK targetPk) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            SimpleDocumentPK copyPk = original instanceof HistorisedDocument ? this.repository.copyDocument(session, (HistorisedDocument)original, (WAPrimaryKey)targetPk) : this.repository.copyDocument(session, original, (WAPrimaryKey)targetPk);
            session.save();
            SimpleDocument copy = this.repository.findDocumentById(session, copyPk, null);
            if (original.isVersioned()) {
                this.repository.copyFullContent(original, copy);
            } else {
                this.repository.copyMultilangContent(original, copy);
            }
            SimpleDocumentPK simpleDocumentPK = copyPk;
            return simpleDocumentPK;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void reorderAttachments(List<SimpleDocumentPK> pks) throws AttachmentException {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            int i = 5;
            for (SimpleDocumentPK pk : pks) {
                SimpleDocument doc = this.repository.findDocumentById(session, pk, null);
                doc.setOrder(i);
                this.repository.setOrder(session, doc);
                i += 5;
            }
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void reorderDocuments(List<SimpleDocument> documents) throws AttachmentException {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            int i = 5;
            for (SimpleDocument doc : documents) {
                doc.setOrder(i);
                this.repository.setOrder(session, doc);
                i += 5;
            }
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getBinaryContent(OutputStream output, SimpleDocumentPK pk, String lang) {
        Session session = null;
        InputStream in = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            in = this.repository.getContent(session, pk, lang);
            IOUtils.copy((InputStream)in, (OutputStream)output);
        }
        catch (IOException ex) {
            try {
                throw new AttachmentException(this.getClass().getName(), 4, "", ex);
                catch (RepositoryException ex2) {
                    throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex2));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                BasicDaoFactory.logout(session);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        BasicDaoFactory.logout(session);
    }

    @Override
    public List<SimpleDocument> listDocumentsRequiringWarning(Date alertDate, String language) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> list = this.repository.listDocumentsRequiringWarning(session, alertDate, language);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public List<SimpleDocument> listExpiringDocuments(Date expiryDate, String language) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> list = this.repository.listExpiringDocuments(session, expiryDate, language);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public List<SimpleDocument> listDocumentsToUnlock(Date expiryDate, String language) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> list = this.repository.listDocumentsToUnlock(session, expiryDate, language);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void updateAttachment(SimpleDocument document, File content, boolean indexIt, boolean invokeCallback) {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(content));
            this.updateAttachment(document, in, indexIt, invokeCallback);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new AttachmentException(this.getClass().getName(), 4, "", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public void getBinaryContent(File file, SimpleDocumentPK pk, String lang) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            this.getBinaryContent(out, pk, lang);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new AttachmentException(this.getClass().getName(), 4, "", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Override
    public SimpleDocument createAttachment(SimpleDocument document, File content) throws AttachmentException {
        return this.createAttachment(document, content, true);
    }

    @Override
    public SimpleDocument createAttachment(SimpleDocument document, File content, boolean indexIt) {
        return this.createAttachment(document, content, indexIt, true);
    }

    @Override
    public SimpleDocument createAttachment(SimpleDocument document, File content, boolean indexIt, boolean invokeCallback) {
        SimpleDocument simpleDocument;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(content));
            simpleDocument = this.createAttachment(document, in, indexIt, invokeCallback);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new AttachmentException(this.getClass().getName(), 4, "", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return simpleDocument;
    }

    @Override
    public boolean unlock(UnlockContext context) {
        Session session = null;
        try {
            String userId;
            session = BasicDaoFactory.getSystemSession();
            SimpleDocument document = this.repository.findDocumentById(session, new SimpleDocumentPK(context.getAttachmentId()), context.getLang());
            if (document.isOpenOfficeCompatible() && !context.isForce() && this.webdavRepository.isNodeLocked(session, document)) {
                boolean bl = false;
                return bl;
            }
            if (!context.isForce() && document.isReadOnly() && !document.getEditedBy().equals(context.getUserId())) {
                boolean bl = false;
                return bl;
            }
            boolean invokeCallback = false;
            if (context.isWebdav() || context.isUpload()) {
                String workerId = document.getEditedBy();
                document.setUpdated(new Date());
                document.setUpdatedBy(workerId);
                invokeCallback = true;
            }
            document.setPublicDocument(context.isPublicVersion());
            document.setComment(context.getComment());
            SimpleDocument finalDocument = this.repository.unlock(session, document, context.isForce());
            if (document.isOpenOfficeCompatible() && !context.isUpload() && context.isWebdav()) {
                this.webdavRepository.updateAttachment(session, finalDocument);
            } else if (finalDocument.isOpenOfficeCompatible() && (context.isUpload() || !context.isWebdav())) {
                this.webdavRepository.deleteAttachmentNode(session, finalDocument);
            } else {
                File file = new File(finalDocument.getAttachmentPath());
                if (!file.exists() && !context.isForce()) {
                    this.repository.duplicateContent(document, finalDocument);
                }
            }
            session.save();
            if (document.isPublic() && StringUtil.isDefined(userId = context.getUserId()) && invokeCallback) {
                CallBackManager callBackManager = CallBackManager.get();
                callBackManager.invoke(10, Integer.parseInt(userId), finalDocument.getInstanceId(), finalDocument.getForeignId());
            }
        }
        catch (IOException e) {
            throw new AttachmentException("AttachmentService.unlock()", 4, "attachment.CHECKIN_FAILED", e);
        }
        catch (RepositoryException e) {
            throw new AttachmentException("AttachmentService.unlock()", 4, "attachment.CHECKIN_FAILED", (Exception)((Object)e));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean lock(String attachmentId, String userId, String language) {
        boolean bl;
        SimpleDocument document;
        Session session;
        block7: {
            session = null;
            SimpleDocumentPK pk = new SimpleDocumentPK(attachmentId);
            session = BasicDaoFactory.getSystemSession();
            document = this.repository.findDocumentById(session, pk, language);
            if (!document.isReadOnly()) break block7;
            boolean bl2 = document.getEditedBy().equals(userId);
            BasicDaoFactory.logout(session);
            return bl2;
        }
        try {
            this.repository.lock(session, document, document.getEditedBy());
            document.edit(userId);
            if (document.isOpenOfficeCompatible()) {
                this.webdavRepository.createAttachmentNode(session, document);
            }
            this.updateAttachment(session, document, false, false);
            session.save();
            bl = true;
        }
        catch (RepositoryException ex) {
            try {
                throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
                catch (IOException ex2) {
                    throw new AttachmentException(this.getClass().getName(), 4, "", ex2);
                }
            }
            catch (Throwable throwable) {
                BasicDaoFactory.logout(session);
                throw throwable;
            }
        }
        BasicDaoFactory.logout(session);
        return bl;
    }

    private void updateAttachment(Session session, SimpleDocument document, boolean indexIt, boolean invokeCallback) throws RepositoryException, IOException {
        String userId;
        SimpleDocument oldAttachment = this.repository.findDocumentById(session, document.getPk(), document.getLanguage());
        this.repository.updateDocument(session, document);
        if (document.isOpenOfficeCompatible() && document.isReadOnly()) {
            if (!oldAttachment.getFilename().equals(document.getFilename())) {
                this.webdavRepository.deleteAttachmentNode(session, oldAttachment);
                this.webdavRepository.createAttachmentNode(session, document);
            } else {
                this.webdavRepository.updateNodeAttachment(session, document);
            }
        }
        if (StringUtil.isDefined(userId = document.getCreatedBy()) && invokeCallback) {
            CallBackManager callBackManager = CallBackManager.get();
            callBackManager.invoke(10, Integer.parseInt(userId), document.getInstanceId(), document.getForeignId());
        }
        if (indexIt) {
            this.createIndex(document);
        }
    }

    @Override
    public SimpleDocumentPK changeVersionState(SimpleDocumentPK pk, String comment) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            SimpleDocumentPK updatedPk = this.repository.changeVersionState(session, pk, comment);
            session.save();
            SimpleDocumentPK simpleDocumentPK = updatedPk;
            return simpleDocumentPK;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public SimpleDocument findExistingDocument(SimpleDocumentPK pk, String fileName, ForeignPK foreign, String lang) {
        List<SimpleDocument> exisitingsDocuments = this.listDocumentsByForeignKey(foreign, lang);
        SimpleDocument document = this.searchDocumentById(pk, lang);
        if (document == null) {
            for (SimpleDocument doc : exisitingsDocuments) {
                if (!doc.getFilename().equalsIgnoreCase(fileName)) continue;
                return doc;
            }
        }
        return document;
    }

    @Override
    public List<SimpleDocument> listDocumentsByForeignKeyAndType(WAPrimaryKey foreignKey, DocumentType type, String lang) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> list = this.repository.listDocumentsByForeignIdAndType(session, foreignKey.getInstanceId(), foreignKey.getId(), type, lang);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public List<SimpleDocument> listDocumentsLockedByUser(String usedId, String language) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> list = this.repository.listDocumentsLockedByUser(session, usedId, language);
            return list;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public SimpleDocumentPK moveDocument(SimpleDocument document, ForeignPK destination) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            SimpleDocumentPK pk = this.repository.moveDocument(session, document, destination);
            SimpleDocument moveDoc = this.repository.findDocumentById(session, pk, null);
            this.repository.moveMultilangContent(document, moveDoc);
            session.save();
            SimpleDocumentPK simpleDocumentPK = pk;
            return simpleDocumentPK;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public void updateIndexEntryWithDocuments(FullIndexEntry indexEntry) {
        if (this.resources.getBoolean("attachment.index.incorporated", true) && !indexEntry.getObjectType().startsWith("Attachment")) {
            ForeignPK pk = new ForeignPK(indexEntry.getObjectId(), indexEntry.getComponent());
            List<SimpleDocument> documents = this.listDocumentsByForeignKey(pk, indexEntry.getLang());
            for (SimpleDocument currentDocument : documents) {
                SimpleDocument version = currentDocument.getLastPublicVersion();
                if (version == null) continue;
                indexEntry.addFileContent(version.getAttachmentPath(), "UTF-8", version.getContentType(), indexEntry.getLang());
            }
        }
    }

    @Override
    public void indexAllDocuments(WAPrimaryKey fk, Date startOfVisibilityPeriod, Date endOfVisibilityPeriod) {
        List<SimpleDocument> documents = this.listAllDocumentsByForeignKey(fk, null);
        for (SimpleDocument currentDocument : documents) {
            this.createIndex(currentDocument, startOfVisibilityPeriod, endOfVisibilityPeriod);
        }
    }

    @Override
    public Map<String, String> mergeDocuments(ForeignPK originalForeignKey, ForeignPK cloneForeignKey, DocumentType type) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> attachments = this.listDocumentsByForeignKeyAndType(originalForeignKey, type, null);
            Map<String, SimpleDocument> clones = this.listDocumentsOfClone(cloneForeignKey, type, null);
            HashMap<String, String> ids = new HashMap<String, String>(clones.size());
            for (SimpleDocument attachment : attachments) {
                if (clones.containsKey(attachment.getId())) {
                    SimpleDocument clone = clones.get(attachment.getId());
                    this.repository.mergeAttachment(session, attachment, clone);
                    this.repository.copyMultilangContent(clone, attachment);
                    this.repository.deleteDocument(session, clone.getPk());
                    ids.put(clone.getId(), attachment.getId());
                    clones.remove(attachment.getId());
                    continue;
                }
                this.deleteAttachment(session, attachment, true);
            }
            if (!clones.isEmpty()) {
                for (SimpleDocument clone : clones.values()) {
                    clone.setCloneId(null);
                    clone.setForeignId(originalForeignKey.getId());
                    this.updateAttachment(clone, false, false);
                }
            }
            session.save();
            HashMap<String, String> hashMap = ids;
            return hashMap;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    private Map<String, SimpleDocument> listDocumentsOfClone(ForeignPK foreignPk, DocumentType type, String lang) {
        List<SimpleDocument> documents = this.listDocumentsByForeignKeyAndType(foreignPk, type, lang);
        HashMap<String, SimpleDocument> result = new HashMap<String, SimpleDocument>(documents.size());
        for (SimpleDocument doc : documents) {
            if (StringUtil.isDefined(doc.getCloneId())) {
                result.put(doc.getCloneId(), doc);
                continue;
            }
            result.put(doc.getId(), doc);
        }
        return result;
    }

    @Override
    public void switchComponentBehaviour(String componentId, boolean toVersionning) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            List<SimpleDocument> attachments = this.repository.listDocumentsByComponentdAndType(session, componentId, DocumentType.attachment, I18NHelper.defaultLanguage);
            for (SimpleDocument attachment : attachments) {
                if (attachment.isVersioned() == toVersionning) continue;
                this.repository.changeVersionState(session, attachment.getPk(), "");
            }
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AttachmentException(this.getClass().getName(), 4, "", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }
}

