/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.model;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;

public class HistorisedDocument
extends SimpleDocument {
    private List<SimpleDocument> history;

    public HistorisedDocument(SimpleDocumentPK pk, String foreignId, int order, SimpleAttachment file) {
        super(pk, foreignId, order, true, file);
    }

    public HistorisedDocument(SimpleDocumentPK pk, String foreignId, int order, String owner, SimpleAttachment file) {
        super(pk, foreignId, order, true, owner, file);
    }

    public HistorisedDocument() {
        super(new SimpleDocumentPK(null), null, 0, true, new SimpleAttachment());
    }

    public HistorisedDocument(SimpleDocument doc) {
        super(doc.getPk(), doc.getForeignId(), doc.getOrder(), true, doc.getEditedBy(), doc.getReservation(), doc.getAlert(), doc.getExpiry(), doc.getComment(), doc.getFile());
        this.setMajorVersion(doc.getMajorVersion());
        this.setMinorVersion(doc.getMinorVersion());
        this.setStatus(doc.getStatus());
        this.setPublicDocument(doc.isPublic());
        this.setNodeName(doc.getNodeName());
    }

    @Override
    public boolean isVersioned() {
        return true;
    }

    public List<SimpleDocument> getHistory() {
        return this.history;
    }

    public void setHistory(List<SimpleDocument> history) {
        this.history = history;
    }

    public List<SimpleDocument> getPublicVersions() {
        ArrayList<SimpleDocument> publicVersions = new ArrayList<SimpleDocument>(this.history.size());
        for (SimpleDocument document : this.history) {
            if (!document.isPublic()) continue;
            publicVersions.add(document);
        }
        return publicVersions;
    }

    @Override
    public SimpleDocument getLastPublicVersion() {
        if (this.isPublic()) {
            return this;
        }
        for (SimpleDocument document : this.history) {
            if (!document.isPublic()) continue;
            HistorisedDocument historisedDocument = new HistorisedDocument(document);
            historisedDocument.setHistory(this.history);
            return historisedDocument;
        }
        return null;
    }
}

