/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.model;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.util.URLUtils;

public class SimpleDocument
implements Serializable {
    private static final long serialVersionUID = 8778738762037114180L;
    private static final ResourceLocator resources = new ResourceLocator("org.silverpeas.util.attachment.Attachment", "");
    public static final String WEBDAV_FOLDER = "webdav";
    public static final String ATTACHMENT_PREFIX = "attach_";
    public static final String VERSION_PREFIX = "version_";
    public static final String FILE_PREFIX = "file_";
    public static final String DOCUMENT_PREFIX = "simpledoc_";
    private SimpleDocumentPK pk;
    private String foreignId;
    private int order;
    private boolean versioned;
    private String editedBy;
    private Date reservation;
    private Date alert;
    private Date expiry;
    private String status;
    private String cloneId;
    private int minorVersion = 0;
    private int majorVersion = 0;
    private boolean publicDocument = true;
    private String nodeName;
    private String comment;
    private DocumentType documentType = DocumentType.attachment;
    private SimpleAttachment file;

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getCloneId() {
        return this.cloneId;
    }

    public void setCloneId(String cloneId) {
        this.cloneId = cloneId;
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, SimpleAttachment file) {
        this(pk, foreignId, order, versioned, null, file);
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, String editedBy, SimpleAttachment file) {
        this(pk, foreignId, order, versioned, editedBy, null, null, null, null, file);
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, Date reservation, Date alert, Date expiry, String comment, SimpleAttachment file) {
        this.pk = pk;
        this.foreignId = foreignId;
        this.order = order;
        this.versioned = versioned;
        this.setReservation(reservation);
        this.alert = DateUtil.getBeginOfDay(alert);
        this.expiry = DateUtil.getBeginOfDay(expiry);
        this.comment = comment;
        this.file = file;
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, String editedBy, Date reservation, Date alert, Date expiry, String comment, SimpleAttachment file) {
        this.pk = pk;
        this.foreignId = foreignId;
        this.order = order;
        this.versioned = versioned;
        this.editedBy = editedBy;
        this.setReservation(reservation);
        this.alert = DateUtil.getBeginOfDay(alert);
        this.expiry = DateUtil.getBeginOfDay(expiry);
        this.comment = comment;
        this.file = file;
    }

    public SimpleDocument() {
    }

    public String getFilename() {
        return this.file.getFilename();
    }

    public void setFilename(String filename) {
        this.file.setFilename(filename);
    }

    public String getLanguage() {
        return this.file.getLanguage();
    }

    public void setLanguage(String language) {
        this.file.setLanguage(language);
    }

    public String getTitle() {
        return this.file.getTitle();
    }

    public void setTitle(String title) {
        this.file.setTitle(title);
    }

    public String getDescription() {
        return this.file.getDescription();
    }

    public void setDescription(String description) {
        this.file.setDescription(description);
    }

    public long getSize() {
        return this.file.getSize();
    }

    public void setSize(long size) {
        this.file.setSize(size);
    }

    public String getContentType() {
        return this.file.getContentType();
    }

    public void setContentType(String contentType) {
        this.file.setContentType(contentType);
    }

    public String getCreatedBy() {
        return this.file.getCreatedBy();
    }

    public Date getCreated() {
        return this.file.getCreated();
    }

    public void setCreated(Date created) {
        this.file.setCreated(created);
    }

    public String getUpdatedBy() {
        return this.file.getUpdatedBy();
    }

    public void setUpdatedBy(String updatedBy) {
        this.file.setUpdatedBy(updatedBy);
    }

    public Date getUpdated() {
        return this.file.getUpdated();
    }

    public void setUpdated(Date updated) {
        this.file.setUpdated(updated);
    }

    public Date getReservation() {
        if (this.reservation == null) {
            return null;
        }
        return new Date(this.reservation.getTime());
    }

    public final void setReservation(Date reservationDate) {
        this.reservation = reservationDate == null ? null : new Date(reservationDate.getTime());
    }

    public Date getAlert() {
        if (this.alert == null) {
            return null;
        }
        return new Date(this.alert.getTime());
    }

    public void setAlert(Date alert) {
        this.alert = DateUtil.getBeginOfDay(alert);
    }

    public Date getExpiry() {
        if (this.expiry == null) {
            return null;
        }
        return new Date(this.expiry.getTime());
    }

    public void setExpiry(Date expiry) {
        this.expiry = DateUtil.getBeginOfDay(expiry);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEditedBy() {
        return this.editedBy;
    }

    public void edit(String currentEditor) {
        this.editedBy = currentEditor;
        this.reservation = new Date();
        OrganisationControllerFactory.getFactory();
        String day = OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(this.getInstanceId(), "nbDayForReservation");
        if (StringUtil.isInteger(day)) {
            int result;
            int nbDay = Integer.parseInt(day);
            Calendar calendar = Calendar.getInstance();
            DateUtil.addDaysExceptWeekEnds(calendar, nbDay);
            this.setExpiry(calendar.getTime());
            int delayReservedFile = resources.getInteger("DelayReservedFile", -1);
            if (delayReservedFile >= 0 && delayReservedFile <= 100 && (result = nbDay * delayReservedFile / 100) > 2) {
                calendar = Calendar.getInstance();
                DateUtil.addDaysExceptWeekEnds(calendar, result);
                this.setAlert(calendar.getTime());
            }
        }
    }

    public void release() {
        this.editedBy = null;
        this.reservation = null;
        this.setExpiry(null);
        this.setAlert(null);
    }

    public String getXmlFormId() {
        return this.file.getXmlFormId();
    }

    public void setXmlFormId(String xmlFormId) {
        this.file.setXmlFormId(xmlFormId);
    }

    public String getId() {
        if (this.pk != null) {
            return this.pk.getId();
        }
        return null;
    }

    public void setId(String id) {
        if (this.pk != null) {
            this.pk.setId(id);
        } else {
            this.pk = new SimpleDocumentPK(id);
        }
    }

    public void setPK(SimpleDocumentPK pk) {
        this.pk = pk;
    }

    public String getInstanceId() {
        return this.pk.getInstanceId();
    }

    public long getOldSilverpeasId() {
        return this.pk.getOldSilverpeasId();
    }

    public void setOldSilverpeasId(long oldSilverpeasId) {
        this.pk.setOldSilverpeasId(oldSilverpeasId);
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public void setForeignId(String foreignId) {
        this.foreignId = foreignId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public SimpleAttachment getFile() {
        return this.file;
    }

    public SimpleDocumentPK getPk() {
        return this.pk;
    }

    public void setFile(SimpleAttachment file) {
        this.file = file;
    }

    public boolean isPublic() {
        return this.publicDocument;
    }

    public void setPublicDocument(boolean publicDocument) {
        this.publicDocument = publicDocument;
    }

    public void unlock() {
        this.editedBy = null;
        this.expiry = null;
        this.alert = null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String computeNodeName() {
        if (!StringUtil.isDefined(this.nodeName)) {
            if (this.getOldSilverpeasId() <= 0L) {
                this.setOldSilverpeasId(DBUtil.getNextId("sb_simple_document", "id"));
            }
            this.setNodeName(DOCUMENT_PREFIX + this.getOldSilverpeasId());
            return this.getNodeName();
        }
        return this.getNodeName();
    }

    public String getFullJcrContentPath() {
        return this.getFullJcrPath() + '/' + this.file.getNodeName();
    }

    public String getFullJcrPath() {
        return '/' + this.getInstanceId() + '/' + this.getFolder() + '/' + this.getNodeName();
    }

    public String getDisplayIcon() {
        return FileRepositoryManager.getFileIcon(FileRepositoryManager.getFileExtension(this.getFilename()));
    }

    public boolean isOpenOfficeCompatible() {
        return FileUtil.isOpenOfficeCompatible(this.getFilename());
    }

    public boolean isReadOnly() {
        return StringUtil.isDefined(this.getEditedBy());
    }

    public String getAttachmentPath() {
        String lang = this.getLanguage();
        if (!StringUtil.isDefined(lang)) {
            lang = I18NHelper.defaultLanguage;
        }
        return this.getDirectoryPath(lang) + this.getFilename();
    }

    public String getDirectoryPath(String language) {
        String directory = FileRepositoryManager.getAbsolutePath(this.getInstanceId());
        directory = directory.replace('/', File.separatorChar);
        String versionDir = this.getMajorVersion() + "_" + this.getMinorVersion();
        String lang = language;
        if (!StringUtil.isDefined(lang)) {
            lang = I18NHelper.defaultLanguage;
        }
        return directory + this.getNodeName() + File.separatorChar + versionDir + File.separatorChar + lang + File.separatorChar;
    }

    public String toString() {
        return "SimpleDocument{" + this.nodeName + " pk=" + this.pk + ", foreignId=" + this.foreignId + ", order=" + this.order + ", versioned=" + this.versioned + ", editedBy=" + this.editedBy + ", reservation=" + this.reservation + ", alert=" + this.alert + ", expiry=" + this.expiry + ", status=" + this.status + ", cloneId=" + this.cloneId + ", file=" + this.file + ", minorVersion=" + this.minorVersion + ", majorVersion=" + this.majorVersion + ", comment=" + this.comment + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (this.pk != null ? this.pk.hashCode() : 0);
        hash = 31 * hash + this.minorVersion;
        hash = 31 * hash + this.majorVersion;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleDocument)) {
            return false;
        }
        SimpleDocument other = (SimpleDocument)obj;
        if (!(this.pk == other.pk || this.pk != null && this.pk.equals(other.pk))) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        return this.majorVersion == other.majorVersion;
    }

    public String getAttachmentURL() {
        return FileServerUtils.getAttachmentURL(this.pk.getInstanceId(), this.getFilename(), this.pk.getId(), this.getLanguage());
    }

    public String getUniversalURL() {
        return URLManager.getSimpleURL(4, this.getId());
    }

    public String getOnlineURL() {
        String onlineUrl = FileServerUtils.getOnlineURL(this.pk.getComponentName(), this.getFilename(), "", this.getContentType(), "");
        String extension = FileRepositoryManager.getFileExtension(this.getFilename());
        if ("exe".equalsIgnoreCase(extension) || "pdf".equalsIgnoreCase(extension)) {
            onlineUrl = onlineUrl + "&logicalName=" + URLUtils.encodePathParamValue(this.getFilename());
        }
        return onlineUrl;
    }

    public String getAliasURL() {
        String extension;
        String aliasUrl = FileServerUtils.getAliasURL(this.pk.getInstanceId(), this.getFilename(), this.pk.getId());
        if (I18NHelper.isI18N && !I18NHelper.isDefaultLanguage(this.getLanguage())) {
            aliasUrl = aliasUrl + "&lang=" + this.getLanguage();
        }
        if ("exe".equalsIgnoreCase(extension = FileRepositoryManager.getFileExtension(this.getFilename())) || "pdf".equalsIgnoreCase(extension)) {
            aliasUrl = aliasUrl + "&logicalName=" + URLUtils.encodePathParamValue(this.getFilename());
        }
        return aliasUrl;
    }

    public String getWebdavUrl() {
        String[] pathParts;
        StringBuilder url = new StringBuilder(500);
        String webAppContext = URLManager.getApplicationURL();
        url.append(webAppContext);
        if (!webAppContext.endsWith("/")) {
            url.append('/');
        }
        url.append(URLUtils.encodePathSegment(GeneralPropertiesManager.getString("webdav.respository"))).append('/').append(URLUtils.encodePathSegment(GeneralPropertiesManager.getString("webdav.workspace")));
        for (String pathElement : pathParts = StringUtil.split((String)this.getWebdavJcrPath(), (char)'/')) {
            url.append('/');
            url.append(URLUtils.encodePathSegment(pathElement));
        }
        return url.toString();
    }

    public String getWebdavJcrPath() {
        StringBuilder jcrPath = new StringBuilder(500);
        jcrPath.append(WEBDAV_FOLDER).append('/').append(DocumentType.attachment.getFolderName()).append('/').append(this.getInstanceId()).append('/');
        if (this.getId() != null) {
            jcrPath.append(this.getId()).append('/');
        }
        if (this.getLanguage() != null) {
            jcrPath.append(this.getLanguage()).append('/');
        }
        jcrPath.append(StringUtil.escapeQuote(this.getFilename()));
        return jcrPath.toString();
    }

    @Deprecated
    public String getWebURL() {
        return FileServerUtils.getAttachmentURL(this.pk.getInstanceId(), this.getFilename(), this.pk.getId(), this.getLanguage());
    }

    public SimpleDocument getLastPublicVersion() {
        return this;
    }

    public String getFolder() {
        return this.documentType.getFolderName();
    }
}

