/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.notification;

import com.silverpeas.notification.NotificationPublisher;
import com.silverpeas.notification.NotificationTopic;
import com.silverpeas.notification.RegisteredTopics;
import javax.inject.Inject;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.notification.AttachmentDeletionNotification;

public class AttachmentNotificationService {
    private static final AttachmentNotificationService instance = new AttachmentNotificationService();
    @Inject
    private NotificationPublisher publisher;

    public static AttachmentNotificationService getService() {
        return instance;
    }

    public void notifyOnDeletionOf(SimpleDocument attachment) {
        AttachmentDeletionNotification deletion = new AttachmentDeletionNotification(attachment);
        this.publisher.publish(deletion, NotificationTopic.onTopic(RegisteredTopics.ATTACHMENT_TOPIC));
    }

    private AttachmentNotificationService() {
    }
}

