/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.repository;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.repository.HistoryDocumentSorter;
import org.silverpeas.attachment.repository.SimpleAttachmentConverter;
import org.silverpeas.util.jcr.AbstractJcrConverter;

class DocumentConverter
extends AbstractJcrConverter {
    final SimpleAttachmentConverter attachmentConverter = new SimpleAttachmentConverter();

    DocumentConverter() {
    }

    List<SimpleDocument> convertDocumentHistory(Node node, String lang) throws RepositoryException {
        try {
            VersionManager versionManager = node.getSession().getWorkspace().getVersionManager();
            String path = node.getPath();
            VersionHistory history = versionManager.getVersionHistory(path);
            Version root = history.getRootVersion();
            String rootId = "";
            if (root != null) {
                rootId = root.getIdentifier();
            }
            Version base = versionManager.getBaseVersion(path);
            String baseId = "";
            if (base != null) {
                baseId = base.getIdentifier();
            }
            VersionIterator versionsIterator = history.getAllVersions();
            ArrayList<SimpleDocument> documentHistory = new ArrayList<SimpleDocument>((int)versionsIterator.getSize());
            while (versionsIterator.hasNext()) {
                Version version = versionsIterator.nextVersion();
                if (version.getIdentifier().equals(rootId) || version.getIdentifier().equals(baseId)) continue;
                SimpleDocument versionDocument = this.fillDocument(version.getFrozenNode(), lang);
                versionDocument.setNodeName(node.getName());
                documentHistory.add(versionDocument);
            }
            HistoryDocumentSorter.sortHistory(documentHistory);
            return documentHistory;
        }
        catch (RepositoryException ex) {
            if (ex.getCause() instanceof NoSuchItemStateException) {
                return new ArrayList<SimpleDocument>(0);
            }
            throw ex;
        }
    }

    public SimpleDocument convertNode(Node node, String lang) throws RepositoryException {
        if (this.isVersioned(node)) {
            HistorisedDocument document = new HistorisedDocument(this.fillDocument(node, lang));
            List<SimpleDocument> history = this.convertDocumentHistory(node, lang);
            document.setHistory(history);
            return document;
        }
        if (node.getParent() != null && node.getParent() instanceof Version) {
            HistorisedDocument document = new HistorisedDocument(this.fillDocument(node, lang));
            Node fullNode = this.getCurrentNodeForVersion((Version)node.getParent());
            document.setHistory(this.convertDocumentHistory(fullNode, lang));
            return document;
        }
        return this.fillDocument(node, lang);
    }

    public Node getCurrentNodeForVersion(Version version) throws RepositoryException {
        String uuid = version.getContainingHistory().getVersionableIdentifier();
        return version.getSession().getNodeByIdentifier(uuid);
    }

    public List<SimpleDocument> convertNodeIterator(NodeIterator iter, String language) throws RepositoryException {
        ArrayList<SimpleDocument> result = new ArrayList<SimpleDocument>((int)iter.getSize());
        while (iter.hasNext()) {
            result.add(this.convertNode(iter.nextNode(), language));
        }
        return result;
    }

    SimpleDocument fillDocument(Node node, String lang) throws RepositoryException {
        SimpleAttachment file;
        SimpleDocumentPK pk = new SimpleDocumentPK(node.getIdentifier(), this.getStringProperty(node, "slv:instanceId"));
        long oldSilverpeasId = this.getLongProperty(node, "slv:oldSilverpeasId");
        pk.setOldSilverpeasId(oldSilverpeasId);
        String language = lang;
        if (language == null) {
            language = I18NHelper.defaultLanguage;
        }
        if ((file = this.getAttachment(node, language)) == null) {
            Iterator<String> iter = I18NHelper.getLanguages();
            while (iter.hasNext() && file == null) {
                file = this.getAttachment(node, iter.next());
            }
        }
        SimpleDocument doc = new SimpleDocument(pk, this.getStringProperty(node, "slv:foreignKey"), this.getIntProperty(node, "slv:order"), this.getBooleanProperty(node, "slv:versioned"), this.getStringProperty(node, "slv:owner"), this.getDateProperty(node, "slv:reservationDate"), this.getDateProperty(node, "slv:alertDate"), this.getDateProperty(node, "slv:expiryDate"), this.getStringProperty(node, "slv:comment"), file);
        doc.setCloneId(this.getStringProperty(node, "slv:clone"));
        doc.setMajorVersion(this.getIntProperty(node, "slv:major"));
        doc.setMinorVersion(this.getIntProperty(node, "slv:minor"));
        doc.setStatus(this.getStringProperty(node, "slv:status"));
        doc.setDocumentType(DocumentType.fromFolderName(node.getParent().getName()));
        String nodeName = node.getName();
        if ("jcr:frozenNode".equals(nodeName)) {
            nodeName = doc.computeNodeName();
            doc.setNodeName(nodeName);
            if (!node.getSession().nodeExists(doc.getFullJcrPath())) {
                nodeName = "version_" + doc.getOldSilverpeasId();
            }
        }
        doc.setNodeName(nodeName);
        doc.setPublicDocument(!doc.isVersioned() || doc.getMinorVersion() == 0);
        return doc;
    }

    protected SimpleAttachment getAttachment(Node node, String language) throws RepositoryException {
        String attachmentNodeName = "file_" + language;
        if (node.hasNode(attachmentNodeName)) {
            return this.attachmentConverter.convertNode(node.getNode(attachmentNodeName));
        }
        return null;
    }

    public void fillNode(SimpleDocument document, Node documentNode) throws RepositoryException {
        this.setDocumentNodeProperties(document, documentNode);
        Node attachmentNode = this.getAttachmentNode(document.getFile().getNodeName(), documentNode);
        this.attachmentConverter.fillNode(document.getFile(), attachmentNode);
    }

    private void setDocumentNodeProperties(SimpleDocument document, Node documentNode) throws RepositoryException {
        this.addStringProperty(documentNode, "slv:foreignKey", document.getForeignId());
        documentNode.setProperty("slv:versioned", document.isVersioned());
        documentNode.setProperty("slv:order", (long)document.getOrder());
        documentNode.setProperty("slv:oldSilverpeasId", document.getOldSilverpeasId());
        this.addStringProperty(documentNode, "slv:instanceId", document.getInstanceId());
        this.addStringProperty(documentNode, "slv:owner", document.getEditedBy());
        this.addStringProperty(documentNode, "slv:comment", document.getComment());
        this.addStringProperty(documentNode, "slv:status", document.getStatus());
        this.addDateProperty(documentNode, "slv:alertDate", document.getAlert());
        this.addDateProperty(documentNode, "slv:expiryDate", document.getExpiry());
        this.addDateProperty(documentNode, "slv:reservationDate", document.getReservation());
        this.addStringProperty(documentNode, "slv:clone", document.getCloneId());
    }

    private Node getAttachmentNode(String attachmentNodeName, Node documentNode) throws RepositoryException {
        Node attachmentNode = documentNode.hasNode(attachmentNodeName) ? documentNode.getNode(attachmentNodeName) : documentNode.addNode(attachmentNodeName, "slv:simpleAttachment");
        return attachmentNode;
    }

    public void addAttachment(Node documentNode, SimpleAttachment attachment) throws RepositoryException {
        Node attachmentNode = this.getAttachmentNode(attachment.getNodeName(), documentNode);
        this.attachmentConverter.fillNode(attachment, attachmentNode);
    }

    public void removeAttachment(Node documentNode, String language) throws RepositoryException {
        String lang = language;
        if (lang == null) {
            lang = I18NHelper.defaultLanguage;
        }
        if (documentNode.hasNode("file_" + lang)) {
            Node attachmentNode = documentNode.getNode("file_" + lang);
            attachmentNode.remove();
        }
    }

    public boolean isVersioned(Node node) throws RepositoryException {
        return this.getBooleanProperty(node, "slv:versioned") && !node.hasProperty("{http://www.jcp.org/jcr/1.0}frozenPrimaryType") && this.isMixinApplied(node, "{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
    }

    public boolean isForm(Node node) throws RepositoryException {
        return node.getPath().contains('/' + DocumentType.form.getFolderName() + '/');
    }

    public String updateVersion(Node node, String lang, boolean isPublic) throws RepositoryException {
        int majorVersion = this.getIntProperty(node, "slv:major");
        int minorVersion = this.getIntProperty(node, "slv:minor");
        if (this.isVersioned(node) && node.isCheckedOut()) {
            this.releaseDocumentNode(node, lang);
            if (isPublic) {
                minorVersion = 0;
                node.setProperty("slv:major", (long)(++majorVersion));
                node.setProperty("slv:minor", 0L);
            } else {
                node.setProperty("slv:minor", (long)(++minorVersion));
                if (!node.hasProperty("slv:major")) {
                    node.setProperty("slv:major", 0L);
                }
            }
        }
        return "Version " + majorVersion + "." + minorVersion;
    }

    public void releaseDocumentNode(Node documentNode, String lang) throws RepositoryException {
        String attachmentNodeName;
        String language = lang;
        if (!StringUtil.isDefined(language)) {
            language = I18NHelper.defaultLanguage;
        }
        if (documentNode.hasNode(attachmentNodeName = "file_" + language)) {
            Node attachmentNode = this.getAttachmentNode(attachmentNodeName, documentNode);
            this.addStringProperty(attachmentNode, "{http://www.jcp.org/jcr/1.0}lastModifiedBy", this.getStringProperty(documentNode, "slv:owner"));
        }
        this.addDateProperty(documentNode, "slv:expiryDate", null);
        this.addDateProperty(documentNode, "slv:alertDate", null);
        this.addDateProperty(documentNode, "slv:reservationDate", null);
        this.addStringProperty(documentNode, "slv:owner", null);
    }
}

