/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.repository;

import com.silverpeas.jcrutil.BasicDaoFactory;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.inject.Named;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.io.FileUtils;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.repository.DocumentConverter;
import org.silverpeas.util.jcr.NodeIterable;
import org.silverpeas.util.jcr.PropertyIterable;

@Named(value="documentRepository")
public class DocumentRepository {
    private static final String SIMPLE_DOCUMENT_ALIAS = "SimpleDocuments";
    final DocumentConverter converter = new DocumentConverter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareComponentAttachments(String instanceId, String folder) throws RepositoryException {
        Session session = BasicDaoFactory.getSystemSession();
        try {
            this.prepareComponentAttachments(session, instanceId, folder);
            session.save();
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    protected Node prepareComponentAttachments(Session session, String instanceId, String folder) throws RepositoryException {
        Node targetInstanceNode = this.converter.getFolder(session.getRootNode(), instanceId);
        return this.converter.getFolder(targetInstanceNode, folder);
    }

    public SimpleDocumentPK createDocument(Session session, SimpleDocument document) throws RepositoryException {
        SimpleDocument last = this.findLast(session, document.getInstanceId(), document.getForeignId());
        if (null != last && 0 >= document.getOrder()) {
            document.setOrder(last.getOrder() + 1);
        }
        Node docsNode = this.prepareComponentAttachments(session, document.getInstanceId(), document.getFolder());
        Node documentNode = docsNode.addNode(document.computeNodeName(), "slv:simpleDocument");
        document.setUpdatedBy(document.getCreatedBy());
        document.setUpdated(document.getCreated());
        this.converter.fillNode(document, documentNode);
        if (document.isVersioned()) {
            documentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
        }
        document.setId(documentNode.getIdentifier());
        document.setOldSilverpeasId(documentNode.getProperty("slv:oldSilverpeasId").getLong());
        return document.getPk();
    }

    public SimpleDocumentPK moveDocument(Session session, SimpleDocument document, WAPrimaryKey destination) throws RepositoryException {
        SimpleDocument targetDoc = new SimpleDocument();
        SimpleDocumentPK pk = new SimpleDocumentPK(null, destination.getInstanceId());
        pk.setOldSilverpeasId(document.getOldSilverpeasId());
        targetDoc.setPK(pk);
        targetDoc.setDocumentType(document.getDocumentType());
        targetDoc.setNodeName(document.getNodeName());
        this.prepareComponentAttachments(session, destination.getInstanceId(), document.getFolder());
        Node originDocumentNode = session.getNodeByIdentifier(document.getPk().getId());
        if (this.converter.isVersioned(originDocumentNode) && !originDocumentNode.isCheckedOut()) {
            this.checkoutNode(originDocumentNode, document.getUpdatedBy());
        }
        if (!document.getFullJcrPath().equals(targetDoc.getFullJcrPath())) {
            session.move(originDocumentNode.getPath(), targetDoc.getFullJcrPath());
        }
        Node targetDocumentNode = session.getNode(targetDoc.getFullJcrPath());
        this.converter.addStringProperty(targetDocumentNode, "slv:foreignKey", destination.getId());
        this.converter.addStringProperty(targetDocumentNode, "slv:instanceId", destination.getInstanceId());
        pk.setId(targetDocumentNode.getIdentifier());
        return pk;
    }

    public SimpleDocumentPK copyDocument(Session session, SimpleDocument document, WAPrimaryKey destination) throws RepositoryException {
        this.prepareComponentAttachments(destination.getInstanceId(), document.getFolder());
        SimpleDocumentPK pk = new SimpleDocumentPK(null, destination.getInstanceId());
        SimpleDocument targetDoc = document.isVersioned() && document.getDocumentType() == DocumentType.attachment ? new HistorisedDocument() : new SimpleDocument();
        targetDoc.setNodeName(null);
        targetDoc.setPK(pk);
        targetDoc.setDocumentType(document.getDocumentType());
        targetDoc.setForeignId(destination.getId());
        targetDoc.computeNodeName();
        session.getWorkspace().copy(document.getFullJcrPath(), targetDoc.getFullJcrPath());
        Node copy = session.getNode(targetDoc.getFullJcrPath());
        copy.setProperty("slv:oldSilverpeasId", targetDoc.getOldSilverpeasId());
        copy.setProperty("slv:foreignKey", destination.getId());
        copy.setProperty("slv:instanceId", destination.getInstanceId());
        pk.setId(copy.getIdentifier());
        return pk;
    }

    public SimpleDocumentPK copyDocument(Session session, HistorisedDocument document, WAPrimaryKey destination) throws RepositoryException, IOException {
        this.prepareComponentAttachments(destination.getInstanceId(), document.getFolder());
        SimpleDocumentPK pk = new SimpleDocumentPK(null, destination.getInstanceId());
        List<SimpleDocument> history = document.getHistory();
        history.add(document);
        Collections.reverseOrder();
        HistorisedDocument targetDoc = new HistorisedDocument(history.remove(0));
        targetDoc.setNodeName(null);
        targetDoc.setPK(pk);
        targetDoc.setDocumentType(document.getDocumentType());
        targetDoc.setForeignId(destination.getId());
        targetDoc.computeNodeName();
        pk = this.createDocument(session, targetDoc);
        this.unlock(session, targetDoc, false);
        for (SimpleDocument doc : history) {
            this.lock(session, targetDoc, document.getUpdatedBy());
            targetDoc = new HistorisedDocument(doc);
            targetDoc.setPK(pk);
            targetDoc.setForeignId(destination.getId());
            this.updateDocument(session, targetDoc);
            this.unlock(session, targetDoc, false);
        }
        return pk;
    }

    public void updateDocument(Session session, SimpleDocument document) throws RepositoryException, IOException {
        Node documentNode = session.getNodeByIdentifier(document.getPk().getId());
        if (StringUtil.isDefined(document.getEditedBy())) {
            document.setUpdatedBy(document.getEditedBy());
        }
        document.setUpdated(new Date());
        this.converter.fillNode(document, documentNode);
    }

    public void setClone(Session session, SimpleDocument original, SimpleDocument clone) throws RepositoryException {
        boolean checkedin;
        Node documentNode = session.getNodeByIdentifier(clone.getId());
        boolean bl = checkedin = !documentNode.isCheckedOut();
        if (checkedin) {
            session.getWorkspace().getVersionManager().checkout(documentNode.getPath());
        }
        documentNode.setProperty("slv:clone", original.getId());
        if (checkedin) {
            session.save();
            session.getWorkspace().getVersionManager().checkin(documentNode.getPath());
        }
    }

    public void setOrder(Session session, SimpleDocument document) throws RepositoryException {
        boolean checkedin;
        Node documentNode = session.getNodeByIdentifier(document.getPk().getId());
        boolean bl = checkedin = !documentNode.isCheckedOut();
        if (checkedin) {
            session.getWorkspace().getVersionManager().checkout(documentNode.getPath());
        }
        documentNode.setProperty("slv:order", (long)document.getOrder());
        if (checkedin) {
            session.save();
            session.getWorkspace().getVersionManager().checkin(documentNode.getPath());
        }
    }

    public void deleteDocument(Session session, SimpleDocumentPK documentPk) throws RepositoryException {
        try {
            Node documentNode = session.getNodeByIdentifier(documentPk.getId());
            this.deleteContent(documentNode, documentPk.getInstanceId());
            this.deleteDocumentNode(documentNode);
        }
        catch (ItemNotFoundException infex) {
            SilverTrace.info("attachment", "DocumentRepository.deleteDocument()", "", infex);
        }
    }

    public SimpleDocumentPK changeVersionState(Session session, SimpleDocumentPK documentPk, String comment) throws RepositoryException, IOException {
        try {
            SimpleDocument target;
            Node documentNode = session.getNodeByIdentifier(documentPk.getId());
            boolean versionedNode = documentNode.getParent() instanceof Version || this.converter.isVersioned(documentNode);
            Node parent = documentNode.getParent();
            if (parent instanceof Version) {
                Version selectedVersion = (Version)parent;
                VersionManager versionManager = documentNode.getSession().getWorkspace().getVersionManager();
                versionManager.restore(selectedVersion, true);
                documentNode = session.getNodeByIdentifier(selectedVersion.getContainingHistory().getVersionableIdentifier());
            }
            if (!documentNode.isCheckedOut()) {
                this.checkoutNode(documentNode, null);
            }
            if (StringUtil.isDefined(comment)) {
                documentNode.setProperty("slv:comment", comment);
            }
            SimpleDocument origin = this.converter.fillDocument(documentNode, I18NHelper.defaultLanguage);
            if (versionedNode) {
                File[] contents;
                this.removeHistory(documentNode);
                documentNode.removeMixin("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
                documentNode.setProperty("slv:versioned", false);
                documentNode.setProperty("slv:major", 0L);
                documentNode.setProperty("slv:minor", 0L);
                target = this.converter.fillDocument(documentNode, I18NHelper.defaultLanguage);
                this.moveMultilangContent(origin, target);
                File currentDocumentDir = new File(target.getDirectoryPath(I18NHelper.defaultLanguage)).getParentFile();
                for (File versionDirectory : contents = currentDocumentDir.getParentFile().listFiles()) {
                    if (versionDirectory.equals(currentDocumentDir)) continue;
                    FileUtils.deleteDirectory((File)versionDirectory);
                }
            } else {
                documentNode.setProperty("slv:versioned", true);
                documentNode.setProperty("slv:major", 1L);
                documentNode.setProperty("slv:minor", 0L);
                documentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
                target = this.converter.fillDocument(documentNode, I18NHelper.defaultLanguage);
                VersionManager versionManager = documentNode.getSession().getWorkspace().getVersionManager();
                documentNode.getSession().save();
                this.moveMultilangContent(origin, target);
                versionManager.checkin(documentNode.getPath());
            }
            return new SimpleDocumentPK(documentNode.getIdentifier(), documentPk);
        }
        catch (ItemNotFoundException infex) {
            SilverTrace.info("attachment", "DocumentRepository.deleteDocument()", "", infex);
            return documentPk;
        }
    }

    private void deleteDocumentNode(Node documentNode) throws RepositoryException {
        if (null != documentNode) {
            if (this.converter.isVersioned(documentNode)) {
                this.removeHistory(documentNode);
            }
            documentNode.remove();
        }
    }

    public SimpleDocument findDocumentById(Session session, SimpleDocumentPK documentPk, String lang) throws RepositoryException {
        SimpleDocument document = null;
        try {
            Node documentNode = session.getNodeByIdentifier(documentPk.getId());
            document = this.converter.convertNode(documentNode, lang);
        }
        catch (ItemNotFoundException infex) {
            SilverTrace.info("attachment", "DocumentRepository.findDocumentById()", "", infex);
        }
        return document;
    }

    public SimpleDocument findDocumentByOldSilverpeasId(Session session, String instanceId, long oldSilverpeasId, boolean versioned, String lang) throws RepositoryException {
        Comparison versionedComparison;
        Comparison oldSilverpeasIdComparison;
        DescendantNode descendantdNodeConstraint;
        Selector source;
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        QueryObjectModel query = factory.createQuery((Source)(source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS)), (Constraint)factory.and((Constraint)(descendantdNodeConstraint = factory.descendantNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId)), (Constraint)factory.and((Constraint)(oldSilverpeasIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:oldSilverpeasId"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(oldSilverpeasId)))), (Constraint)(versionedComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:versioned"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(versioned)))))), null, null);
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        if (iter.hasNext()) {
            return this.converter.convertNode(iter.nextNode(), lang);
        }
        return null;
    }

    public SimpleDocument findLast(Session session, String instanceId, String foreignId) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignIdAndType(session, instanceId, foreignId, DocumentType.attachment);
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (iter.hasNext()) continue;
            return this.converter.convertNode(node, I18NHelper.defaultLanguage);
        }
        return null;
    }

    public List<SimpleDocument> listDocumentsByForeignId(Session session, String instanceId, String foreignId, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignIdAndType(session, instanceId, foreignId, DocumentType.attachment);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listAllDocumentsByForeignId(Session session, String instanceId, String foreignId, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignId(session, instanceId, foreignId);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listDocumentsByForeignIdAndType(Session session, String instanceId, String foreignId, DocumentType type, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignIdAndType(session, instanceId, foreignId, type);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listDocumentsByComponentdAndType(Session session, String instanceId, DocumentType type, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByComponentIdAndType(session, instanceId, type);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listComponentDocumentsByOwner(Session session, String instanceId, String owner, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByOwnerIdAndComponentId(session, instanceId, owner);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listDocumentsLockedByUser(Session session, String usedId, String language) throws RepositoryException {
        NodeIterator iter = this.selectAllDocumentsByOwnerId(session, usedId);
        return this.converter.convertNodeIterator(iter, language);
    }

    NodeIterator selectAllDocumentsByForeignId(Session session, String instanceId, String foreignId) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        DescendantNode descendantdNodeConstraint = factory.descendantNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId);
        Comparison foreignIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:foreignKey"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(foreignId)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)factory.and((Constraint)descendantdNodeConstraint, (Constraint)foreignIdComparison), new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    NodeIterator selectDocumentsByForeignIdAndType(Session session, String instanceId, String foreignId, DocumentType type) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        ChildNode childNodeConstraint = factory.childNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + '/' + type.getFolderName());
        Comparison foreignIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:foreignKey"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(foreignId)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)factory.and((Constraint)childNodeConstraint, (Constraint)foreignIdComparison), new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    NodeIterator selectDocumentsByForeignId(Session session, String instanceId, String foreignId) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        DescendantNode descendantNodeConstraint = factory.descendantNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + '/');
        Comparison foreignIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:foreignKey"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(foreignId)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)factory.and((Constraint)descendantNodeConstraint, (Constraint)foreignIdComparison), new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    NodeIterator selectDocumentsByComponentIdAndType(Session session, String instanceId, DocumentType type) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        ChildNode childNodeConstraint = factory.childNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + '/' + type.getFolderName());
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)childNodeConstraint, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public List<SimpleDocument> listExpiringDocuments(Session session, Date expiryDate, String language) throws RepositoryException {
        NodeIterator iter = this.selectExpiringDocuments(session, DateUtil.getBeginOfDay(expiryDate));
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listDocumentsRequiringWarning(Session session, Date alertDate, String language) throws RepositoryException {
        NodeIterator iter = this.selectWarningDocuments(session, DateUtil.getBeginOfDay(alertDate));
        return this.converter.convertNodeIterator(iter, language);
    }

    NodeIterator selectExpiringDocuments(Session session, Date expiryDate) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Calendar expiry = Calendar.getInstance();
        expiry.setTime(DateUtil.getBeginOfDay(expiryDate));
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        Comparison foreignIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:expiryDate"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(expiry)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)foreignIdComparison, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public List<SimpleDocument> listDocumentsToUnlock(Session session, Date expiryDate, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsRequiringUnlocking(session, expiryDate);
        return this.converter.convertNodeIterator(iter, language);
    }

    NodeIterator selectDocumentsRequiringUnlocking(Session session, Date expiryDate) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Calendar expiry = Calendar.getInstance();
        expiry.setTime(DateUtil.getBeginOfDay(expiryDate));
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        Comparison foreignIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:expiryDate"), "jcr.operator.less.than", (StaticOperand)factory.literal(session.getValueFactory().createValue(expiry)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)foreignIdComparison, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    NodeIterator selectWarningDocuments(Session session, Date alertDate) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Calendar alert = Calendar.getInstance();
        alert.setTime(DateUtil.getBeginOfDay(alertDate));
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        Comparison foreignIdComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:alertDate"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(alert)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)foreignIdComparison, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    NodeIterator selectDocumentsByOwnerIdAndComponentId(Session session, String instanceId, String owner) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        ChildNode childNodeConstraint = factory.childNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + '/' + DocumentType.attachment.getFolderName());
        Comparison ownerComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:owner"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(owner)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)factory.and((Constraint)childNodeConstraint, (Constraint)ownerComparison), new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    NodeIterator selectAllDocumentsByOwnerId(Session session, String owner) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        Comparison ownerComparison = factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:owner"), "jcr.operator.equal.to", (StaticOperand)factory.literal(session.getValueFactory().createValue(owner)));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)ownerComparison, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public void addContent(Session session, SimpleDocumentPK documentPk, SimpleAttachment attachment) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(documentPk.getId());
        if (this.converter.isVersioned(documentNode) && !documentNode.isCheckedOut()) {
            String owner = attachment.getUpdatedBy();
            if (!StringUtil.isDefined(owner)) {
                owner = attachment.getCreatedBy();
            }
            this.checkoutNode(documentNode, owner);
        }
        this.converter.addAttachment(documentNode, attachment);
    }

    public InputStream getContent(Session session, SimpleDocumentPK pk, String lang) throws RepositoryException, IOException {
        Node docNode = session.getNodeByIdentifier(pk.getId());
        String language = lang;
        if (!StringUtil.isDefined(language)) {
            language = I18NHelper.defaultLanguage;
        }
        SimpleDocument document = this.converter.fillDocument(docNode, language);
        return new BufferedInputStream(FileUtils.openInputStream((File)new File(document.getAttachmentPath())));
    }

    public void removeContent(Session session, SimpleDocumentPK documentPk, String language) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(documentPk.getId());
        if (this.converter.isVersioned(documentNode) && !documentNode.isCheckedOut()) {
            this.checkoutNode(documentNode, null);
        }
        this.converter.removeAttachment(documentNode, language);
        documentNode = session.getNodeByIdentifier(documentPk.getId());
        if (!documentNode.hasNodes()) {
            this.deleteDocumentNode(documentNode);
        }
    }

    public boolean lock(Session session, SimpleDocument document, String owner) throws RepositoryException {
        if (document.isVersioned()) {
            Node documentNode = session.getNodeByIdentifier(document.getId());
            if (!documentNode.isCheckedOut()) {
                this.checkoutNode(documentNode, owner);
            }
            return true;
        }
        return false;
    }

    public SimpleDocument unlock(Session session, SimpleDocument document, boolean restore) throws RepositoryException {
        Node documentNode;
        try {
            documentNode = session.getNodeByIdentifier(document.getId());
        }
        catch (ItemNotFoundException ex) {
            return document;
        }
        if (document.isVersioned() && documentNode.isCheckedOut()) {
            if (restore) {
                VersionIterator iter = session.getWorkspace().getVersionManager().getVersionHistory(document.getFullJcrPath()).getAllVersions();
                Version lastVersion = null;
                while (iter.hasNext()) {
                    lastVersion = iter.nextVersion();
                }
                if (null != lastVersion) {
                    session.getWorkspace().getVersionManager().restore(lastVersion, true);
                    return this.converter.convertNode(lastVersion.getFrozenNode(), document.getLanguage());
                }
            }
            this.converter.fillNode(document, documentNode);
            return this.checkinNode(documentNode, document.getLanguage(), document.isPublic());
        }
        if (!document.isVersioned()) {
            this.converter.fillNode(document, documentNode);
            this.converter.releaseDocumentNode(documentNode, document.getLanguage());
            return this.converter.convertNode(documentNode, document.getLanguage());
        }
        document.release();
        return document;
    }

    void checkoutNode(Node node, String owner) throws RepositoryException {
        node.getSession().getWorkspace().getVersionManager().checkout(node.getPath());
        this.converter.addStringProperty(node, "slv:owner", owner);
    }

    SimpleDocument checkinNode(Node documentNode, String lang, boolean isMajor) throws RepositoryException {
        VersionManager versionManager = documentNode.getSession().getWorkspace().getVersionManager();
        String versionLabel = this.converter.updateVersion(documentNode, lang, isMajor);
        documentNode.getSession().save();
        Version lastVersion = versionManager.checkin(documentNode.getPath());
        lastVersion.getContainingHistory().addVersionLabel(lastVersion.getName(), versionLabel, false);
        SimpleDocument doc = this.converter.convertNode(documentNode, lang);
        return doc;
    }

    public void setVersionnable(Session session, SimpleDocumentPK documentPk) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(documentPk.getId());
        if (!this.converter.isVersioned(documentNode)) {
            documentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
            documentNode.setProperty("slv:versioned", true);
        }
    }

    public void removeVersionnable(Session session, SimpleDocumentPK documentPk) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(documentPk.getId());
        if (this.converter.isVersioned(documentNode)) {
            this.removeHistory(documentNode);
            VersionHistory history = documentNode.getSession().getWorkspace().getVersionManager().getVersionHistory(documentNode.getPath());
            history.remove();
            documentNode.removeMixin("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
        }
        documentNode.setProperty("slv:versioned", false);
    }

    void removeHistory(Node documentNode) throws RepositoryException {
        VersionHistory history = documentNode.getSession().getWorkspace().getVersionManager().getVersionHistory(documentNode.getPath());
        Version root = history.getRootVersion();
        VersionIterator versions = history.getAllVersions();
        while (versions.hasNext()) {
            Version version = versions.nextVersion();
            if (version.isSame((Item)root)) continue;
            history.removeVersion(version.getName());
        }
    }

    public void fillNodeName(Session session, SimpleDocument document) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(document.getId());
        if (!StringUtil.isDefined(document.getNodeName())) {
            document.setNodeName(documentNode.getName());
        }
    }

    public long storeContent(SimpleDocument document, InputStream in, boolean update) throws RepositoryException, IOException {
        File parentFile;
        File file = new File(document.getAttachmentPath());
        SilverTrace.debug("attachment", "DocumentRepository", "Storing file for document in " + document.getAttachmentPath());
        if (update && (parentFile = file.getParentFile()).isDirectory() && parentFile.list().length > 0) {
            FileUtils.deleteQuietly((File)parentFile);
            FileUtils.forceMkdir((File)parentFile);
        }
        FileUtils.copyInputStreamToFile((InputStream)in, (File)file);
        return file.length();
    }

    public long storeContent(SimpleDocument document, InputStream in) throws RepositoryException, IOException {
        return this.storeContent(document, in, false);
    }

    public void duplicateContent(SimpleDocument origin, SimpleDocument document) throws IOException, RepositoryException {
        String originDir = origin.getDirectoryPath(null);
        String targetDir = document.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile();
        File source = new File(originDir).getParentFile();
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        if (!target.exists()) {
            target.mkdir();
        }
        for (File langDir : source.listFiles()) {
            File targetLangDir = new File(target, langDir.getName());
            if (targetLangDir.exists()) continue;
            FileUtils.copyDirectory((File)langDir, (File)targetLangDir);
        }
    }

    public void deleteContent(Node documentNode, String instanceId) throws RepositoryException {
        String directory = FileRepositoryManager.getAbsolutePath(instanceId) + documentNode.getName();
        File documentDirectory = new File(directory = directory.replace('/', File.separatorChar));
        if (documentDirectory.exists() && documentDirectory.isDirectory()) {
            FileUtils.deleteQuietly((File)documentDirectory);
        }
    }

    public void copyMultilangContent(SimpleDocument origin, SimpleDocument copy) throws IOException {
        File source;
        String originDir = origin.getDirectoryPath(null);
        String targetDir = copy.getDirectoryPath(null);
        File target = new File(targetDir = targetDir.replace('/', File.separatorChar)).getParentFile();
        if (target.exists()) {
            FileUtils.cleanDirectory((File)target);
        }
        if (!(source = new File(originDir).getParentFile()).exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        FileUtils.copyDirectory((File)source, (File)target);
    }

    public void copyFullContent(SimpleDocument origin, SimpleDocument copy) throws IOException {
        String originDir = origin.getDirectoryPath(null);
        String targetDir = copy.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile().getParentFile();
        File source = new File(originDir).getParentFile().getParentFile();
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        FileUtils.copyDirectory((File)source, (File)target);
    }

    public void moveMultilangContent(SimpleDocument origin, SimpleDocument copy) throws IOException {
        String originDir = origin.getDirectoryPath(null);
        File source = new File(originDir).getParentFile();
        String targetDir = copy.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile();
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        if (!target.getParentFile().getName().equals(source.getParentFile().getName())) {
            source = source.getParentFile();
            target = target.getParentFile();
        }
        if (!source.equals(target)) {
            FileUtils.moveDirectory((File)source, (File)target);
            FileUtil.deleteEmptyDir(source.getParentFile());
        }
    }

    public void mergeAttachment(Session session, SimpleDocument attachment, SimpleDocument clone) throws RepositoryException {
        Node originalNode = session.getNodeByIdentifier(attachment.getId());
        HashSet<String> existingAttachements = new HashSet<String>(I18NHelper.getNumberOfLanguages());
        for (Node child : new NodeIterable(originalNode.getNodes())) {
            existingAttachements.add(child.getName());
        }
        Node cloneNode = session.getNodeByIdentifier(clone.getId());
        for (Node child : new NodeIterable(cloneNode.getNodes())) {
            String childNodeName = child.getName();
            if (existingAttachements.contains(childNodeName) && originalNode.hasNode(childNodeName)) {
                this.copyNode(session, child, originalNode.getNode(childNodeName));
                existingAttachements.remove(childNodeName);
                continue;
            }
            session.move(child.getPath(), originalNode.getPath() + '/' + childNodeName);
        }
        for (String deletedNode : existingAttachements) {
            if (!originalNode.hasNode(deletedNode)) continue;
            originalNode.getNode(deletedNode).remove();
        }
        this.converter.addStringProperty(originalNode, "slv:clone", null);
    }

    private void copyNode(Session session, Node source, Node target) throws RepositoryException {
        for (Node child : new NodeIterable(target.getNodes())) {
            if (child.getDefinition().isProtected()) continue;
            child.remove();
        }
        for (Node child : new NodeIterable(source.getNodes())) {
            session.move(child.getPath(), target.getPath() + '/' + child.getName());
        }
        for (Property property : new PropertyIterable(target.getProperties())) {
            if (property.getDefinition().isProtected()) continue;
            property.remove();
        }
        for (Property property : new PropertyIterable(source.getProperties())) {
            if (property.getDefinition().isProtected()) continue;
            target.setProperty(property.getName(), property.getValue());
        }
    }
}

