/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.webdav.impl;

import com.silverpeas.jcrutil.BasicDaoFactory;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.webdav.WebdavRepository;
import org.silverpeas.attachment.webdav.WebdavService;

@Named(value="webdavService")
public class WebDavDocumentService
implements WebdavService {
    @Inject
    @Named(value="webdavRepository")
    private WebdavRepository webdavAttachmentDao;

    @Override
    public void createAttachment(SimpleDocument attachment) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            this.webdavAttachmentDao.createAttachmentNode(session, attachment);
            session.save();
        }
        catch (IOException ex) {
            SilverTrace.error("attachment", "JcrAttachmentServiceImpl", "attachment.jcr.create.exception", ex);
            throw new AttachmentException("JcrAttachmentServiceImpl", 4, "attachment.jcr.create.exception", ex);
        }
        catch (RepositoryException ex) {
            SilverTrace.error("attachment", "JcrAttachmentServiceImpl", "attachment.jcr.create.exception", ex);
            throw new AttachmentException("JcrAttachmentServiceImpl", 4, "attachment.jcr.create.exception", (Exception)((Object)ex));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void getUpdatedDocument(SimpleDocument attachment) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            this.webdavAttachmentDao.updateAttachment(session, attachment);
            session.save();
        }
        catch (RepositoryException ex) {
            SilverTrace.error("attachment", "JcrAttachmentServiceImpl", "attachment.jcr.create.exception", ex);
            throw new AttachmentException("JcrAttachmentServiceImpl", 4, "attachment.jcr.create.exception", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            SilverTrace.error("attachment", "JcrAttachmentServiceImpl", "attachment.jcr.create.exception", ex);
            throw new AttachmentException("JcrAttachmentServiceImpl", 4, "attachment.jcr.create.exception", ex);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void deleteAttachment(SimpleDocument attachment) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            this.webdavAttachmentDao.deleteAttachmentNode(session, attachment);
            session.save();
        }
        catch (RepositoryException ex) {
            SilverTrace.error("attachment", "JcrAttachmentServiceImpl", "attachment.jcr.delete.exception", ex);
            throw new AttachmentException("JcrAttachmentServiceImpl", 4, "attachment.jcr.delete.exception", (Exception)((Object)ex));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void updateNodeAttachment(SimpleDocument attachment) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            this.webdavAttachmentDao.updateNodeAttachment(session, attachment);
            session.save();
        }
        catch (RepositoryException ex) {
            SilverTrace.error("attachment", "JcrAttachmentServiceImpl", "attachment.jcr.create.exception", ex);
            throw new AttachmentException("JcrAttachmentServiceImpl", 4, "attachment.jcr.delete.exception", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            SilverTrace.error("attachment", "JcrAttachmentServiceImpl", "attachment.jcr.create.exception", ex);
            throw new AttachmentException("JcrAttachmentServiceImpl", 4, "attachment.jcr.delete.exception", ex);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public boolean isNodeLocked(SimpleDocument attachment) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            boolean bl = this.webdavAttachmentDao.isNodeLocked(session, attachment);
            return bl;
        }
        catch (RepositoryException ex) {
            SilverTrace.error("attachment", "JcrAttachmentServiceImpl", "attachment.jcr.isLocked.exception", ex);
            throw new AttachmentException("JcrAttachmentServiceImpl", 4, "attachment.jcr.delete.exception", (Exception)((Object)ex));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

