/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.webdav.impl;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.inject.Named;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.webdav.WebdavRepository;

@Named(value="webdavRepository")
public class WebdavDocumentRepository
implements WebdavRepository {
    @Override
    public void createAttachmentNode(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        String lang;
        Node componentFolder;
        Node rootNode = session.getRootNode();
        Node attachmentFolder = this.addFolder(rootNode, "webdav");
        attachmentFolder = this.addFolder(attachmentFolder, DocumentType.attachment.getFolderName());
        Node contextFolder = componentFolder = this.addFolder(attachmentFolder, attachment.getInstanceId());
        if (attachment.getId() != null) {
            contextFolder = this.addFolder(contextFolder, attachment.getId());
        }
        if (!StringUtil.isDefined(lang = attachment.getLanguage())) {
            lang = I18NHelper.defaultLanguage;
        }
        contextFolder = this.addFolder(contextFolder, lang);
        this.addFile(contextFolder, attachment);
    }

    @Override
    public void updateNodeAttachment(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        Node rootNode = session.getRootNode();
        try {
            Node fileNode = rootNode.getNode(attachment.getWebdavJcrPath());
            this.setContent(fileNode, attachment);
        }
        catch (PathNotFoundException pex) {
            this.createAttachmentNode(session, attachment);
        }
    }

    @Override
    public void deleteAttachmentNode(Session session, SimpleDocument attachment) throws RepositoryException {
        Node rootNode = session.getRootNode();
        try {
            Node fileNode = rootNode.getNode(attachment.getWebdavJcrPath());
            fileNode.remove();
        }
        catch (PathNotFoundException pex) {
            // empty catch block
        }
    }

    @Override
    public boolean isNodeLocked(Session session, SimpleDocument attachment) throws RepositoryException {
        Node rootNode = session.getRootNode();
        try {
            Node fileNode = rootNode.getNode(attachment.getWebdavJcrPath());
            return fileNode.isLocked();
        }
        catch (PathNotFoundException pex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttachment(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        Node rootNode = session.getRootNode();
        Node webdavFileNode = rootNode.getNode(attachment.getWebdavJcrPath());
        Binary webdavBinary = webdavFileNode.getNode("{http://www.jcp.org/jcr/1.0}content").getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
        InputStream in = webdavBinary.getStream();
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)new File(attachment.getAttachmentPath()));
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly((InputStream)in);
            webdavBinary.dispose();
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
        webdavBinary.dispose();
    }

    protected Node addFolder(Node parent, String name) throws RepositoryException {
        try {
            return parent.getNode(name);
        }
        catch (PathNotFoundException pnfex) {
            return parent.addNode(name, "nt:folder");
        }
    }

    protected Node addFile(Node folder, SimpleDocument attachment) throws RepositoryException, IOException {
        String escapedName = StringUtil.escapeQuote(attachment.getFilename());
        if (folder.hasNode(escapedName)) {
            folder.getNode(escapedName).remove();
        }
        Node fileNode = folder.addNode(escapedName, "nt:file");
        if (attachment.getEditedBy() != null) {
            fileNode.addMixin("slv:ownable");
            fileNode.setProperty("slv:owner", attachment.getEditedBy());
        }
        Node contentNode = fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "nt:resource");
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", attachment.getContentType());
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}encoding", "");
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", Calendar.getInstance());
        this.setContent(fileNode, attachment);
        return fileNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContent(Node fileNode, SimpleDocument attachment) throws RepositoryException, IOException {
        FileInputStream in = FileUtils.openInputStream((File)new File(attachment.getAttachmentPath()));
        try {
            Binary attachmentBinary = fileNode.getSession().getValueFactory().createBinary((InputStream)in);
            fileNode.getNode("{http://www.jcp.org/jcr/1.0}content").setProperty("{http://www.jcp.org/jcr/1.0}data", attachmentBinary);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

