/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.password;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.silverpeas.authentication.password.ForgottenPasswordMailParameters;

public class ForgottenPasswordMailManager {
    private static final String TRANSPORT_SMTP = "smtp";
    private static final String TRANSPORT_SMTPS = "smtps";
    private static final String SUBJECT_ENCODING = "UTF-8";
    private static final String PREFIX_RESET_PASSWORD_REQUEST = "resetPasswordRequest";
    private static final String PREFIX_NEW_PASSWORD = "newPassword";
    private static final String PREFIX_ERROR = "error";
    private static final String PREFIX_ADMIN = "admin";
    private static final String CONTENT = "content";
    private static final String SUBJECT = "subject";
    private ResourceLocator resource = new ResourceLocator("com.silverpeas.authentication.multilang.forgottenPasswordMail", "");
    private String smtpHost;
    private boolean smtpAuthentication;
    private boolean smtpSecure;
    private boolean smtpDebug;
    private int smtpPort;
    private String smtpUser;
    private String smtpPwd;
    private Session session;
    private String fromAddress;
    private String fromName;
    private String adminEmail;

    public ForgottenPasswordMailManager() {
        this.initSmtpParameters();
        this.initFromAddress();
    }

    private void initSmtpParameters() {
        ResourceLocator smtpSettings = new ResourceLocator("com.stratelia.silverpeas.notificationserver.channel.smtp.smtpSettings", "");
        this.smtpHost = smtpSettings.getString("SMTPServer");
        this.smtpAuthentication = smtpSettings.getBoolean("SMTPAuthentication", false);
        this.smtpDebug = smtpSettings.getBoolean("SMTPDebug", false);
        this.smtpPort = Integer.parseInt(smtpSettings.getString("SMTPPort"));
        this.smtpUser = smtpSettings.getString("SMTPUser");
        this.smtpPwd = smtpSettings.getString("SMTPPwd");
        this.smtpSecure = smtpSettings.getBoolean("SMTPSecure", false);
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.smtpHost);
        props.put("mail.smtp.auth", String.valueOf(this.smtpAuthentication));
        this.session = Session.getInstance((Properties)props, null);
        this.session.setDebug(this.smtpDebug);
    }

    private void initFromAddress() {
        ResourceLocator mailSettings = new ResourceLocator("com.silverpeas.authentication.settings.forgottenPasswordMail", "");
        this.adminEmail = mailSettings.getString("admin.mail", AdminReference.getAdminService().getAdministratorEmail());
        this.fromAddress = mailSettings.getString("fromAddress", this.adminEmail);
        this.fromName = mailSettings.getString("fromName", "Silverpeas");
    }

    public void sendResetPasswordRequestMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        this.sendMail(parameters, PREFIX_RESET_PASSWORD_REQUEST);
    }

    public void sendNewPasswordMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        this.sendMail(parameters, PREFIX_NEW_PASSWORD);
    }

    public void sendErrorMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        parameters.setToAddress(this.adminEmail);
        this.sendMail(parameters, PREFIX_ERROR);
    }

    public void sendAdminMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        parameters.setToAddress(this.adminEmail);
        this.sendMail(parameters, PREFIX_ADMIN);
    }

    private void sendMail(ForgottenPasswordMailParameters parameters, String resourcePrefix) throws MessagingException {
        parameters.setSubject(this.resource.getString(resourcePrefix + "." + SUBJECT));
        parameters.setContent(this.resource.getString(resourcePrefix + "." + CONTENT));
        this.sendMail(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMail(ForgottenPasswordMailParameters parameters) throws MessagingException {
        Transport transport = null;
        try {
            MimeMessage msg = new MimeMessage(this.session);
            try {
                msg.setFrom((Address)new InternetAddress(this.fromAddress, this.fromName, SUBJECT_ENCODING));
            }
            catch (UnsupportedEncodingException e1) {
                msg.setFrom((Address)new InternetAddress(this.fromAddress));
            }
            msg.setSubject(parameters.getSubject(), SUBJECT_ENCODING);
            msg.setContent((Object)parameters.getFilledContent(), "text/html");
            msg.setSentDate(new Date());
            transport = this.smtpSecure ? this.session.getTransport(TRANSPORT_SMTPS) : this.session.getTransport(TRANSPORT_SMTP);
            TransportListener transportListener = new TransportListener(){

                public void messageDelivered(TransportEvent e) {
                }

                public void messageNotDelivered(TransportEvent e) {
                }

                public void messagePartiallyDelivered(TransportEvent e) {
                }
            };
            transport.addTransportListener(transportListener);
            InternetAddress[] addresses = new InternetAddress[]{new InternetAddress(parameters.getToAddress())};
            msg.setRecipients(Message.RecipientType.TO, (Address[])addresses);
            if (this.smtpAuthentication) {
                SilverTrace.info("Bus - peasCore", "ForgottenPasswordMailManager.sendMail()", "root.MSG_GEN_PARAM_VALUE", "host = " + this.smtpHost + " m_Port=" + this.smtpPort + " m_User=" + this.smtpUser);
                transport.connect(this.smtpHost, this.smtpPort, this.smtpUser, this.smtpPwd);
                msg.saveChanges();
            } else {
                transport.connect();
            }
            transport.sendMessage((Message)msg, (Address[])addresses);
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (Exception e) {
                    SilverTrace.error("Bus - peasCore", "ForgottenPasswordMailManager.sendMail()", "root.EX_IGNORED", "ClosingTransport", e);
                }
            }
        }
    }
}

