/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.verifier;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.SchedulerException;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.scheduler.trigger.TimeUnit;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DateUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.DateUtils;
import org.silverpeas.authentication.exception.AuthenticationNoMoreUserConnectionAttemptException;
import org.silverpeas.authentication.verifier.AbstractAuthenticationVerifier;

public class UserCanTryAgainToLoginVerifier
extends AbstractAuthenticationVerifier {
    private static final Map<String, UserCanTryAgainToLoginVerifier> cache = new ConcurrentHashMap<String, UserCanTryAgainToLoginVerifier>();
    private static boolean isActivated = false;
    private static boolean isCacheCleanerInitialized = false;
    private static int nbMaxAttempts = 0;
    private int nbAttempts = 0;
    private Date initializationOrLastVerifyDate = DateUtil.getNow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserCanTryAgainToLoginVerifier(UserDetail user) {
        super(user);
        if (isActivated && !isCacheCleanerInitialized) {
            Map<String, UserCanTryAgainToLoginVerifier> map = cache;
            synchronized (map) {
                if (!SchedulerFactory.getFactory().getScheduler().isJobScheduled("AuthenticationUserConnectionAttemptsVerifierCleanerJob")) {
                    try {
                        SchedulerFactory.getFactory().getScheduler().scheduleJob(new CacheCleanerJob(), JobTrigger.triggerEvery(10, TimeUnit.MINUTE));
                        isCacheCleanerInitialized = true;
                    }
                    catch (SchedulerException e) {
                        SilverTrace.error("authentication", "UserCanTryAgainToLoginVerifier()", "root.MSG_ERR_CACHE_CLEANER_INITIALIZATION");
                    }
                }
            }
        }
    }

    public boolean isActivated() {
        return isActivated;
    }

    public String performRequestUrl(HttpServletRequest request, String originalUrl) {
        HttpSession session;
        if (isActivated && (session = request.getSession(false)) != null) {
            session.setAttribute("WarningMessage", (Object)this.getMessage());
        }
        return originalUrl;
    }

    public String getMessage() {
        if (isActivated) {
            return UserCanTryAgainToLoginVerifier.getString("authentication.attempts.remaining", this.getUser() != null && StringUtil.isDefined(this.getUser().getId()) ? this.getUser().getUserPreferences().getLanguage() : I18NHelper.defaultLanguage, String.valueOf(nbMaxAttempts - this.nbAttempts));
        }
        return "";
    }

    public String getErrorDestination() {
        return "/Login.jsp?ErrorCode=Error_UserAccountBlocked";
    }

    public UserCanTryAgainToLoginVerifier verify() throws AuthenticationNoMoreUserConnectionAttemptException {
        this.initializationOrLastVerifyDate = DateUtil.getNow();
        if (!this.isAtLeastOneUserConnectionAttempt()) {
            if (this.getUser() != null && StringUtil.isDefined(this.getUser().getId())) {
                new AdminController(this.getUser().getId()).blockUser(this.getUser().getId());
                this.clearCache();
            }
            throw new AuthenticationNoMoreUserConnectionAttemptException("UserCanTryAgainToLoginVerifier.verify()", 4, "authentication.EX_VERIFY_USER_CAN_TRY_AGAIN_TO_LOGIN", this.getUser() != null ? "Login=" + this.getUser().getLogin() : "");
        }
        return this;
    }

    private synchronized boolean isAtLeastOneUserConnectionAttempt() {
        return !isActivated || this.getUser() != null && ++this.nbAttempts < nbMaxAttempts;
    }

    public UserCanTryAgainToLoginVerifier clearCache() {
        UserCanTryAgainToLoginVerifier.clearCache(this.getUser());
        return this;
    }

    public UserCanTryAgainToLoginVerifier clearSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("WarningMessage");
        }
        return this;
    }

    protected static synchronized UserCanTryAgainToLoginVerifier get(UserDetail user) {
        if (user == null) {
            return new UserCanTryAgainToLoginVerifier(user);
        }
        String userKey = UserCanTryAgainToLoginVerifier.key(user);
        UserCanTryAgainToLoginVerifier verifier = cache.get(userKey);
        if (verifier == null) {
            verifier = new UserCanTryAgainToLoginVerifier(user);
            if (isActivated) {
                cache.put(userKey, verifier);
            }
        } else {
            verifier.setUser(user);
        }
        return verifier;
    }

    private static synchronized void clearCache(UserDetail user) {
        if (user != null) {
            cache.remove(UserCanTryAgainToLoginVerifier.key(user));
        }
    }

    private static String key(UserDetail user) {
        return "key(" + user.getLogin() + "#@#" + user.getDomainId() + ")";
    }

    static {
        nbMaxAttempts = settings.getInteger("nbConnectionAttemptsBeforeBlockingUser", 0);
        if (nbMaxAttempts > 0) {
            isActivated = true;
        }
    }

    private class CacheCleanerJob
    extends Job {
        public static final String JOB_NAME = "AuthenticationUserConnectionAttemptsVerifierCleanerJob";

        public CacheCleanerJob() {
            super(JOB_NAME);
        }

        @Override
        public void execute(JobExecutionContext context) throws Exception {
            Date now = DateUtil.getNow();
            Iterator it = cache.entrySet().iterator();
            while (it.hasNext()) {
                UserCanTryAgainToLoginVerifier verifier = (UserCanTryAgainToLoginVerifier)it.next().getValue();
                if (DateUtils.addHours((Date)verifier.initializationOrLastVerifyDate, (int)1).compareTo(now) >= 0) continue;
                it.remove();
            }
        }
    }
}

