/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.verifier;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationPasswordAboutToExpireException;
import org.silverpeas.authentication.exception.AuthenticationPasswordExpired;
import org.silverpeas.authentication.exception.AuthenticationPasswordMustBeChangedOnFirstLogin;
import org.silverpeas.authentication.verifier.AbstractAuthenticationVerifier;

public class UserMustChangePasswordVerifier
extends AbstractAuthenticationVerifier {
    public static final String ERROR_PWD_MUST_BE_CHANGED_ON_FIRST_LOGIN = "Error_PwdMustBeChangedOnFirstLogin";
    public static final String ERROR_PWD_AND_EMAIL_MUST_BE_CHANGED_ON_FIRST_LOGIN = "Error_PwdAndEmailMustBeChangedOnFirstLogin";
    private static Map<String, UserFirstLoginStep> usersFirstLoginStep = new ConcurrentHashMap<String, UserFirstLoginStep>();
    protected static boolean isThatUserMustChangePasswordOnFirstLogin = false;
    protected static boolean isThatUserMustFillEmailAddressOnFirstLogin = false;
    protected static boolean isMaxConnectionActivated = false;
    protected static boolean isOffsetConnectionActivated = false;
    protected static int nbMaxConnectionsForForcing = 0;
    protected static int nbMaxConnectionsForProposing = 0;

    protected static void setup(boolean userMustChangePasswordOnFirstLogin, boolean userMustFillEmailAddressOnFirstLogin, int nbSuccessfulUserConnectionsBeforeForcingPasswordChange, int nbSuccessfulUserConnectionsBeforeProposingToChangePassword) {
        isThatUserMustChangePasswordOnFirstLogin = false;
        isThatUserMustFillEmailAddressOnFirstLogin = false;
        isMaxConnectionActivated = false;
        isOffsetConnectionActivated = false;
        nbMaxConnectionsForForcing = 0;
        nbMaxConnectionsForProposing = 0;
        usersFirstLoginStep.clear();
        isThatUserMustChangePasswordOnFirstLogin = userMustChangePasswordOnFirstLogin;
        isThatUserMustFillEmailAddressOnFirstLogin = userMustFillEmailAddressOnFirstLogin;
        nbMaxConnectionsForForcing = nbSuccessfulUserConnectionsBeforeForcingPasswordChange;
        if (nbMaxConnectionsForForcing > 0) {
            isMaxConnectionActivated = true;
            nbMaxConnectionsForProposing = nbSuccessfulUserConnectionsBeforeProposingToChangePassword;
            if (nbMaxConnectionsForProposing > 0) {
                isOffsetConnectionActivated = true;
            }
        }
    }

    protected UserMustChangePasswordVerifier(UserDetail user) {
        super(user);
    }

    public String getDestinationOnFirstLogin(HttpServletRequest request) {
        String errorCode;
        String string = errorCode = !isThatUserMustFillEmailAddressOnFirstLogin ? ERROR_PWD_MUST_BE_CHANGED_ON_FIRST_LOGIN : ERROR_PWD_AND_EMAIL_MUST_BE_CHANGED_ON_FIRST_LOGIN;
        if (request != null) {
            String message = UserMustChangePasswordVerifier.getString("authentication.logon." + errorCode, this.getUser() != null && StringUtil.isDefined(this.getUser().getId()) ? this.getUser().getUserPreferences().getLanguage() : I18NHelper.defaultLanguage, new String[0]);
            request.setAttribute("message", (Object)message);
            request.setAttribute("isThatUserMustFillEmailAddressOnFirstLogin", (Object)isThatUserMustFillEmailAddressOnFirstLogin);
            if (isThatUserMustFillEmailAddressOnFirstLogin && this.getUser() != null) {
                request.setAttribute("emailAddress", (Object)this.getUser().geteMail());
            }
        }
        return otherSettings.getString("passwordChangeOnFirstLoginURL") + "?ErrorCode=" + errorCode;
    }

    public void verify() throws AuthenticationException {
        if (this.mustForceUserToChangePasswordOnFirstLogin()) {
            throw new AuthenticationPasswordMustBeChangedOnFirstLogin(this.getUser() != null ? "Login=" + this.getUser().getLogin() : "");
        }
        if (this.proposeToUserToChangePassword()) {
            throw new AuthenticationPasswordAboutToExpireException("UserMustChangePasswordVerifier.verify()", 4, "authentication.EX_VERIFY_ASKING_USER_CHANGE_PASSWORD", this.getUser() != null ? "Login=" + this.getUser().getLogin() : "");
        }
        if (this.mustForceUserToChangePassword()) {
            throw new AuthenticationPasswordExpired(this.getUser() != null ? "Login=" + this.getUser().getLogin() : "");
        }
    }

    public void notifyPasswordChange() {
        if (isThatUserMustChangePasswordOnFirstLogin && this.getUser() != null) {
            usersFirstLoginStep.put(this.getUser().getId(), UserFirstLoginStep.PASSWORD_CHANGED);
        }
    }

    private boolean mustForceUserToChangePasswordOnFirstLogin() {
        boolean mustForceUserToChangePasswordOnFirstLogin = false;
        if (isThatUserMustChangePasswordOnFirstLogin && this.getUser() != null) {
            if (UserFirstLoginStep.PASSWORD_CHANGED.equals((Object)usersFirstLoginStep.get(this.getUser().getId()))) {
                usersFirstLoginStep.remove(this.getUser().getId());
            } else if (this.getUser().getLastLoginDate() == null || UserFirstLoginStep.CHANGE_PASSWORD.equals((Object)usersFirstLoginStep.get(this.getUser().getId()))) {
                usersFirstLoginStep.put(this.getUser().getId(), UserFirstLoginStep.CHANGE_PASSWORD);
                mustForceUserToChangePasswordOnFirstLogin = true;
            }
        }
        return mustForceUserToChangePasswordOnFirstLogin;
    }

    private boolean mustForceUserToChangePassword() {
        return isMaxConnectionActivated && this.getUser() != null && this.getUser().getNbSuccessfulLoginAttempts() != 0 && this.getUser().getNbSuccessfulLoginAttempts() >= nbMaxConnectionsForForcing;
    }

    private boolean proposeToUserToChangePassword() {
        return isMaxConnectionActivated && isOffsetConnectionActivated && this.getUser() != null && this.getUser().getNbSuccessfulLoginAttempts() != 0 && !this.mustForceUserToChangePassword() && this.getUser().getNbSuccessfulLoginAttempts() >= nbMaxConnectionsForProposing;
    }

    static {
        UserMustChangePasswordVerifier.setup(settings.getBoolean("userMustChangePasswordOnFirstLogin", false), settings.getBoolean("userMustFillEmailAddressOnFirstLogin", false), settings.getInteger("nbSuccessfulUserConnectionsBeforeForcingPasswordChange", 0), settings.getInteger("nbSuccessfulUserConnectionsBeforeProposingToChangePassword", 0));
    }

    private static enum UserFirstLoginStep {
        CHANGE_PASSWORD,
        PASSWORD_CHANGED;

    }
}

