/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.cache.service;

import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.silverpeas.cache.service.CacheService;

public class EhCacheService
implements CacheService {
    private static final String CACHE_NAME = "SILVERPEAS_COMMON_EH_CACHE";
    private static final int DEFAULT_TIME_TO_IDLE = 43200;
    private CacheManager cacheManager = CacheManager.getInstance();

    EhCacheService(int nbMaxElements) {
        if (!this.cacheManager.cacheExists(CACHE_NAME)) {
            this.cacheManager.addCache(new Cache(new CacheConfiguration(CACHE_NAME, nbMaxElements)));
        } else {
            this.getCache().getCacheConfiguration().setMaxEntriesLocalHeap((long)nbMaxElements);
        }
    }

    Cache getCache() {
        return this.cacheManager.getCache(CACHE_NAME);
    }

    @Override
    public Object get(Object key) {
        Element element = this.getCache().get(key);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    @Override
    public <T> T get(Object key, Class<T> classType) {
        Object value = this.get(key);
        if (value == null || !classType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)value;
    }

    @Override
    public Object remove(Object key) {
        Object value = this.get(key);
        if (value != null) {
            this.getCache().remove(key);
        }
        return value;
    }

    @Override
    public <T> T remove(Object key, Class<T> classType) {
        T value = this.get(key, classType);
        if (value != null) {
            this.getCache().remove(key);
        }
        return value;
    }

    @Override
    public String add(Object value) {
        String uniqueKey = UUID.randomUUID().toString();
        this.put(uniqueKey, value);
        return uniqueKey;
    }

    @Override
    public String add(Object value, int timeToLive) {
        String uniqueKey = UUID.randomUUID().toString();
        this.put(uniqueKey, value, timeToLive);
        return uniqueKey;
    }

    @Override
    public String add(Object value, int timeToLive, int timeToIdle) {
        String uniqueKey = UUID.randomUUID().toString();
        this.put(uniqueKey, value, timeToLive, timeToIdle);
        return uniqueKey;
    }

    @Override
    public void put(Object key, Object value) {
        this.put(key, value, 0);
    }

    @Override
    public void put(Object key, Object value, int timeToLive) {
        this.put(key, value, timeToLive, 43200);
    }

    @Override
    public void put(Object key, Object value, int timeToLive, int timeToIdle) {
        Element element = new Element(key, value);
        element.setTimeToLive(timeToLive);
        element.setTimeToIdle(timeToIdle);
        this.getCache().put(element);
    }
}

