/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.date;

import com.stratelia.webactiv.util.DateUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.silverpeas.date.DayPeriod;
import org.silverpeas.date.MonthPeriod;
import org.silverpeas.date.PeriodType;
import org.silverpeas.date.WeekPeriod;
import org.silverpeas.date.YearPeriod;

public class Period
implements Comparable,
Serializable {
    private static final long serialVersionUID = 6378275537498456869L;
    private PeriodType periodType = PeriodType.unknown;
    private Date beginDate;
    private Date endDate;

    public static Period from(Date beginDate, Date endDate) {
        return new Period(beginDate, endDate);
    }

    public static Period from(Date referenceDate, PeriodType periodType, String locale) {
        switch (periodType) {
            case year: {
                return new YearPeriod(referenceDate);
            }
            case month: {
                return new MonthPeriod(referenceDate);
            }
            case week: {
                return new WeekPeriod(referenceDate, locale);
            }
        }
        return new DayPeriod(referenceDate);
    }

    protected Period(Date beginDate, Date endDate) {
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    protected void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public int getNumberOfDays() {
        if (this.beginDate == null || this.endDate == null) {
            return -1;
        }
        return DateUtil.getDayNumberBetween(this.beginDate, this.endDate) + 1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Period)o);
    }

    public int compareTo(Period period) {
        return this.getBeginDate().compareTo(period.getBeginDate()) != 0 ? this.getBeginDate().compareTo(period.getBeginDate()) : this.getEndDate().compareTo(period.getEndDate());
    }

    public boolean equals(Object o) {
        return o instanceof Period && this.getBeginDate().equals(((Period)o).getBeginDate()) && this.getEndDate().equals(((Period)o).getEndDate());
    }

    public int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder();
        hash.append((Object)this.getBeginDate());
        hash.append((Object)this.getEndDate());
        return hash.toHashCode();
    }

    public boolean isValid() {
        return this.getBeginDate() != null && this.getEndDate() != null && this.getBeginDate().compareTo(this.getEndDate()) <= 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Period(");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        if (this.getBeginDate() != null) {
            sb.append(sdf.format(this.getBeginDate()));
        } else {
            sb.append("NA");
        }
        sb.append(", ");
        if (this.getEndDate() != null) {
            sb.append(sdf.format(this.getEndDate()));
        } else {
            sb.append("NA");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean contains(Date date) {
        return DateUtil.compareTo(this.getBeginDate(), date, false) <= 0 && DateUtil.compareTo(this.getEndDate(), date, false) >= 0;
    }

    public boolean contains(Period period) {
        return DateUtil.compareTo(this.getBeginDate(), period.getBeginDate()) <= 0 && DateUtil.compareTo(this.getEndDate(), period.getEndDate()) >= 0;
    }

    public boolean containsPartOf(Period period) {
        return DateUtil.compareTo(this.getBeginDate(), period.getEndDate()) <= 0 && DateUtil.compareTo(this.getEndDate(), period.getBeginDate()) >= 0;
    }
}

