/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.image.imagemagick;

import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.silverpeas.image.AbstractImageTool;
import org.silverpeas.image.ImageToolDirective;
import org.silverpeas.image.imagemagick.Im4javaManager;
import org.silverpeas.image.option.AbstractImageToolOption;
import org.silverpeas.image.option.BackgroundOption;
import org.silverpeas.image.option.DimensionOption;

@Named(value="imageTool")
public class Im4javaImageTool
extends AbstractImageTool {
    private static final String FIRST_PAGE_ONLY = "[0]";
    private static final String GEOMETRY_SHRINK = ">";

    @Override
    public boolean isActivated() {
        return Im4javaManager.isActivated();
    }

    @Override
    protected void convert(File source, File destination, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) throws Exception {
        IMOperation op = new IMOperation();
        this.setSource(op, source, directives);
        this.background(op, options);
        this.resize(op, options, directives);
        this.setDestination(op, destination, directives);
        new ConvertCmd().run((Operation)op, new Object[0]);
    }

    private void setSource(IMOperation op, File source, Set<ImageToolDirective> directives) {
        StringBuilder sb = new StringBuilder(source.getPath());
        if (directives.contains((Object)ImageToolDirective.FIRST_PAGE_ONLY)) {
            sb.append(FIRST_PAGE_ONLY);
        }
        op.addImage(new String[]{sb.toString()});
    }

    private void setDestination(IMOperation op, File destination, Set<ImageToolDirective> directives) {
        op.addImage(new String[]{destination.getPath()});
    }

    private void background(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options) {
        BackgroundOption background = this.getOption(options, BackgroundOption.class);
        if (background != null) {
            op.background(background.getValue());
            op.flatten();
        }
    }

    private void resize(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) {
        DimensionOption dimension = this.getOption(options, DimensionOption.class);
        if (dimension != null) {
            StringBuilder specialDirective = new StringBuilder();
            if (directives.contains((Object)ImageToolDirective.GEOMETRY_SHRINK)) {
                specialDirective.append(GEOMETRY_SHRINK);
            }
            if (directives.contains((Object)ImageToolDirective.PREVIEW_WORK)) {
                op.thumbnail(Integer.valueOf(dimension.getWidth()), Integer.valueOf(dimension.getHeight()), specialDirective.toString());
            } else {
                op.resize(Integer.valueOf(dimension.getWidth()), Integer.valueOf(dimension.getHeight()), specialDirective.toString());
            }
        }
    }
}

