/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.importExport.versioning;

import com.silverpeas.form.importExport.FormTemplateImportExport;
import com.silverpeas.form.importExport.XMLModelContentType;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.model.UnlockContext;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.importExport.attachment.AttachmentImportExport;
import org.silverpeas.importExport.versioning.Document;
import org.silverpeas.importExport.versioning.DocumentPK;
import org.silverpeas.importExport.versioning.DocumentVersion;

public class VersioningImportExport {
    private UserDetail user;
    private final ResourceLocator resources = new ResourceLocator("org.silverpeas.importExport.settings.importSettings", "");

    public VersioningImportExport(UserDetail user) {
        this.user = user;
    }

    public int importDocuments(String objectId, String componentId, List<AttachmentDetail> attachments, int userId, boolean indexIt) throws RemoteException, IOException {
        return this.importDocuments(objectId, componentId, attachments, userId, 0, indexIt, null);
    }

    public int importDocuments(String objectId, String componentId, List<AttachmentDetail> attachments, int userId, int versionType, boolean indexIt, String topicId) throws RemoteException, IOException {
        SilverTrace.info("versioning", "VersioningImportExport.importDocuments()", "root.GEN_PARAM_VALUE", componentId);
        int nbFilesProcessed = 0;
        AttachmentImportExport attachmentImportExport = new AttachmentImportExport();
        ForeignPK pubPK = new ForeignPK(objectId, componentId);
        List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey(pubPK, null);
        for (AttachmentDetail attachment : attachments) {
            boolean removed;
            SimpleDocument document;
            InputStream content = attachmentImportExport.getAttachmentContent(attachment);
            if (!StringUtil.isDefined(attachment.getAuthor())) {
                attachment.setAuthor(this.user.getId());
            }
            if ((document = this.isDocumentExist(documents, attachment)) != null) {
                document.edit(attachment.getAuthor());
                AttachmentServiceFactory.getAttachmentService().lock(document.getId(), attachment.getAuthor(), null);
                AttachmentServiceFactory.getAttachmentService().updateAttachment(document, content, indexIt, true);
                AttachmentServiceFactory.getAttachmentService().unlock(new UnlockContext(document.getId(), attachment.getAuthor(), null));
            } else {
                if (attachment.getCreationDate() == null) {
                    attachment.setCreationDate(new Date());
                }
                HistorisedDocument version = new HistorisedDocument(new SimpleDocumentPK(null, componentId), objectId, -1, attachment.getAuthor(), new SimpleAttachment(attachment.getLogicalName(), attachment.getLanguage(), attachment.getTitle(), attachment.getInfo(), attachment.getSize(), attachment.getType(), "" + userId, attachment.getCreationDate(), attachment.getXmlForm()));
                version.setPublicDocument(versionType == 0);
                version.setStatus("0");
                AttachmentServiceFactory.getAttachmentService().createAttachment((SimpleDocument)version, content, indexIt);
            }
            if (attachment.isRemoveAfterImport() && !(removed = FileUtils.deleteQuietly((File)attachmentImportExport.getAttachmentFile(attachment)))) {
                SilverTrace.error("versioning", "VersioningImportExport.importDocuments()", "root.MSG_GEN_PARAM_VALUE", "Can't remove file " + attachmentImportExport.getAttachmentFile(attachment));
            }
            ++nbFilesProcessed;
        }
        return nbFilesProcessed;
    }

    private SimpleDocument isDocumentExist(List<SimpleDocument> documents, AttachmentDetail attachment) {
        String documentName = attachment.getTitle();
        if (!StringUtil.isDefined(documentName)) {
            documentName = attachment.getLogicalName();
        }
        for (SimpleDocument document : documents) {
            if (!documentName.equalsIgnoreCase(document.getFilename())) continue;
            return document;
        }
        return null;
    }

    public List<SimpleDocument> importDocuments(ForeignPK objectPK, List<Document> documents, int userId, boolean indexIt) throws RemoteException, FileNotFoundException {
        SilverTrace.info("versioning", "VersioningImportExport.importDocuments()", "root.GEN_PARAM_VALUE", objectPK.toString());
        boolean launchCallback = false;
        int userIdCallback = -1;
        ArrayList<SimpleDocument> importedDocs = new ArrayList<SimpleDocument>(documents.size());
        List<SimpleDocument> existingDocuments = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey(objectPK, null);
        FormTemplateImportExport xmlIE = null;
        for (Document document : documents) {
            List<DocumentVersion> versions;
            SimpleDocument existingDocument = null;
            if (document.getPk() != null && StringUtil.isDefined(document.getPk().getId()) && !"-1".equals(document.getPk().getId())) {
                existingDocument = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK("", document.getPk()), null);
            }
            if (existingDocument == null && (existingDocument = this.isDocumentExist(existingDocuments, document.getName())) != null) {
                document.setPk(new DocumentPK((int)existingDocument.getPk().getOldSilverpeasId(), objectPK.getInstanceId()));
            }
            if (existingDocument != null && existingDocument.isVersioned()) {
                versions = document.getVersionsType().getListVersions();
                for (DocumentVersion version : versions) {
                    version.setInstanceId(objectPK.getInstanceId());
                    existingDocument = this.addVersion(version, existingDocument, userId, indexIt);
                    XMLModelContentType xmlContent = version.getXMLModelContentType();
                    try {
                        if (xmlContent == null) continue;
                        if (xmlIE == null) {
                            xmlIE = new FormTemplateImportExport();
                        }
                        ForeignPK pk = new ForeignPK(version.getPk().getId(), version.getPk().getInstanceId());
                        xmlIE.importXMLModelContentType(pk, "Versioning", xmlContent, Integer.toString(version.getAuthorId()));
                    }
                    catch (Exception e) {
                        SilverTrace.error("versioning", "VersioningImportExport.importDocuments()", "root.MSG_GEN_PARAM_VALUE", e);
                    }
                }
            } else {
                versions = document.getVersionsType().getListVersions();
                SimpleDocument simpleDocument = null;
                for (DocumentVersion version : versions) {
                    XMLModelContentType xmlContent;
                    if (simpleDocument == null) {
                        boolean isPublic;
                        if (version.getCreationDate() == null) {
                            version.setCreationDate(new Date());
                        }
                        if (version.getAuthorId() == -1) {
                            version.setAuthorId(userId);
                        }
                        xmlContent = version.getXMLModelContentType();
                        String xmlFormId = null;
                        if (xmlContent != null) {
                            xmlFormId = xmlContent.getName();
                        }
                        simpleDocument = new HistorisedDocument(new SimpleDocumentPK(null, objectPK.getInstanceId()), objectPK.getId(), -1, new SimpleAttachment(version.getLogicalName(), I18NHelper.defaultLanguage, document.getName(), document.getDescription(), version.getSize(), version.getMimeType(), version.getAuthorId() + "", version.getCreationDate(), xmlFormId));
                        simpleDocument.setStatus("0");
                        boolean bl = isPublic = version.getType() == 0;
                        if (isPublic) {
                            launchCallback = true;
                            userIdCallback = version.getAuthorId();
                        }
                        simpleDocument.setPublicDocument(isPublic);
                        InputStream content = this.getVersionContent(version);
                        simpleDocument.setContentType(version.getMimeType());
                        simpleDocument.setSize(version.getSize());
                        simpleDocument.setFilename(version.getLogicalName());
                        simpleDocument = AttachmentServiceFactory.getAttachmentService().createAttachment(simpleDocument, content, indexIt);
                        IOUtils.closeQuietly((InputStream)content);
                    } else {
                        simpleDocument = this.addVersion(version, simpleDocument, userId, indexIt);
                    }
                    importedDocs.add(simpleDocument);
                    try {
                        xmlContent = version.getXMLModelContentType();
                        if (xmlContent == null) continue;
                        if (xmlIE == null) {
                            xmlIE = new FormTemplateImportExport();
                        }
                        ForeignPK pk = new ForeignPK(version.getPk().getId(), version.getPk().getInstanceId());
                        xmlIE.importXMLModelContentType(pk, "Versioning", xmlContent, Integer.toString(version.getAuthorId()));
                    }
                    catch (Exception e) {
                        SilverTrace.error("versioning", "VersioningImportExport.importDocuments()", "root.MSG_GEN_PARAM_VALUE", e);
                    }
                }
            }
            if (!launchCallback) continue;
            CallBackManager callBackManager = CallBackManager.get();
            callBackManager.invoke(13, userIdCallback, objectPK.getInstanceId(), objectPK.getId());
        }
        return importedDocs;
    }

    private SimpleDocument isDocumentExist(List<SimpleDocument> documents, String name) {
        if (name != null) {
            for (SimpleDocument document : documents) {
                if (!name.equalsIgnoreCase(document.getFilename()) && !name.equalsIgnoreCase(document.getTitle())) continue;
                return document;
            }
        }
        return null;
    }

    protected SimpleDocument addVersion(DocumentVersion version, SimpleDocument existingDocument, int userId, boolean indexIt) throws FileNotFoundException {
        boolean isPublic = version.getType() == 0;
        boolean launchCallback = version.getType() == 0;
        existingDocument.setPublicDocument(isPublic);
        existingDocument.setStatus("0");
        existingDocument.setUpdated(new Date());
        existingDocument.setUpdatedBy("" + userId);
        XMLModelContentType xmlContent = version.getXMLModelContentType();
        if (xmlContent != null) {
            existingDocument.setXmlFormId(xmlContent.getName());
        }
        AttachmentServiceFactory.getAttachmentService().lock(existingDocument.getId(), "" + userId, existingDocument.getLanguage());
        AttachmentServiceFactory.getAttachmentService().updateAttachment(existingDocument, this.getVersionContent(version), indexIt, launchCallback);
        AttachmentServiceFactory.getAttachmentService().unlock(new UnlockContext(existingDocument.getId(), "" + userId, existingDocument.getLanguage()));
        return AttachmentServiceFactory.getAttachmentService().searchDocumentById(existingDocument.getPk(), existingDocument.getLanguage());
    }

    InputStream getVersionContent(DocumentVersion version) throws FileNotFoundException {
        File file = new File(FileUtil.convertPathToServerOS(version.getDocumentPath()));
        if (file == null || !file.exists() || !file.isFile()) {
            String baseDir = this.resources.getString("importRepository");
            file = new File(FileUtil.convertPathToServerOS(baseDir + File.separatorChar + version.getPhysicalName()));
        }
        version.setMimeType(FileUtil.getMimeType(file.getName()));
        if (!StringUtil.isDefined(version.getLogicalName())) {
            version.setLogicalName(file.getName());
        }
        version.setSize(file.length());
        return new FileInputStream(file);
    }
}

