/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.process.io.file;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.silverpeas.process.io.file.AbstractFileHandler;
import org.silverpeas.process.io.file.FileBasePath;
import org.silverpeas.process.io.file.HandledFile;
import org.silverpeas.process.session.ProcessSession;

public class FileHandler
extends AbstractFileHandler {
    protected FileHandler(ProcessSession session) {
        super(session);
    }

    public File getFile(String ... names) {
        return FileUtils.getFile((String[])names);
    }

    public File getFile(File file, String ... names) {
        return FileUtils.getFile((File)file, (String[])names);
    }

    public File getSessionTemporaryFile(String ... names) {
        return FileUtils.getFile((File)this.getSessionTemporaryPath(), (String[])names);
    }

    public HandledFile getHandledFile(FileBasePath basePath, String ... names) {
        return this.getHandledFile(basePath, new File(basePath.getPath()), names);
    }

    public HandledFile getHandledFile(FileBasePath basePath, File file, String ... names) {
        this.verify(basePath, file);
        return new HandledFile(basePath, this, this.getExistingFile(basePath, FileUtils.getFile((File)file, (String[])names)));
    }

    protected boolean exists(FileBasePath basePath, File file, String ... names) {
        this.verify(basePath, file);
        return FileHandler.exists(this.getExistingFile(basePath, FileUtils.getFile((File)file, (String[])names)));
    }

    protected OutputStream openOutputStream(FileBasePath basePath, File file) throws Exception {
        return this.openOutputStream(basePath, file, false);
    }

    protected OutputStream openOutputStream(FileBasePath basePath, File file, boolean append) throws Exception {
        this.verify(basePath, file);
        return FileUtils.openOutputStream((File)this.getFileForWriting(basePath, file, append), (boolean)append);
    }

    protected InputStream openInputStream(FileBasePath basePath, File file) throws Exception {
        this.verify(basePath, file);
        File sessionFile = this.translateToSessionPath(basePath, file);
        if (sessionFile.exists()) {
            return FileUtils.openInputStream((File)sessionFile);
        }
        return FileUtils.openInputStream((File)this.translateToRealPath(basePath, file));
    }

    protected void touch(FileBasePath basePath, File file, String ... names) throws Exception {
        this.verify(basePath, file);
        FileUtils.touch((File)this.getFileForWriting(basePath, FileUtils.getFile((File)file, (String[])names), true));
    }

    protected Collection<File> listFiles(FileBasePath basePath, File directory, String ... extensions) {
        return this.listFiles(basePath, directory, true, extensions);
    }

    protected Collection<File> listFiles(FileBasePath basePath, File directory, boolean recursive, String ... extensions) {
        this.verify(basePath, directory);
        if (extensions.length == 0) {
            extensions = null;
        }
        File sessionDirectory = this.translateToSessionPath(basePath, directory);
        File realDirectory = this.translateToRealPath(basePath, directory);
        Collection listFiles = null;
        if (sessionDirectory.exists()) {
            listFiles = FileUtils.listFiles((File)sessionDirectory, (String[])extensions, (boolean)recursive);
        }
        Collection realFiles = null;
        if (realDirectory.exists()) {
            realFiles = FileUtils.listFiles((File)realDirectory, (String[])extensions, (boolean)recursive);
        }
        return this.mergeFileLists(basePath, listFiles, realFiles);
    }

    protected Collection<File> listFiles(FileBasePath basePath, File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        this.verify(basePath, directory);
        File sessionDirectory = this.translateToSessionPath(basePath, directory);
        File realDirectory = this.translateToRealPath(basePath, directory);
        Collection listFiles = null;
        if (sessionDirectory.exists()) {
            listFiles = FileUtils.listFiles((File)sessionDirectory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        }
        Collection realFiles = null;
        if (realDirectory.exists()) {
            realFiles = FileUtils.listFiles((File)realDirectory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        }
        return this.mergeFileLists(basePath, listFiles, realFiles);
    }

    private Collection<File> mergeFileLists(FileBasePath basePath, Collection<File> sessionFiles, Collection<File> realFiles) {
        LinkedList<File> listFiles = new LinkedList<File>();
        HashSet<String> filePaths = new HashSet<String>();
        if (sessionFiles != null) {
            for (File sessionFile : sessionFiles) {
                listFiles.add(sessionFile);
                filePaths.add(this.translateToRealPath(basePath, sessionFile).getPath());
            }
        }
        if (realFiles != null) {
            for (File realFile : realFiles) {
                if (filePaths.contains(realFile.getPath()) || this.isMarkedToDelete(basePath, realFile)) continue;
                listFiles.add(realFile);
            }
        }
        return listFiles;
    }

    protected boolean contentEquals(FileBasePath basePath, File file1, File file2) throws Exception {
        this.verify(basePath, file1);
        this.verify(basePath, file2);
        return FileUtils.contentEquals((File)this.getExistingFile(basePath, file1), (File)this.getExistingFile(basePath, file2));
    }

    protected boolean contentEquals(File file1, FileBasePath basePath, File file2) throws Exception {
        this.verify(basePath, file2);
        return FileUtils.contentEquals((File)file1, (File)this.getExistingFile(basePath, file2));
    }

    protected void copyFile(FileBasePath basePath, File srcFile, File destFile) throws Exception {
        this.copyFile(basePath, srcFile, basePath, destFile);
    }

    protected void copyFile(FileBasePath basePath, File srcFile, FileBasePath basePathDest, File destFile) throws Exception {
        this.verify(basePath, srcFile);
        this.verify(basePathDest, destFile);
        FileUtils.copyFile((File)this.getExistingFile(basePath, srcFile), (File)this.getFileForWriting(basePathDest, destFile));
    }

    public void copyFile(File srcFile, HandledFile destFile) throws Exception {
        FileUtils.copyFile((File)srcFile, (File)destFile.getFile());
    }

    protected long copyFile(FileBasePath basePath, File input2, OutputStream output) throws Exception {
        this.verify(basePath, input2);
        return FileUtils.copyFile((File)this.getExistingFile(basePath, input2), (OutputStream)output);
    }

    protected void copyURLToFile(URL source, FileBasePath basePath, File destination) throws Exception {
        this.verify(basePath, destination);
        FileUtils.copyURLToFile((URL)source, (File)this.getFileForWriting(basePath, destination));
    }

    protected boolean delete(FileBasePath basePath, File file) throws Exception {
        this.verify(basePath, file);
        boolean isFirstTimeMarkedToBeDeleted = this.markToDelete(basePath, file);
        boolean isDeletedInSession = FileUtils.deleteQuietly((File)this.translateToSessionPath(basePath, file));
        return isFirstTimeMarkedToBeDeleted || isDeletedInSession;
    }

    protected void cleanDirectory(FileBasePath basePath, File directory) throws Exception {
        this.verify(basePath, directory);
        directory = this.translateToSessionPath(basePath, directory);
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        Collection<File> files = this.listFiles(basePath, directory, new String[0]);
        if (files == null) {
            throw new Exception("Failed to list contents of " + directory);
        }
        for (File file : files) {
            this.delete(basePath, file);
        }
    }

    protected boolean waitFor(FileBasePath basePath, File file, int seconds) {
        this.verify(basePath, file);
        return FileUtils.waitFor((File)this.getExistingFile(basePath, file), (int)seconds);
    }

    protected String readFileToString(FileBasePath basePath, File file) throws Exception {
        return this.readFileToString(basePath, file, null);
    }

    protected String readFileToString(FileBasePath basePath, File file, String encoding) throws Exception {
        this.verify(basePath, file);
        return FileUtils.readFileToString((File)this.getExistingFile(basePath, file), (String)encoding);
    }

    protected byte[] readFileToByteArray(FileBasePath basePath, File file) throws Exception {
        this.verify(basePath, file);
        return FileUtils.readFileToByteArray((File)this.getExistingFile(basePath, file));
    }

    protected List<String> readLines(FileBasePath basePath, File file) throws Exception {
        return this.readLines(basePath, file, null);
    }

    protected List<String> readLines(FileBasePath basePath, File file, String encoding) throws Exception {
        this.verify(basePath, file);
        return FileUtils.readLines((File)this.getExistingFile(basePath, file), (String)encoding);
    }

    protected void writeStringToFile(FileBasePath basePath, File file, String data) throws Exception {
        this.writeStringToFile(basePath, file, data, null, false);
    }

    protected void writeStringToFile(FileBasePath basePath, File file, String data, String encoding) throws Exception {
        this.writeStringToFile(basePath, file, data, encoding, false);
    }

    protected void writeStringToFile(FileBasePath basePath, File file, String data, boolean append) throws Exception {
        this.writeStringToFile(basePath, file, data, null, append);
    }

    protected void writeStringToFile(FileBasePath basePath, File file, String data, String encoding, boolean append) throws Exception {
        this.verify(basePath, file);
        FileUtils.writeStringToFile((File)this.getFileForWriting(basePath, file, append), (String)data, (String)encoding, (boolean)append);
    }

    protected void write(FileBasePath basePath, File file, CharSequence data) throws Exception {
        this.write(basePath, file, data, null, false);
    }

    protected void write(FileBasePath basePath, File file, CharSequence data, boolean append) throws Exception {
        this.write(basePath, file, data, null, append);
    }

    protected void write(FileBasePath basePath, File file, CharSequence data, String encoding) throws Exception {
        this.write(basePath, file, data, encoding, false);
    }

    protected void write(FileBasePath basePath, File file, CharSequence data, String encoding, boolean append) throws Exception {
        this.verify(basePath, file);
        FileUtils.write((File)this.getFileForWriting(basePath, file, append), (CharSequence)data, (String)encoding, (boolean)append);
    }

    protected void writeByteArrayToFile(FileBasePath basePath, File file, byte[] data) throws Exception {
        this.writeByteArrayToFile(basePath, file, data, false);
    }

    protected void writeByteArrayToFile(FileBasePath basePath, File file, byte[] data, boolean append) throws Exception {
        this.verify(basePath, file);
        FileUtils.writeByteArrayToFile((File)this.getFileForWriting(basePath, file, append), (byte[])data, (boolean)append);
    }

    protected void writeLines(FileBasePath basePath, File file, Collection<?> lines) throws Exception {
        this.writeLines(basePath, file, null, lines, null, false);
    }

    protected void writeLines(FileBasePath basePath, File file, Collection<?> lines, boolean append) throws Exception {
        this.writeLines(basePath, file, null, lines, null, append);
    }

    protected void writeLines(FileBasePath basePath, File file, Collection<?> lines, String lineEnding) throws Exception {
        this.writeLines(basePath, file, null, lines, lineEnding, false);
    }

    protected void writeLines(FileBasePath basePath, File file, Collection<?> lines, String lineEnding, boolean append) throws Exception {
        this.writeLines(basePath, file, null, lines, lineEnding, append);
    }

    protected void writeLines(FileBasePath basePath, File file, String encoding, Collection<?> lines) throws Exception {
        this.writeLines(basePath, file, encoding, lines, null, false);
    }

    protected void writeLines(FileBasePath basePath, File file, String encoding, Collection<?> lines, boolean append) throws Exception {
        this.writeLines(basePath, file, encoding, lines, null, append);
    }

    protected void writeLines(FileBasePath basePath, File file, String encoding, Collection<?> lines, String lineEnding) throws Exception {
        this.writeLines(basePath, file, encoding, lines, lineEnding, false);
    }

    protected void writeLines(FileBasePath basePath, File file, String encoding, Collection<?> lines, String lineEnding, boolean append) throws Exception {
        this.verify(basePath, file);
        FileUtils.writeLines((File)this.getFileForWriting(basePath, file, append), (String)encoding, lines, (String)lineEnding, (boolean)append);
    }

    public void moveFile(File srcFile, HandledFile destFile) throws Exception {
        FileUtils.moveFile((File)srcFile, (File)destFile.getFile());
    }

    protected void moveFile(FileBasePath basePath, File srcFile, File destFile) throws Exception {
        this.moveFile(basePath, srcFile, basePath, destFile);
    }

    protected void moveFile(FileBasePath basePath, File srcFile, FileBasePath baseDestPath, File destFile) throws Exception {
        this.verify(basePath, srcFile);
        this.verify(baseDestPath, destFile);
        FileUtils.moveFile((File)this.getFileForWriting(basePath, srcFile, true), (File)this.getFileForWriting(baseDestPath, destFile));
    }

    protected long sizeOf(FileBasePath basePath, File file) {
        this.verify(basePath, file);
        file = this.getExistingFile(basePath, file);
        if (file.isFile()) {
            return FileUtils.sizeOf((File)file);
        }
        return this.sizeOfDirectory(basePath, file);
    }

    protected long sizeOfDirectory(FileBasePath basePath, File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        this.verify(basePath, directory);
        long size = 0L;
        for (File file : this.listFiles(basePath, directory, new String[0])) {
            size += FileUtils.sizeOf((File)file);
        }
        return size;
    }

    protected boolean isFileNewer(FileBasePath basePath, File file, File reference) {
        this.verify(basePath, file);
        this.verify(basePath, reference);
        return FileUtils.isFileNewer((File)this.getExistingFile(basePath, file), (File)this.getExistingFile(basePath, reference));
    }

    protected boolean isFileNewer(FileBasePath basePath, File file, Date date) {
        this.verify(basePath, file);
        return FileUtils.isFileNewer((File)this.getExistingFile(basePath, file), (Date)date);
    }

    protected boolean isFileNewer(FileBasePath basePath, File file, long timeMillis) {
        this.verify(basePath, file);
        return FileUtils.isFileNewer((File)this.getExistingFile(basePath, file), (long)timeMillis);
    }

    protected boolean isFileOlder(FileBasePath basePath, File file, File reference) {
        this.verify(basePath, file);
        this.verify(basePath, reference);
        return FileUtils.isFileOlder((File)this.getExistingFile(basePath, file), (File)this.getExistingFile(basePath, reference));
    }

    protected boolean isFileOlder(FileBasePath basePath, File file, Date date) {
        this.verify(basePath, file);
        return FileUtils.isFileOlder((File)this.getExistingFile(basePath, file), (Date)date);
    }

    protected boolean isFileOlder(FileBasePath basePath, File file, long timeMillis) {
        this.verify(basePath, file);
        return FileUtils.isFileOlder((File)this.getExistingFile(basePath, file), (long)timeMillis);
    }
}

