/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.quota.model;

import com.silverpeas.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EnumSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.silverpeas.quota.contant.QuotaLoad;
import org.silverpeas.quota.contant.QuotaType;
import org.silverpeas.quota.exception.QuotaException;

@Entity
@Table(name="st_quota")
public class Quota
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6564633879921455848L;
    @Id
    @TableGenerator(name="UNIQUE_ID_GEN", table="uniqueId", pkColumnName="tablename", valueColumnName="maxId", pkColumnValue="st_quota", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UNIQUE_ID_GEN")
    @Column(name="id")
    private Long id;
    @Column(name="quotaType", nullable=false)
    private String type;
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="minCount", nullable=false)
    private long minCount = 0L;
    @Column(name="maxCount", nullable=false)
    private long maxCount = 0L;
    @Column(name="currentCount", nullable=false)
    private long count = 0L;
    @Column(name="saveDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date saveDate;

    @PrePersist
    @PreUpdate
    private void performSaveDate() {
        this.setSaveDate(new Date());
    }

    public boolean exists() {
        return this.getId() != null;
    }

    public void validate() throws QuotaException {
        if (this.getType() == null || !StringUtil.isDefined(this.getResourceId())) {
            throw new QuotaException(this, "HAS_BAD_DATA");
        }
        this.validateBounds();
    }

    public void validateBounds() throws QuotaException {
        if (this.getMinCount() < 0L || this.getMaxCount() < 0L || this.getMinCount() > this.getMaxCount()) {
            throw new QuotaException(this, "HAS_BAD_DATA");
        }
    }

    public QuotaLoad getLoad() {
        QuotaLoad quotaLoad = this.getMaxCount() > 0L ? (this.getCount() > this.getMaxCount() ? QuotaLoad.OUT_OF_BOUNDS : (this.getCount() == 0L ? QuotaLoad.EMPTY : (this.getCount() < this.getMinCount() ? QuotaLoad.NOT_ENOUGH : (this.getCount() == this.getMaxCount() ? QuotaLoad.FULL : QuotaLoad.NOT_FULL)))) : QuotaLoad.UNLIMITED;
        return quotaLoad;
    }

    public boolean isReached() {
        return this.exists() && EnumSet.of(QuotaLoad.FULL, QuotaLoad.OUT_OF_BOUNDS).contains((Object)this.getLoad());
    }

    public BigDecimal getLoadRate() {
        BigDecimal loadRate = !QuotaLoad.UNLIMITED.equals((Object)this.getLoad()) ? new BigDecimal(String.valueOf(this.getCount())).divide(new BigDecimal(String.valueOf(this.getMaxCount())), 20, 5) : BigDecimal.ZERO;
        return loadRate;
    }

    public BigDecimal getLoadPercentage() {
        return this.getLoadRate().multiply(new BigDecimal(String.valueOf(100))).setScale(2, 5);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public QuotaType getType() {
        if (this.type == null) {
            return null;
        }
        return QuotaType.valueOf(this.type);
    }

    public void setType(QuotaType type) {
        this.type = type == null ? null : type.name();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public long getMinCount() {
        return this.minCount;
    }

    public void setMinCount(long minCount) {
        this.minCount = minCount;
    }

    public void setMinCount(String minCount) throws QuotaException {
        try {
            this.setMinCount(Long.valueOf(minCount));
        }
        catch (NumberFormatException nfe) {
            throw new QuotaException(this, "BAD_MIN_COUNT");
        }
    }

    public long getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(long maxCount) {
        this.maxCount = maxCount;
    }

    public void setMaxCount(String maxCount) throws QuotaException {
        try {
            this.setMaxCount(Long.valueOf(maxCount));
        }
        catch (NumberFormatException nfe) {
            throw new QuotaException(this, "BAD_MAX_COUNT");
        }
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public Date getSaveDate() {
        return this.saveDate;
    }

    public void setSaveDate(Date saveDate) {
        this.saveDate = saveDate;
    }

    public Quota clone() {
        Quota quota;
        try {
            quota = (Quota)super.clone();
            quota.setId(null);
        }
        catch (CloneNotSupportedException e) {
            quota = null;
        }
        return quota;
    }
}

