/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.quota.service;

import javax.inject.Inject;
import org.silverpeas.quota.QuotaKey;
import org.silverpeas.quota.contant.QuotaLoad;
import org.silverpeas.quota.exception.QuotaException;
import org.silverpeas.quota.exception.QuotaFullException;
import org.silverpeas.quota.exception.QuotaNotEnoughException;
import org.silverpeas.quota.exception.QuotaOutOfBoundsException;
import org.silverpeas.quota.model.Quota;
import org.silverpeas.quota.offset.AbstractQuotaCountingOffset;
import org.silverpeas.quota.offset.SimpleQuotaCountingOffset;
import org.silverpeas.quota.repository.QuotaRepository;
import org.silverpeas.quota.service.QuotaService;
import org.silverpeas.quota.service.dao.QuotaDAO;
import org.silverpeas.quota.service.dao.jdbc.JDBCQuotaDAO;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractQuotaService<T extends QuotaKey>
implements QuotaService<T> {
    @Inject
    private QuotaRepository quotaRepository;
    private static QuotaDAO quotaDAO = new JDBCQuotaDAO();

    @Override
    public Quota initialize(T key, long maxCount) throws QuotaException {
        return this.initialize(key, 0L, maxCount);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Quota initialize(T key, long minCount, long maxCount) throws QuotaException {
        Quota quota = this.getByQuotaKey(key, false);
        if (!quota.exists()) {
            if (maxCount == 0L) {
                return quota;
            }
            quota.setType(key.getQuotaType());
            quota.setResourceId(key.getResourceId());
        }
        if (!quota.exists() || minCount != quota.getMinCount() || maxCount != quota.getMaxCount()) {
            quota.setMinCount(minCount);
            quota.setMaxCount(maxCount);
            quota.validate();
            this.quotaRepository.saveAndFlush(quota);
        }
        return quota;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Quota get(T key) throws QuotaException {
        Quota quota = this.getByQuotaKey(key, false);
        if (quota.exists()) {
            long currentCount = this.getCurrentCount(key);
            if (quota.getCount() != currentCount) {
                quota.setCount(currentCount);
                this.quotaRepository.saveAndFlush(quota);
            }
        }
        return quota;
    }

    private Quota getByQuotaKey(T key, boolean jpaBypass) {
        Quota quota = null;
        if (key.isValid()) {
            quota = jpaBypass ? quotaDAO.getByTypeAndResourceId(key.getQuotaType().name(), key.getResourceId()) : this.quotaRepository.getByTypeAndResourceId(key.getQuotaType().name(), key.getResourceId());
        }
        if (quota == null) {
            quota = new Quota();
        }
        return quota;
    }

    @Override
    public Quota verify(T key) throws QuotaException {
        return this.verify(key, SimpleQuotaCountingOffset.from(0L));
    }

    @Override
    public Quota verify(T key, AbstractQuotaCountingOffset countingOffset) throws QuotaException {
        return this.verify(key, this.getByQuotaKey(key, true), countingOffset);
    }

    protected Quota verify(T key, Quota quota, AbstractQuotaCountingOffset countingOffset) throws QuotaException {
        if (quota.exists()) {
            quota.setCount(this.getCurrentCount(key) + countingOffset.getOffset());
            QuotaLoad quotaLoad = quota.getLoad();
            if (QuotaLoad.OUT_OF_BOUNDS.equals((Object)quotaLoad)) {
                throw new QuotaOutOfBoundsException(quota);
            }
            if (QuotaLoad.FULL.equals((Object)quotaLoad)) {
                throw new QuotaFullException(quota);
            }
            if (QuotaLoad.NOT_ENOUGH.equals((Object)quotaLoad)) {
                throw new QuotaNotEnoughException(quota);
            }
        }
        return quota;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void remove(T key) {
        Quota quota = this.getByQuotaKey(key, false);
        if (quota.exists()) {
            this.quotaRepository.delete(quota);
        }
    }
}

