/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.search.indexEngine.model.AddIndexEntryRequest;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;
import org.silverpeas.search.indexEngine.model.IndexManager;
import org.silverpeas.search.indexEngine.model.RemoveIndexEntryRequest;
import org.silverpeas.search.indexEngine.model.Request;

public class IndexerThread
extends Thread {
    private static final List<Request> requestList = new ArrayList<Request>();
    private static IndexerThread indexerThread = null;
    private final IndexManager indexManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(IndexManager indexManager) {
        List<Request> list = requestList;
        synchronized (list) {
            if (indexerThread == null) {
                SilverTrace.debug("indexEngine", "IndexerThread", "indexEngine.INFO_STARTS_INDEXER_THREAD");
                indexerThread = new IndexerThread(indexManager);
                indexerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIndexEntry(FullIndexEntry indexEntry) {
        List<Request> list = requestList;
        synchronized (list) {
            SilverTrace.debug("indexEngine", "IndexerThread", "indexEngine.INFO_ADDS_ADD_REQUEST", indexEntry.toString());
            requestList.add(new AddIndexEntryRequest(indexEntry));
            requestList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIndexEntry(IndexEntryPK indexEntry) {
        List<Request> list = requestList;
        synchronized (list) {
            SilverTrace.debug("indexEngine", "IndexerThread", "indexEngine.INFO_ADDS_REMOVE_REQUEST", indexEntry.toString());
            requestList.add(new RemoveIndexEntryRequest(indexEntry));
            requestList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Request request = null;
            List<Request> list = requestList;
            synchronized (list) {
                SilverTrace.info("indexEngine", "IndexerThread", "root.MSG_GEN_PARAM_VALUE", "# of items to index = " + requestList.size());
                if (!requestList.isEmpty()) {
                    request = requestList.remove(0);
                }
            }
            if (request != null) {
                request.process(this.indexManager);
            }
            if (request != null) continue;
            this.indexManager.optimize();
            try {
                list = requestList;
                synchronized (list) {
                    if (requestList.isEmpty()) {
                        requestList.wait();
                    }
                    continue;
                }
            }
            catch (InterruptedException e) {
                SilverTrace.debug("indexEngine", "IndexerThread", "indexEngine.INFO_INTERRUPTED_WHILE_WAITING");
                continue;
            }
            break;
        }
    }

    private IndexerThread(IndexManager indexManager) {
        this.indexManager = indexManager;
    }
}

