/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.searchEngine.model;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Version;
import org.silverpeas.search.indexEngine.model.ExternalComponent;
import org.silverpeas.search.indexEngine.model.FieldDescription;
import org.silverpeas.search.indexEngine.model.IndexEntryPK;
import org.silverpeas.search.indexEngine.model.IndexManager;
import org.silverpeas.search.indexEngine.model.IndexReadersCache;
import org.silverpeas.search.indexEngine.model.SpaceComponentPair;
import org.silverpeas.search.searchEngine.model.MatchingIndexEntry;
import org.silverpeas.search.searchEngine.model.ParseException;
import org.silverpeas.search.searchEngine.model.QueryDescription;
import org.silverpeas.search.util.SearchEnginePropertiesManager;

public class WAIndexSearcher {
    private int primaryFactor = 3;
    private int secondaryFactor = 1;
    public static QueryParser.Operator defaultOperand = QueryParser.AND_OPERATOR;
    public static int maxNumberResult = 0;
    private final IndexManager indexManager = new IndexManager();

    public WAIndexSearcher() {
        this.primaryFactor = WAIndexSearcher.getFactorFromProperties("PrimaryFactor", this.primaryFactor);
        this.secondaryFactor = WAIndexSearcher.getFactorFromProperties("SecondaryFactor", this.secondaryFactor);
    }

    public static int getFactorFromProperties(String propertyName, int defaultValue) {
        ResourceLocator resource = new ResourceLocator("org.silverpeas.search.indexEngine.IndexEngine", "");
        return resource.getInteger(propertyName, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatchingIndexEntry search(String component, String objectId, String objectType) {
        SpaceComponentPair pair = new SpaceComponentPair(null, component);
        HashSet<SpaceComponentPair> set = new HashSet<SpaceComponentPair>(1);
        set.add(pair);
        IndexEntryPK indexEntryPK = new IndexEntryPK(component, objectType, objectId);
        MatchingIndexEntry matchingIndexEntry = null;
        IndexSearcher searcher = this.getSearcher(set);
        try {
            Term term = new Term("key", indexEntryPK.toString());
            TermQuery query = new TermQuery(term);
            TopDocs topDocs = searcher.search((Query)query, maxNumberResult);
            ScoreDoc scoreDoc = topDocs.scoreDocs[0];
            matchingIndexEntry = this.createMatchingIndexEntry(scoreDoc, "*", searcher);
        }
        catch (IOException ioe) {
            SilverTrace.fatal("searchEngine", "WAIndexSearcher.search()", "searchEngine.MSG_CORRUPTED_INDEX_FILE", ioe);
        }
        finally {
            IOUtils.closeQuietly((Closeable)searcher);
        }
        return matchingIndexEntry;
    }

    public MatchingIndexEntry[] search(QueryDescription query) throws ParseException {
        List<Object> results;
        long startTime = System.nanoTime();
        IndexSearcher searcher = this.getSearcher(query);
        try {
            TopDocs topDocs;
            BooleanQuery booleanQuery = new BooleanQuery();
            BooleanQuery rangeClauses = new BooleanQuery();
            rangeClauses.add((Query)this.getVisibilityStartQuery(), BooleanClause.Occur.MUST);
            rangeClauses.add((Query)this.getVisibilityEndQuery(), BooleanClause.Occur.MUST);
            if (query.getXmlQuery() != null) {
                booleanQuery.add(this.getXMLQuery(query, (Searcher)searcher), BooleanClause.Occur.MUST);
            } else if (query.getMultiFieldQuery() != null) {
                booleanQuery.add(this.getMultiFieldQuery(query, (Searcher)searcher), BooleanClause.Occur.MUST);
            } else {
                PrefixQuery termQueryOnFolder;
                TermQuery termQueryOnAuthor;
                TermRangeQuery rangeQueryOnLastUpdateDate;
                TermRangeQuery rangeQuery = this.getRangeQueryOnCreationDate(query);
                if (!StringUtil.isDefined(query.getQuery()) && (query.isSearchBySpace() || query.isSearchByComponentType()) && !query.isPeriodDefined()) {
                    rangeQuery = new TermRangeQuery("creationDate", "1900/01/01", "2200/01/01", true, true);
                }
                if (rangeQuery != null) {
                    rangeClauses.add((Query)rangeQuery, BooleanClause.Occur.MUST);
                }
                if ((rangeQueryOnLastUpdateDate = this.getRangeQueryOnLastUpdateDate(query)) != null) {
                    rangeClauses.add((Query)rangeQueryOnLastUpdateDate, BooleanClause.Occur.MUST);
                }
                if ((termQueryOnAuthor = this.getTermQueryOnAuthor(query)) != null) {
                    booleanQuery.add((Query)termQueryOnAuthor, BooleanClause.Occur.MUST);
                }
                if ((termQueryOnFolder = this.getTermQueryOnFolder(query)) != null) {
                    booleanQuery.add((Query)termQueryOnFolder, BooleanClause.Occur.MUST);
                }
                try {
                    Query plainTextQuery = this.getPlainTextQuery(query, "content");
                    if (plainTextQuery != null) {
                        booleanQuery.add(plainTextQuery, BooleanClause.Occur.MUST);
                    }
                }
                catch (org.apache.lucene.queryParser.ParseException e) {
                    throw new ParseException("WAIndexSearcher", (Exception)((Object)e));
                }
            }
            SilverTrace.info("searchEngine", "WAIndexSearcher.search()", "root.MSG_GEN_PARAM_VALUE", "Query = " + booleanQuery.toString());
            if (booleanQuery.getClauses().length == 0) {
                topDocs = searcher.search((Query)rangeClauses, null, maxNumberResult);
            } else {
                QueryWrapperFilter wrappedFilter = new QueryWrapperFilter((Query)rangeClauses);
                topDocs = searcher.search((Query)booleanQuery, (Filter)wrappedFilter, maxNumberResult);
            }
            results = this.makeList(topDocs, query, searcher);
        }
        catch (IOException ioe) {
            SilverTrace.fatal("searchEngine", "WAIndexSearcher.search()", "searchEngine.MSG_CORRUPTED_INDEX_FILE", ioe);
            results = new ArrayList();
        }
        long endTime = System.nanoTime();
        SilverTrace.debug("searchEngine", WAIndexSearcher.class.toString(), " search duration in ms " + (endTime - startTime) / 1000000L);
        return results.toArray(new MatchingIndexEntry[results.size()]);
    }

    private TermRangeQuery getVisibilityStartQuery() {
        return new TermRangeQuery("startDate", "0000/00/00", DateUtil.today2SQLDate(), true, true);
    }

    private TermRangeQuery getVisibilityEndQuery() {
        return new TermRangeQuery("endDate", DateUtil.today2SQLDate(), "9999/99/99", true, true);
    }

    private Query getPlainTextQuery(QueryDescription query, String searchField) throws org.apache.lucene.queryParser.ParseException {
        Query parsedQuery;
        if (!StringUtil.isDefined(query.getQuery())) {
            return null;
        }
        String language = query.getRequestedLanguage();
        Analyzer analyzer = this.indexManager.getAnalyzer(language);
        if (I18NHelper.isI18N && "*".equals(language)) {
            String[] fields = new String[I18NHelper.getNumberOfLanguages()];
            int l = 0;
            Iterator<String> languages = I18NHelper.getLanguages();
            while (languages.hasNext()) {
                language = languages.next();
                fields[l] = I18NHelper.isDefaultLanguage(language) ? searchField : searchField + "_" + language;
                ++l;
            }
            MultiFieldQueryParser mfqp = new MultiFieldQueryParser(Version.LUCENE_36, fields, analyzer);
            mfqp.setDefaultOperator(defaultOperand);
            parsedQuery = mfqp.parse(query.getQuery());
        } else {
            if (I18NHelper.isI18N && !"*".equals(language) && !I18NHelper.isDefaultLanguage(language)) {
                searchField = searchField + "_" + language;
            }
            QueryParser queryParser = new QueryParser(Version.LUCENE_36, searchField, analyzer);
            queryParser.setDefaultOperator(defaultOperand);
            SilverTrace.info("searchEngine", "WAIndexSearcher.getPlainTextQuery", "root.MSG_GEN_PARAM_VALUE", "defaultOperand = " + defaultOperand);
            parsedQuery = queryParser.parse(query.getQuery());
            SilverTrace.info("searchEngine", "WAIndexSearcher.getPlainTextQuery", "root.MSG_GEN_PARAM_VALUE", "getOperator() = " + queryParser.getDefaultOperator());
        }
        SilverTrace.info("searchEngine", "WAIndexSearcher.getPlainTextQuery", "root.MSG_GEN_PARAM_VALUE", "parsedQuery = " + parsedQuery.toString());
        return parsedQuery;
    }

    private Query getXMLQuery(QueryDescription query, Searcher searcher) throws ParseException {
        try {
            Map<String, String> xmlQuery = query.getXmlQuery();
            String xmlTitle = query.getXmlTitle();
            int nbFields = xmlQuery.size();
            if (StringUtil.isDefined(xmlTitle)) {
                ++nbFields;
            }
            String[] fields = xmlQuery.keySet().toArray(new String[nbFields]);
            String[] queries = xmlQuery.values().toArray(new String[nbFields]);
            if (StringUtil.isDefined(xmlTitle)) {
                fields[nbFields - 1] = "title";
                queries[nbFields - 1] = xmlTitle;
            }
            Analyzer analyzer = this.indexManager.getAnalyzer(query.getRequestedLanguage());
            BooleanClause.Occur[] flags = new BooleanClause.Occur[fields.length];
            for (int f = 0; f < fields.length; ++f) {
                flags[f] = BooleanClause.Occur.MUST;
            }
            Query parsedQuery = MultiFieldQueryParser.parse((Version)Version.LUCENE_36, (String[])queries, (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)analyzer);
            SilverTrace.info("searchEngine", "WAIndexSearcher.getXMLHits", "root.MSG_GEN_PARAM_VALUE", "parsedQuery = " + parsedQuery.toString());
            return parsedQuery;
        }
        catch (org.apache.lucene.queryParser.ParseException e) {
            throw new ParseException("WAIndexSearcher", (Exception)((Object)e));
        }
    }

    private Query getMultiFieldQuery(QueryDescription query, Searcher searcher) throws ParseException {
        try {
            List<FieldDescription> fieldQueries = query.getMultiFieldQuery();
            String keyword = query.getQuery();
            int nbFields = fieldQueries.size();
            if (StringUtil.isDefined(keyword)) {
                ++nbFields;
            }
            String[] fields = new String[nbFields];
            String[] queries = new String[nbFields];
            BooleanClause.Occur[] flags = new BooleanClause.Occur[nbFields];
            if (StringUtil.isDefined(keyword)) {
                flags[nbFields - 1] = BooleanClause.Occur.MUST;
                fields[nbFields - 1] = "header";
                queries[nbFields - 1] = keyword;
            }
            for (int f = 0; f < fieldQueries.size(); ++f) {
                FieldDescription fieldQuery = fieldQueries.get(f);
                flags[f] = BooleanClause.Occur.MUST;
                fields[f] = fieldQuery.getFieldName();
                queries[f] = fieldQuery.getContent();
            }
            Analyzer analyzer = this.indexManager.getAnalyzer(query.getRequestedLanguage());
            Query parsedQuery = MultiFieldQueryParser.parse((Version)Version.LUCENE_36, (String[])queries, (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)analyzer);
            SilverTrace.info("searchEngine", "WAIndexSearcher.getMultiFieldHits", "root.MSG_GEN_PARAM_VALUE", "parsedQuery = " + parsedQuery.toString());
            return parsedQuery;
        }
        catch (org.apache.lucene.queryParser.ParseException e) {
            throw new ParseException("WAIndexSearcher", (Exception)((Object)e));
        }
    }

    private MatchingIndexEntry createMatchingIndexEntry(ScoreDoc scoreDoc, String requestedLanguage, IndexSearcher searcher) throws IOException {
        String fieldsForFacets;
        Document doc = searcher.doc(scoreDoc.doc);
        MatchingIndexEntry indexEntry = new MatchingIndexEntry(IndexEntryPK.create(doc.get("key")));
        Iterator<String> languages = I18NHelper.getLanguages();
        while (languages.hasNext()) {
            String language = languages.next();
            if (I18NHelper.isDefaultLanguage(language)) {
                indexEntry.setTitle(doc.get("title"), language);
                indexEntry.setPreview(doc.get("preview"), language);
                continue;
            }
            indexEntry.setTitle(doc.get("title_" + language), language);
            indexEntry.setPreview(doc.get("preview_" + language), language);
        }
        indexEntry.setKeyWords(doc.get("keywords"));
        indexEntry.setCreationUser(doc.get("creationUser"));
        indexEntry.setCreationDate(doc.get("creationDate"));
        indexEntry.setLastModificationUser(doc.get("updateUser"));
        indexEntry.setLastModificationDate(doc.get("updateDate"));
        indexEntry.setThumbnail(doc.get("thumbnail"));
        indexEntry.setThumbnailMimeType(doc.get("thumbnailMimeType"));
        indexEntry.setThumbnailDirectory(doc.get("thumbnailDirectory"));
        indexEntry.setStartDate(doc.get("startDate"));
        indexEntry.setEndDate(doc.get("endDate"));
        indexEntry.setEmbeddedFileIds(doc.getValues("embeddedFileIds"));
        indexEntry.setFilename(doc.get("filename"));
        indexEntry.setAlias(StringUtil.getBooleanValue(doc.get("alias")));
        indexEntry.setScore(scoreDoc.score);
        if ("Publication".equals(indexEntry.getObjectType())) {
            HashMap<String, String> sortableField = new HashMap<String, String>();
            for (String formXMLFieldName : SearchEnginePropertiesManager.getFieldsNameList()) {
                String fieldValue = "*".equals(requestedLanguage) || I18NHelper.isDefaultLanguage(requestedLanguage) ? doc.get(formXMLFieldName) : doc.get(formXMLFieldName + "_" + requestedLanguage);
                if (fieldValue == null) continue;
                sortableField.put(formXMLFieldName, fieldValue);
            }
            indexEntry.setSortableXMLFormFields(sortableField);
        }
        if (StringUtil.isDefined(fieldsForFacets = doc.get("fieldsForFacet"))) {
            HashMap<String, String> fieldsValueForFacets = new HashMap<String, String>();
            StringTokenizer tokenizer = new StringTokenizer(fieldsForFacets, ",");
            while (tokenizer.hasMoreTokens()) {
                String fieldName = tokenizer.nextToken();
                fieldsValueForFacets.put(fieldName, doc.get(fieldName));
            }
            indexEntry.setXMLFormFieldsForFacets(fieldsValueForFacets);
        }
        indexEntry.setServerName(doc.get("serverName"));
        return indexEntry;
    }

    private List<MatchingIndexEntry> makeList(TopDocs topDocs, QueryDescription query, IndexSearcher searcher) throws IOException {
        ArrayList<MatchingIndexEntry> results = new ArrayList<MatchingIndexEntry>();
        if (topDocs != null) {
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                MatchingIndexEntry indexEntry = this.createMatchingIndexEntry(scoreDoc, query.getRequestedLanguage(), searcher);
                results.add(indexEntry);
            }
        }
        return results;
    }

    private IndexSearcher getSearcher(Set<SpaceComponentPair> spaceComponentPairSet) {
        Set<String> indexPathSet = this.getIndexPathSet(spaceComponentPairSet);
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>();
        for (String path : indexPathSet) {
            IndexReader indexReader = this.getIndexReader(path);
            if (indexReader == null) continue;
            readers.add(indexReader);
        }
        return new IndexSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[readers.size()])));
    }

    private IndexSearcher getSearcher(QueryDescription query) {
        Set<String> indexPathSet = this.getIndexPathSet(query.getSpaceComponentPairSet());
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>();
        for (String path : indexPathSet) {
            IndexReader indexReader = this.getIndexReader(path);
            if (indexReader == null) continue;
            readers.add(indexReader);
        }
        Set<ExternalComponent> extSearchers = query.getExtComponents();
        for (ExternalComponent externalComponent : extSearchers) {
            String externalComponentPath = this.getExternalComponentPath(externalComponent);
            IndexReader searcher = this.getIndexReader(externalComponentPath);
            if (searcher == null) continue;
            readers.add(searcher);
        }
        return new IndexSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[readers.size()])));
    }

    private String getExternalComponentPath(ExternalComponent extComp) {
        StringBuilder extStrBuilder = new StringBuilder();
        extStrBuilder.append(extComp.getDataPath()).append(File.separator);
        extStrBuilder.append("index").append(File.separator);
        extStrBuilder.append(extComp.getComponent()).append(File.separator).append("index");
        return extStrBuilder.toString();
    }

    public Set<String> getIndexPathSet(Set<SpaceComponentPair> spaceComponentPairSet) {
        HashSet<String> pathSet = new HashSet<String>();
        for (SpaceComponentPair pair : spaceComponentPairSet) {
            if (pair == null || pair.getComponent() == null) continue;
            pathSet.add(this.indexManager.getIndexDirectoryPath(pair.getSpace(), pair.getComponent()));
        }
        return pathSet;
    }

    private IndexReader getIndexReader(String path) {
        return IndexReadersCache.getIndexReader(path);
    }

    protected TermRangeQuery getRangeQueryOnCreationDate(QueryDescription query) {
        String beginDate = query.getRequestedCreatedAfter();
        String endDate = query.getRequestedCreatedBefore();
        if (!StringUtil.isDefined(beginDate) && !StringUtil.isDefined(endDate)) {
            return null;
        }
        if (!StringUtil.isDefined(beginDate)) {
            beginDate = "0000/00/00";
        }
        if (!StringUtil.isDefined(endDate)) {
            endDate = "9999/99/99";
        }
        return new TermRangeQuery("creationDate", beginDate, endDate, true, true);
    }

    protected TermRangeQuery getRangeQueryOnLastUpdateDate(QueryDescription query) {
        String beginDate = query.getRequestedUpdatedAfter();
        String endDate = query.getRequestedUpdatedBefore();
        if (!StringUtil.isDefined(beginDate) && !StringUtil.isDefined(endDate)) {
            return null;
        }
        if (!StringUtil.isDefined(beginDate)) {
            beginDate = "0000/00/00";
        }
        if (!StringUtil.isDefined(endDate)) {
            endDate = "9999/99/99";
        }
        return new TermRangeQuery("updateDate", beginDate, endDate, true, true);
    }

    protected TermQuery getTermQueryOnAuthor(QueryDescription query) {
        if (!StringUtil.isDefined(query.getRequestedAuthor())) {
            return null;
        }
        Term authorTerm = new Term("creationUser", query.getRequestedAuthor());
        return new TermQuery(authorTerm);
    }

    protected PrefixQuery getTermQueryOnFolder(QueryDescription query) {
        if (!StringUtil.isDefined(query.getRequestedFolder())) {
            return null;
        }
        Term term = new Term("path", query.getRequestedFolder());
        return new PrefixQuery(term);
    }

    static {
        try {
            ResourceLocator resource = new ResourceLocator("org.silverpeas.searchEngine.searchEngineSettings", "");
            int paramOperand = resource.getInteger("defaultOperand", 0);
            defaultOperand = paramOperand == 0 ? QueryParser.OR_OPERATOR : QueryParser.AND_OPERATOR;
            maxNumberResult = resource.getInteger("maxResults", 100);
        }
        catch (MissingResourceException e) {
            SilverTrace.fatal("searchEngine", "WAIndexSearcher.init()", "root.EX_FILE_NOT_FOUND", e);
        }
        catch (NumberFormatException e) {
            SilverTrace.fatal("searchEngine", "WAIndexSearcher.init()", "root.EX_INVALID_ARG", e);
        }
    }
}

