/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.token.model;

import com.silverpeas.util.StringUtil;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.silverpeas.token.constant.TokenType;
import org.silverpeas.token.exception.TokenException;

@Entity
@Table(name="st_token")
public class Token
implements Serializable {
    private static final long serialVersionUID = 5956074363457906409L;
    @Id
    @TableGenerator(name="UNIQUE_ID_GEN", table="uniqueId", pkColumnName="tablename", valueColumnName="maxId", pkColumnValue="st_token", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UNIQUE_ID_GEN")
    @Column(name="id")
    private Long id;
    @Column(name="tokenType", nullable=false)
    private String type = TokenType.UNKNOWN.name();
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="token", nullable=false)
    private String value;
    @Column(name="saveCount", nullable=false)
    private int saveCount = 0;
    @Column(name="saveDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date saveDate;

    @PrePersist
    @PreUpdate
    private void performSaveDate() {
        this.setSaveCount(this.getSaveCount() + 1);
        this.setSaveDate(new Date());
    }

    public boolean exists() {
        return this.getId() != null;
    }

    public void validate() throws TokenException {
        if (this.getType() == null || TokenType.UNKNOWN.equals((Object)this.getType()) || !StringUtil.isDefined(this.getResourceId())) {
            throw new TokenException(this, "EX_DATA_ARE_MISSING");
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TokenType getType() {
        if (this.type == null) {
            return null;
        }
        return TokenType.valueOf(this.type);
    }

    public void setType(TokenType type) {
        this.type = type == null ? null : type.name();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getSaveCount() {
        return this.saveCount;
    }

    public void setSaveCount(int saveCount) {
        this.saveCount = saveCount;
    }

    public Date getSaveDate() {
        return this.saveDate;
    }

    public void setSaveDate(Date saveDate) {
        this.saveDate = saveDate;
    }
}

