/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.token.service;

import com.silverpeas.annotation.Service;
import java.util.UUID;
import javax.inject.Inject;
import org.silverpeas.token.TokenKey;
import org.silverpeas.token.constant.TokenType;
import org.silverpeas.token.exception.TokenException;
import org.silverpeas.token.model.Token;
import org.silverpeas.token.repository.TokenRepository;
import org.silverpeas.token.service.TokenService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultTokenService
implements TokenService {
    @Inject
    private TokenRepository tokenRepository;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Token initialize(TokenKey key) throws TokenException {
        if (TokenType.TOKEN.equals((Object)key.getTokenType())) {
            throw new TokenException(new Token(), "EX_INITIALIZING_FROM_A_TOKEN_IS_FORBIDDEN");
        }
        Token token = this.get(key);
        if (!token.exists()) {
            token.setType(key.getTokenType());
            token.setResourceId(key.getResourceId());
        }
        token.validate();
        token.setValue(UUID.randomUUID().toString().replaceAll("[^0-9a-zA-Z]", ""));
        this.tokenRepository.save(token);
        return token;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Token getInitialized(TokenKey key) throws TokenException {
        Token token = this.get(key);
        if (!token.exists()) {
            token = this.initialize(key);
        }
        return token;
    }

    @Override
    public Token get(TokenKey key) {
        Token token = null;
        if (key.isValid() && !TokenType.UNKNOWN.equals((Object)key.getTokenType())) {
            token = TokenType.TOKEN.equals((Object)key.getTokenType()) ? this.tokenRepository.getByToken(key.getResourceId()) : this.tokenRepository.getByTypeAndResourceId(key.getTokenType().name(), key.getResourceId());
        }
        if (token == null) {
            token = new Token();
        }
        return token;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void remove(TokenKey key) {
        Token token = this.get(key);
        if (token.exists()) {
            this.tokenRepository.delete(token);
        }
    }
}

