/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.upload;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.MetaData;
import com.silverpeas.util.MetadataExtractor;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.io.File;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;

public class UploadedFile {
    private String fileUploadId;
    private File file;
    private String title;
    private String description;
    private String uploader;

    public static UploadedFile from(HttpServletRequest request, String uploadedFileId, UserDetail uploader) {
        return new UploadedFile(uploadedFileId, UploadedFile.getUploadedFileFromUploadId(uploadedFileId), request.getParameter(uploadedFileId + "-title"), request.getParameter(uploadedFileId + "-description"), uploader.getId());
    }

    private UploadedFile(String fileUploadId, File file, String title, String description, String uploader) {
        this.fileUploadId = fileUploadId;
        this.file = file;
        this.title = title;
        this.description = description;
        this.uploader = uploader;
    }

    public String getFileUploadId() {
        return this.fileUploadId;
    }

    public File getFile() {
        return this.file;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    private void markAsProcessed() {
        FileUtils.deleteQuietly((File)this.file);
    }

    public void registerAttachment(WAPrimaryKey resourcePk, String contributionLanguage) {
        this.registerAttachment(resourcePk, contributionLanguage, true);
    }

    public void registerAttachment(WAPrimaryKey resourcePk, String contributionLanguage, boolean indexIt) {
        SimpleDocument document = this.retrieveSimpleDocument(resourcePk, contributionLanguage);
        AttachmentServiceFactory.getAttachmentService().createAttachment(document, this.getFile(), indexIt);
        this.markAsProcessed();
    }

    public SimpleDocument retrieveSimpleDocument(WAPrimaryKey resourcePk, String contributionLanguage) {
        String lang = I18NHelper.checkLanguage(contributionLanguage);
        String title = this.getTitle();
        String description = this.getDescription();
        if (!StringUtil.isDefined(title)) {
            MetadataExtractor extractor = new MetadataExtractor();
            MetaData metadata = extractor.extractMetadata(this.getFile());
            title = StringUtil.isDefined(metadata.getTitle()) ? metadata.getTitle() : "";
            if (!StringUtil.isDefined(description) && StringUtil.isDefined(metadata.getSubject())) {
                description = metadata.getSubject();
            }
        }
        if (!StringUtil.isDefined(description)) {
            description = "";
        }
        SimpleDocumentPK pk = new SimpleDocumentPK(null, resourcePk);
        SimpleDocument document = new SimpleDocument(pk, resourcePk.getId(), 0, false, null, new SimpleAttachment(this.getFile().getName().substring(this.getFileUploadId().length() + 1), lang, title, description, this.getFile().length(), FileUtil.getMimeType(this.getFile().getPath()), this.uploader, DateUtil.getNow(), null));
        document.setLanguage(lang);
        document.setTitle(title);
        document.setDescription(description);
        document.setSize(this.getFile().length());
        return document;
    }

    private static File getUploadedFileFromUploadId(String uploadedFileId) {
        File tempDir = new File(FileRepositoryManager.getTemporaryPath());
        Collection files = FileUtils.listFiles((File)tempDir, (IOFileFilter)new PrefixFileFilter(uploadedFileId), (IOFileFilter)FalseFileFilter.FALSE);
        if (files.isEmpty() || files.size() > 1) {
            return new File(tempDir, "unexistingFile");
        }
        return (File)files.iterator().next();
    }
}

