/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import com.stratelia.webactiv.util.ResourceLocator;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.EnumSet;

public class UnitUtil {
    private static final ResourceLocator utilMessages = new ResourceLocator("org.silverpeas.util.multilang.util", "");
    private static BigDecimal byteMultiplier = new BigDecimal(String.valueOf(1024));

    public static long convertTo(long value, memUnit from, memUnit to) {
        BigDecimal decimalValue = UnitUtil.convertTo(new BigDecimal(String.valueOf(value)), from, to);
        return decimalValue.setScale(0, 4).longValue();
    }

    public static BigDecimal convertTo(BigDecimal value, memUnit from, memUnit to) {
        int toPower;
        int fromPower = from.getPower();
        int offsetPower = fromPower - (toPower = to.getPower());
        if (offsetPower > 0) {
            return value.multiply(byteMultiplier.pow(Math.abs(offsetPower)));
        }
        if (offsetPower < 0) {
            return value.divide(byteMultiplier.pow(Math.abs(offsetPower)));
        }
        return value;
    }

    public static String formatValue(long byteValue, memUnit to) {
        return UnitUtil.formatValue(new BigDecimal(String.valueOf(byteValue)), memUnit.B, to);
    }

    public static String formatValue(BigDecimal byteValue, memUnit to) {
        return UnitUtil.formatValue(byteValue, memUnit.B, to);
    }

    public static String formatValue(long value, memUnit from, memUnit to) {
        return UnitUtil.formatValue(new BigDecimal(String.valueOf(value)), from, to);
    }

    public static String formatValue(BigDecimal value, memUnit from, memUnit to) {
        StringBuilder sb = new StringBuilder(128);
        BigDecimal convertedValue = UnitUtil.convertTo(value, from, to);
        int nbMaximumFractionDigits = 2;
        if (EnumSet.of(memUnit.B, memUnit.KB).contains((Object)to)) {
            nbMaximumFractionDigits = 0;
        }
        convertedValue = convertedValue.setScale(nbMaximumFractionDigits, 4);
        sb.append(new DecimalFormat().format(convertedValue));
        sb.append(" ");
        sb.append(utilMessages.getString(to.getBundleKey(), to.getBundleDefault()));
        return sb.toString();
    }

    public static String formatMemSize(long memSize) {
        return UnitUtil.formatMemSize(memSize, memUnit.B);
    }

    public static String formatMemSize(BigDecimal memSize) {
        return UnitUtil.formatMemSize(memSize, memUnit.B);
    }

    public static String formatMemSize(long memSize, memUnit from) {
        return UnitUtil.formatMemSize(new BigDecimal(String.valueOf(memSize)), from);
    }

    public static String formatMemSize(BigDecimal memSize, memUnit from) {
        BigDecimal byteMemSize = UnitUtil.convertTo(memSize, from, memUnit.B);
        memUnit to = memUnit.values()[memUnit.values().length - 1];
        for (memUnit currentUnit : memUnit.values()) {
            if (currentUnit.getLimit().compareTo(byteMemSize) <= 0) continue;
            to = currentUnit;
            break;
        }
        return UnitUtil.formatValue(byteMemSize, memUnit.B, to);
    }

    public static enum memUnit {
        B(1, "o", "bytes"),
        KB(2, "ko", "Kb"),
        MB(3, "mo", "Mb"),
        GB(4, "go", "Gb"),
        TB(5, "to", "Tb");

        private final String bundleKey;
        private final String bundleDefault;
        private final BigDecimal limit;
        private final int power;

        private memUnit(int power, String bundleKey, String bundleDefault) {
            this.bundleKey = bundleKey;
            this.bundleDefault = bundleDefault;
            this.limit = byteMultiplier.pow(power);
            this.power = power;
        }

        protected String getBundleKey() {
            return this.bundleKey;
        }

        protected String getBundleDefault() {
            return this.bundleDefault;
        }

        public BigDecimal getLimit() {
            return this.limit;
        }

        public int getPower() {
            return this.power;
        }
    }
}

