/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.data;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

@Named(value="temporaryDataCleanerSchedulerInitializer")
public class TemporaryDataCleanerSchedulerInitializer {
    private final ResourceLocator settings = new ResourceLocator("org.silverpeas.util.data.temporaryDataManagementSettings", "");
    public static final String JOB_NAME = "TemporayDataCleanerJob";
    private static final File tempPath = new File(FileRepositoryManager.getTemporaryPath());
    @Inject
    private Scheduler scheduler;

    @PostConstruct
    public void initialize() throws Exception {
        TemporaryDataCleanerJob temporaryDataCleanerJob = new TemporaryDataCleanerJob();
        temporaryDataCleanerJob.clean(this.settings.getLong("temporaryData.cleaner.job.start.file.age.hours", -1L));
        String cron = this.settings.getString("temporaryData.cleaner.job.cron");
        if (StringUtil.isDefined(cron)) {
            this.scheduler.scheduleJob(temporaryDataCleanerJob, JobTrigger.triggerAt(cron));
        }
    }

    private class TemporaryDataCleanerJob
    extends Job {
        public TemporaryDataCleanerJob() {
            super(TemporaryDataCleanerSchedulerInitializer.JOB_NAME);
        }

        @Override
        public void execute(JobExecutionContext context) throws Exception {
            long nbHours = TemporaryDataCleanerSchedulerInitializer.this.settings.getLong("temporaryData.cleaner.job.file.age.hours", 0L);
            if (nbHours >= 1L) {
                this.clean(nbHours);
            }
        }

        public synchronized void clean(long nbHours) {
            if (tempPath.exists() && nbHours >= 0L) {
                long nbMilliseconds = nbHours * 60L * 60L * 1000L;
                long fileAge = System.currentTimeMillis() - nbMilliseconds;
                this.delete(FileUtils.listFiles((File)tempPath, (IOFileFilter)new AgeFileFilter(fileAge), (IOFileFilter)TrueFileFilter.TRUE));
                fileAge = System.currentTimeMillis() - nbMilliseconds;
                this.delete(FileUtils.listFilesAndDirs((File)tempPath, (IOFileFilter)FalseFileFilter.FALSE, (IOFileFilter)new AndFileFilter((IOFileFilter)new AgeFileFilter(fileAge), (IOFileFilter)new AbstractFileFilter(){

                    public boolean accept(File file, String name) {
                        return FileUtils.listFiles((File)file, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE).size() == 0;
                    }
                })));
            }
        }

        private void delete(Collection<File> filesToDelete) {
            if (filesToDelete != null) {
                filesToDelete.remove(tempPath);
                for (File fileToDelete : filesToDelete) {
                    FileUtils.deleteQuietly((File)fileToDelete);
                }
            }
        }
    }
}

