/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import com.silverpeas.annotation.Service;
import com.silverpeas.converter.DocumentFormat;
import com.silverpeas.converter.DocumentFormatConverterFactory;
import com.silverpeas.converter.option.PageRangeFilterOption;
import com.silverpeas.util.FileUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.silverpeas.image.ImageTool;
import org.silverpeas.image.ImageToolDirective;
import org.silverpeas.image.option.DimensionOption;
import org.silverpeas.viewer.AbstractViewerService;
import org.silverpeas.viewer.Preview;
import org.silverpeas.viewer.PreviewService;
import org.silverpeas.viewer.TemporaryPreview;
import org.silverpeas.viewer.exception.PreviewException;
import org.silverpeas.viewer.util.SwfUtil;

@Service
public class DefaultPreviewService
extends AbstractViewerService
implements PreviewService {
    private static final Set<String> imageMimeTypePreviewable = new HashSet<String>();
    @Inject
    private ImageTool imageTool;

    @Override
    public boolean isPreviewable(File file) {
        String fileName = file.getPath();
        if (this.imageTool.isActivated() && file.exists()) {
            String mimeType = FileUtil.getMimeType(fileName);
            return imageMimeTypePreviewable.contains(mimeType) || FileUtil.isPdf(fileName) || FileUtil.isOpenOfficeCompatible(fileName) || "text/plain".equals(mimeType);
        }
        return false;
    }

    @Override
    public Preview getPreview(String originalFileName, File physicalFile) {
        File resultFile;
        if (!this.isPreviewable(physicalFile)) {
            throw new PreviewException("IT IS NOT POSSIBLE GETTING DOCUMENT PREVIEW");
        }
        if (FileUtil.isOpenOfficeCompatible(physicalFile.getName())) {
            File pdfFile = this.toPdf(physicalFile, this.generateTmpFile("pdf"));
            resultFile = this.toImage(pdfFile, this.changeFileExtension(pdfFile, "png"));
            FileUtils.deleteQuietly((File)pdfFile);
        } else {
            resultFile = FileUtil.isPdf(originalFileName) || "text/plain".equals(FileUtil.getMimeType(physicalFile.getPath())) ? this.toImage(physicalFile, this.generateTmpFile("png")) : this.toImage(physicalFile, this.generateTmpFile("jpg"));
        }
        return new TemporaryPreview(originalFileName, resultFile);
    }

    private File toPdf(File source, File destination) {
        DocumentFormatConverterFactory.getFactory().getToPDFConverter().convert(source, destination, DocumentFormat.pdf, new PageRangeFilterOption("1"));
        return destination;
    }

    private File toImage(File source, File destination) {
        boolean deleteSource = false;
        if (SwfUtil.isActivated() && FileUtil.isPdf(source.getPath())) {
            SwfUtil.fromPdfToImage(source, destination);
            source = destination;
            destination = this.changeFileExtension(destination, "jpg");
            deleteSource = !source.equals(destination);
        }
        this.imageTool.convert(source, destination, DimensionOption.widthAndHeight(this.settings.getInteger("preview.width.max", 500), this.settings.getInteger("preview.height.max", 500)), ImageToolDirective.PREVIEW_WORK, ImageToolDirective.GEOMETRY_SHRINK, ImageToolDirective.FIRST_PAGE_ONLY);
        if (deleteSource) {
            FileUtils.deleteQuietly((File)source);
        }
        return destination;
    }

    static {
        for (String imageExtension : new String[]{"bmp", "gif", "jpg", "pcd", "png", "tga", "tif"}) {
            imageMimeTypePreviewable.add(FileUtil.getMimeType("file." + imageExtension));
        }
        imageMimeTypePreviewable.remove("application/octet-stream");
    }
}

