/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import com.silverpeas.annotation.Service;
import com.silverpeas.converter.DocumentFormat;
import com.silverpeas.converter.DocumentFormatConverterFactory;
import com.silverpeas.converter.option.FilterOption;
import com.silverpeas.util.FileUtil;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.silverpeas.viewer.AbstractViewerService;
import org.silverpeas.viewer.DocumentView;
import org.silverpeas.viewer.ViewService;
import org.silverpeas.viewer.exception.PreviewException;
import org.silverpeas.viewer.flexpaper.TemporaryFlexPaperView;
import org.silverpeas.viewer.util.DocumentInfo;
import org.silverpeas.viewer.util.SwfUtil;

@Service
public class DefaultViewService
extends AbstractViewerService
implements ViewService {
    @Override
    public boolean isViewable(File file) {
        String fileName = file.getPath();
        return SwfUtil.isActivated() && file.exists() && (FileUtil.isPdf(fileName) || FileUtil.isOpenOfficeCompatible(fileName));
    }

    @Override
    public DocumentView getDocumentView(String originalFileName, File physicalFile) {
        DocumentView documentView;
        if (!this.isViewable(physicalFile)) {
            throw new PreviewException("IT IS NOT POSSIBLE GETTING DOCUMENT VIEW");
        }
        if (FileUtil.isOpenOfficeCompatible(physicalFile.getName())) {
            File pdfFile = this.toPdf(physicalFile, this.generateTmpFile("pdf"));
            documentView = this.toSwf(originalFileName, pdfFile, this.changeFileExtension(pdfFile, "swf"));
            FileUtils.deleteQuietly((File)pdfFile);
        } else {
            documentView = this.toSwf(originalFileName, physicalFile, this.generateTmpFile("swf"));
        }
        return documentView;
    }

    private File toPdf(File source, File destination) {
        DocumentFormatConverterFactory.getFactory().getToPDFConverter().convert(source, destination, DocumentFormat.pdf, new FilterOption[0]);
        return destination;
    }

    private DocumentView toSwf(String originalFileName, File source, File destination) {
        DocumentInfo info = SwfUtil.getPdfDocumentInfo(source);
        SwfUtil.fromPdfToSwf(source, destination);
        return new TemporaryFlexPaperView(originalFileName, destination, info);
    }
}

