/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer.util;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.viewer.SwfToolManager;
import org.silverpeas.viewer.exception.PreviewException;
import org.silverpeas.viewer.util.CollectingLogOutputStream;
import org.silverpeas.viewer.util.DocumentInfo;

public class SwfUtil {
    public static final String SWF_DOCUMENT_EXTENSION = "swf";
    public static final String PAGE_FILENAME_SEPARATOR = "-";
    private static final String OUTPUT_COMMAND = "-o";
    private static final String TO_SWF_ENDING_COMMAND = "-f -T 9 -t -s storeallcharacters";

    public static boolean isActivated() {
        return SwfToolManager.isActivated();
    }

    public static void fromPdfToImage(File fileIn, File fileOut) {
        File swfFile = SwfUtil.changeFileExtension(fileOut, SWF_DOCUMENT_EXTENSION);
        SwfUtil.fromPdfToSwf(fileIn, swfFile, false, "-p 1-1");
        SwfUtil.fromSwfToImage(swfFile, fileOut);
        FileUtils.deleteQuietly((File)swfFile);
    }

    public static void fromSwfToImage(File fileIn, File fileOut) {
        SwfUtil.exec(SwfUtil.buildSwfToImageCommandLine(fileIn, fileOut));
    }

    public static void fromPdfToSwf(File fileIn, File fileOut) {
        SwfUtil.fromPdfToSwf(fileIn, fileOut, false);
    }

    public static void fromPdfToSwf(File fileIn, File fileOut, boolean oneFilePerPage) {
        SwfUtil.fromPdfToSwf(fileIn, fileOut, oneFilePerPage, null);
    }

    public static void fromPdfToSwf(File fileIn, File fileOut, boolean oneFilePerPage, String endingCommand) {
        File outputFile = fileOut;
        if (oneFilePerPage) {
            StringBuilder onePageFile = new StringBuilder(512);
            onePageFile.append(FilenameUtils.getFullPath((String)fileOut.getPath()));
            onePageFile.append(FilenameUtils.getBaseName((String)fileOut.getPath()));
            onePageFile.append(PAGE_FILENAME_SEPARATOR);
            onePageFile.append("%.");
            onePageFile.append(FilenameUtils.getExtension((String)fileOut.getPath()));
            outputFile = new File(onePageFile.toString());
        }
        SwfUtil.exec(SwfUtil.buildPdfToSwfCommandLine(endingCommand, fileIn, outputFile));
    }

    public static DocumentInfo getPdfDocumentInfo(File pdfFile) {
        return new DocumentInfo().addFromSwfToolsOutput(SwfUtil.exec(SwfUtil.buildPdfDocumentInfoCommandLine(pdfFile)));
    }

    private static File changeFileExtension(File file, String fileExtension) {
        return new File(FilenameUtils.getFullPath((String)file.getPath()) + FilenameUtils.getBaseName((String)file.getPath()) + '.' + fileExtension);
    }

    private static List<String> exec(CommandLine commandLine) {
        SilverTrace.info("util", "SwfUtil.exec", "Command " + commandLine);
        final LinkedList<String> result = new LinkedList<String>();
        final LinkedList<String> errors = new LinkedList<String>();
        CollectingLogOutputStream logErrors = new CollectingLogOutputStream(errors);
        try {
            final Process process = Runtime.getRuntime().exec(commandLine.toStrings());
            Thread errEater = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        errors.addAll(IOUtils.readLines((InputStream)process.getErrorStream()));
                    }
                    catch (IOException e) {
                        throw new PreviewException(e);
                    }
                }
            });
            errEater.start();
            Thread outEater = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        result.addAll(IOUtils.readLines((InputStream)process.getInputStream()));
                    }
                    catch (IOException e) {
                        throw new PreviewException(e);
                    }
                }
            });
            outEater.start();
            process.waitFor();
            int exitStatus = process.exitValue();
            if (exitStatus != 0) {
                throw new RuntimeException("Exit error status : " + exitStatus + " " + logErrors.getMessage());
            }
        }
        catch (IOException e) {
            SilverTrace.error("util", "SwfUtil.exec", "Command execution error", e);
            throw new PreviewException(e);
        }
        catch (InterruptedException e) {
            SilverTrace.error("util", "SwfUtil.exec", "Command execution error", e);
            throw new PreviewException(e);
        }
        catch (RuntimeException e) {
            SilverTrace.error("util", "SwfUtil.exec", "Command execution error", e);
            throw new PreviewException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)((Object)logErrors));
        }
        return result;
    }

    static CommandLine buildPdfToSwfCommandLine(String endingCommand, File inputFile, File outputFile) {
        HashMap<String, File> files = new HashMap<String, File>(2);
        files.put("inputFile", inputFile);
        files.put("outputFile", outputFile);
        CommandLine commandLine = new CommandLine("pdf2swf");
        commandLine.addArgument("${inputFile}", false);
        commandLine.addArgument(OUTPUT_COMMAND);
        commandLine.addArgument("${outputFile}", false);
        commandLine.addArguments(TO_SWF_ENDING_COMMAND, false);
        if (StringUtil.isDefined(endingCommand)) {
            commandLine.addArguments(endingCommand, false);
        }
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }

    static CommandLine buildPdfDocumentInfoCommandLine(File file) {
        HashMap<String, File> files = new HashMap<String, File>(1);
        files.put("file", file);
        CommandLine commandLine = new CommandLine("pdf2swf");
        commandLine.addArgument("-qq");
        commandLine.addArgument("${file}", false);
        commandLine.addArgument("--info");
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }

    static CommandLine buildSwfToImageCommandLine(File inputFile, File outputFile) {
        HashMap<String, File> files = new HashMap<String, File>(2);
        files.put("inputFile", inputFile);
        files.put("outputFile", outputFile);
        CommandLine commandLine = new CommandLine("swfrender");
        commandLine.addArgument("${inputFile}", false);
        commandLine.addArgument(OUTPUT_COMMAND);
        commandLine.addArgument("${outputFile}", false);
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }
}

