/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.wysiwyg.control;

import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.model.UnlockContext;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.util.Charsets;
import org.silverpeas.wysiwyg.WysiwygException;

public class WysiwygController {
    public static final String WYSIWYG_CONTEXT = DocumentType.wysiwyg.name();
    public static final String WYSIWYG_IMAGES = "Images";
    public static final String WYSIWYG_WEBSITES = "webSites";

    private static String loadFromFileSystemDirectly(ForeignPK foreignPK, String language) throws IOException {
        File wysiwygFile = new File(WysiwygController.getLegacyWysiwygPath(WYSIWYG_CONTEXT, foreignPK.getInstanceId()), WysiwygController.getWysiwygFileName(foreignPK.getId(), language));
        if (!wysiwygFile.exists() || !wysiwygFile.isFile()) {
            wysiwygFile = new File(WysiwygController.getLegacyWysiwygPath(WYSIWYG_CONTEXT, foreignPK.getInstanceId()), WysiwygController.getOldWysiwygFileName(foreignPK.getId()));
        }
        String content = "";
        if (wysiwygFile.exists() && wysiwygFile.isFile()) {
            content = FileUtils.readFileToString((File)wysiwygFile);
        }
        return content;
    }

    private static String getLegacyWysiwygPath(String context, String componentId) {
        String path;
        if (StringUtil.isDefined(context)) {
            String strAt = "Attachment,";
            strAt = strAt.concat(context);
            String[] ctx = StringUtil.split((String)strAt, (char)',');
            path = FileRepositoryManager.getAbsolutePath(componentId, ctx);
        } else {
            String[] ctx = new String[]{"Attachment"};
            path = FileRepositoryManager.getAbsolutePath(componentId, ctx);
        }
        return path;
    }

    private static void checkNoJavascriptInHTML(String textHtml) {
        if (textHtml.matches("(?i)(?u)(?s).*<.+[ ]+on[a-z]+[ ]*=.*>.*") || textHtml.matches("(?i)(?u)(?s).*<[ ]*script.*>.*")) {
            throw new AssertionError((Object)"The WYSIWYG contains javascript code!");
        }
    }

    public static String[][] getImages(String id, String componentId) {
        List<SimpleDocument> attachments = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(new ForeignPK(id, componentId), DocumentType.image, null);
        int nbImages = attachments.size();
        String[][] imagesList = new String[nbImages][2];
        for (int i = 0; i < nbImages; ++i) {
            SimpleDocument attD = attachments.get(i);
            imagesList[i][0] = attD.getAttachmentURL();
            imagesList[i][1] = attD.getFilename();
            SilverTrace.info("wysiwyg", "WysiwygController.getImages()", "root.MSG_GEN_PARAM_VALUE", imagesList[i][0] + "] [" + imagesList[i][1]);
        }
        return imagesList;
    }

    public static String getWebsiteRepository() {
        ResourceLocator websiteSettings = new ResourceLocator("org.silverpeas.webSites.settings.webSiteSettings", "");
        return websiteSettings.getString("uploadsPath");
    }

    public static String[][] getWebsiteImages(String path, String componentId) throws WysiwygException {
        WysiwygController.checkPath(path);
        try {
            Collection<File> listImages = FileFolderManager.getAllImages(path);
            Iterator<File> i = listImages.iterator();
            int nbImages = listImages.size();
            String[][] images = new String[nbImages][2];
            SilverTrace.info("wysiwyg", "WysiwygController.getWebsiteImages()", "root.MSG_GEN_PARAM_VALUE", "nbImages=" + nbImages + " path=" + path);
            for (int j = 0; j < nbImages; ++j) {
                File image = i.next();
                SilverTrace.info("wysiwyg", "WysiwygController.getWebsiteImages()", "root.MSG_GEN_PARAM_VALUE", "image=" + image.getAbsolutePath());
                images[j][0] = WysiwygController.finNode2(image.getAbsolutePath(), componentId).replace('\\', '/');
                images[j][1] = image.getName();
            }
            return images;
        }
        catch (UtilException e) {
            throw new WysiwygException("WebSiteSessionController.getWebsiteImages()", 4, "wysisyg.EX_GET_ALL_IMAGES_FAIL", e);
        }
    }

    public static String[][] getWebsitePages(String path, String componentId) throws WysiwygException {
        WysiwygController.checkPath(path);
        try {
            Collection<File> listPages = FileFolderManager.getAllWebPages(WysiwygController.getNodePath(path, componentId));
            Iterator<File> i = listPages.iterator();
            int nbPages = listPages.size();
            String[][] pages = new String[nbPages][2];
            SilverTrace.info("wysiwyg", "WysiwygController.getWebsitePages()", "root.MSG_GEN_PARAM_VALUE", "nbPages=" + nbPages + " path=" + path);
            for (int j = 0; j < nbPages; ++j) {
                File page = i.next();
                SilverTrace.info("wysiwyg", "WysiwygController.getWebsitePages()", "root.MSG_GEN_PARAM_VALUE", "page=" + page.getAbsolutePath());
                pages[j][0] = WysiwygController.finNode2(page.getAbsolutePath(), componentId).replace('\\', '/');
                pages[j][1] = page.getName();
            }
            return pages;
        }
        catch (UtilException e) {
            throw new WysiwygException("WebSiteSessionController.getWebsitePages()", 4, "wysisyg.EX_GET_ALL_PAGES_FAIL", e);
        }
    }

    static String finNode(String path, String componentId) {
        int longueur = componentId.length();
        int index = path.lastIndexOf(componentId);
        String chemin = path.substring(index + longueur);
        chemin = WysiwygController.suppressLeadingSlashesOrAntislashes(chemin);
        chemin = WysiwygController.supprDoubleAntiSlash(chemin);
        return chemin;
    }

    static String finNode2(String path, String componentId) {
        SilverTrace.info("wysiwyg", "WysiwygController.finNode2()", "root.MSG_GEN_PARAM_VALUE", "path=" + path);
        String finNode = WysiwygController.doubleAntiSlash(path);
        finNode = WysiwygController.finNode(finNode, componentId);
        int index = finNode.indexOf(92);
        if (index < 0) {
            index = finNode.indexOf(47);
        }
        return finNode.substring(index + 1);
    }

    static String getNodePath(String currentPath, String componentId) {
        String chemin = currentPath;
        if (chemin != null) {
            chemin = WysiwygController.suppressFinalSlash(chemin);
            int indexComponent = chemin.lastIndexOf(componentId) + componentId.length();
            String finChemin = WysiwygController.suppressLeadingSlashesOrAntislashes(chemin.substring(indexComponent));
            int index = -1;
            if (finChemin.contains("/")) {
                index = finChemin.indexOf(47);
            } else if (finChemin.contains("\\")) {
                index = finChemin.indexOf(92);
            }
            SilverTrace.info("wysiwyg", "WysiwygController.getNodePath()", "root.MSG_GEN_PARAM_VALUE", "finChemin = " + finChemin);
            if (index == -1) {
                return chemin;
            }
            return chemin.substring(0, chemin.indexOf(finChemin) + index);
        }
        return "";
    }

    static String suppressFinalSlash(String path) {
        if (path.endsWith("/")) {
            return WysiwygController.suppressFinalSlash(path.substring(0, path.length() - 1));
        }
        return path;
    }

    static String ignoreLeadingSlash(String chemin) {
        if (chemin.startsWith("/")) {
            return WysiwygController.ignoreLeadingSlash(chemin.substring(1));
        }
        return chemin;
    }

    static String supprDoubleAntiSlash(String chemin) {
        StringBuilder res = new StringBuilder("");
        for (int i = 0; i < chemin.length(); ++i) {
            char car = chemin.charAt(i);
            if (car == '\\' && chemin.charAt(i + 1) == '\\') {
                res.append(car);
                ++i;
                continue;
            }
            res.append(car);
        }
        return res.toString();
    }

    static String suppressLeadingSlashesOrAntislashes(String chemin) {
        if (chemin.startsWith("\\") || chemin.startsWith("/")) {
            return WysiwygController.suppressLeadingSlashesOrAntislashes(chemin.substring(1));
        }
        return chemin;
    }

    static String doubleAntiSlash(String chemin) {
        int i = 0;
        String res = chemin;
        boolean ok = true;
        while (ok) {
            int j = i + 1;
            if (i < res.length() && j < res.length()) {
                char car1 = res.charAt(i);
                char car2 = res.charAt(j);
                if (!(car1 == '\\' && car2 == '\\' || car1 != '\\' && car2 != '\\')) {
                    String avant = res.substring(0, j);
                    String apres = res.substring(j);
                    if (!apres.startsWith("\\\\") && !avant.endsWith("\\\\")) {
                        res = avant + '\\' + apres;
                        ++i;
                    }
                }
            } else {
                char car;
                if (i < res.length() && (car = res.charAt(i)) == '\\') {
                    res = res + '\\';
                }
                ok = false;
            }
            i += 2;
        }
        return res;
    }

    public static String getOldWysiwygFileName(String objectId) {
        return objectId + WYSIWYG_CONTEXT + ".txt";
    }

    public static String getWysiwygFileName(String objectId, String currentLanguage) {
        String language = I18NHelper.checkLanguage(currentLanguage);
        return objectId + WYSIWYG_CONTEXT + "_" + language + ".txt";
    }

    public static String getImagesFileName(String objectId) {
        return objectId + WYSIWYG_IMAGES;
    }

    public static void deleteFileAndAttachment(String componentId, String id) {
        ForeignPK foreignKey = new ForeignPK(id, componentId);
        List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey(foreignKey, null);
        for (SimpleDocument doc : documents) {
            AttachmentServiceFactory.getAttachmentService().deleteAttachment(doc);
        }
    }

    public static void deleteFile(String componentId, String objectId, String language) {
        ForeignPK foreignKey = new ForeignPK(objectId, componentId);
        List<SimpleDocument> files = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey(foreignKey, null);
        for (SimpleDocument file : files) {
            if (file == null || !file.getFilename().equalsIgnoreCase(WysiwygController.getWysiwygFileName(objectId, language))) continue;
            AttachmentServiceFactory.getAttachmentService().removeContent(file, language, false);
        }
    }

    public static void createFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String context, String userId, String contentLanguage) {
        WysiwygController.createFileAndAttachment(textHtml, foreignKey, DocumentType.valueOf(context), userId, contentLanguage, true, true);
    }

    private static void createFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, DocumentType context, String userId, String contentLanguage, boolean indexIt, boolean invokeCallback) {
        String fileName = WysiwygController.getWysiwygFileName(foreignKey.getId(), contentLanguage);
        if (!StringUtil.isDefined(textHtml)) {
            return;
        }
        String language = I18NHelper.checkLanguage(contentLanguage);
        SimpleDocumentPK docPk = new SimpleDocumentPK(null, foreignKey.getInstanceId());
        SimpleDocument document = new SimpleDocument(docPk, foreignKey.getId(), 0, false, userId, new SimpleAttachment(fileName, language, fileName, null, textHtml.length(), "text/html", userId, new Date(), null));
        document.setDocumentType(context);
        AttachmentServiceFactory.getAttachmentService().createAttachment(document, new ByteArrayInputStream(textHtml.getBytes(Charsets.UTF_8)), indexIt, invokeCallback);
        if (invokeCallback) {
            WysiwygController.invokeCallback(userId, foreignKey);
        }
        AttachmentServiceFactory.getAttachmentService().unlock(new UnlockContext(document.getId(), userId, document.getLanguage()));
    }

    private static void invokeCallback(String userId, WAPrimaryKey objectPK) {
        int iUserId = -1;
        if (userId != null) {
            iUserId = Integer.parseInt(userId);
        }
        CallBackManager callBackManager = CallBackManager.get();
        callBackManager.invoke(8, iUserId, objectPK.getInstanceId(), objectPK.getId());
    }

    public static void createFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String userId, String contentLanguage) {
        WysiwygController.createFileAndAttachment(textHtml, foreignKey, WYSIWYG_CONTEXT, userId, contentLanguage);
    }

    public static void createUnindexedFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String userId, String contentLanguage) {
        WysiwygController.createFileAndAttachment(textHtml, foreignKey, DocumentType.wysiwyg, userId, contentLanguage, false, false);
    }

    public static void addToIndex(FullIndexEntry indexEntry, ForeignPK pk, String language) {
        List<SimpleDocument> docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(pk, DocumentType.wysiwyg, language);
        if (!docs.isEmpty()) {
            for (SimpleDocument wysiwyg : docs) {
                String wysiwygPath = wysiwyg.getAttachmentPath();
                indexEntry.addFileContent(wysiwygPath, null, "text/html", language);
                String wysiwygContent = WysiwygController.loadContent(wysiwyg, language);
                List<String> embeddedAttachmentIds = WysiwygController.getEmbeddedAttachmentIds(wysiwygContent);
                WysiwygController.indexEmbeddedLinkedFiles(indexEntry, embeddedAttachmentIds);
            }
        }
    }

    private static void saveFile(String textHtml, WAPrimaryKey foreignKey, DocumentType context, String userId, String language, boolean indexIt) {
        String fileName = WysiwygController.getWysiwygFileName(foreignKey.getId(), language);
        SilverTrace.info("wysiwyg", "WysiwygController.updateFileAndAttachment()", "root.MSG_GEN_PARAM_VALUE", "fileName=" + fileName + " context=" + (Object)((Object)context) + "objectId=" + foreignKey.getId());
        SimpleDocument document = WysiwygController.searchAttachmentDetail(foreignKey, context, language);
        if (document != null) {
            document.setLanguage(I18NHelper.checkLanguage(language));
            document.setSize(textHtml.getBytes(Charsets.UTF_8).length);
            document.setDocumentType(context);
            document.setUpdatedBy(userId);
            AttachmentServiceFactory.getAttachmentService().updateAttachment(document, new ByteArrayInputStream(textHtml.getBytes(Charsets.UTF_8)), indexIt, false);
            WysiwygController.invokeCallback(userId, foreignKey);
        } else {
            WysiwygController.createFileAndAttachment(textHtml, foreignKey, context, userId, language, indexIt, true);
        }
    }

    public static void updateFileAndAttachment(String textHtml, String componentId, String objectId, String userId, String language) {
        WysiwygController.updateFileAndAttachment(textHtml, componentId, objectId, userId, language, true);
    }

    public static void updateFileAndAttachment(String textHtml, String componentId, String objectId, String userId, String language, boolean indexIt) {
        WysiwygController.saveFile(textHtml, new ForeignPK(objectId, componentId), DocumentType.wysiwyg, userId, language, indexIt);
    }

    public static void save(String textHtml, String componentId, String objectId, String userId, String language, boolean indexIt) {
        WysiwygController.saveFile(textHtml, new ForeignPK(objectId, componentId), DocumentType.wysiwyg, userId, language, indexIt);
    }

    public static void deleteWysiwygAttachments(String componentId, String objectId) {
        try {
            ForeignPK foreignKey = new ForeignPK(objectId, componentId);
            List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listAllDocumentsByForeignKey(foreignKey, null);
            for (SimpleDocument document : documents) {
                AttachmentServiceFactory.getAttachmentService().deleteAttachment(document);
            }
        }
        catch (AttachmentException exc) {
            SilverTrace.error("wysiwyg", "WysiwygController.deleteWysiwygAttachments()", "wysiwyg.DELETING_WYSIWYG_ATTACHMENTS_FAILED", exc);
            throw exc;
        }
    }

    public static void deleteWysiwygAttachmentsOnly(String spaceId, String componentId, String objectId) throws WysiwygException {
        try {
            ForeignPK foreignKey = new ForeignPK(objectId, componentId);
            List<SimpleDocument> docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, null);
            for (SimpleDocument wysiwygAttachment : docs) {
                AttachmentServiceFactory.getAttachmentService().deleteAttachment(wysiwygAttachment);
            }
            docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
            for (SimpleDocument document : docs) {
                AttachmentServiceFactory.getAttachmentService().deleteAttachment(document);
            }
        }
        catch (Exception exc) {
            throw new WysiwygException("WysiwygController.deleteWysiwygAttachments()", 4, "wysiwyg.DELETING_WYSIWYG_ATTACHMENTS_FAILED", exc);
        }
    }

    public static String loadFileAndAttachment(ForeignPK foreignPk, DocumentType context, String lang) {
        SimpleDocument document = WysiwygController.searchAttachmentDetail(foreignPk, context, lang);
        if (document != null) {
            return WysiwygController.loadContent(document, lang);
        }
        return "";
    }

    public static String loadContent(SimpleDocument doc, String lang) {
        return WysiwygController.loadContent(doc.getPk(), lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadContent(SimpleDocumentPK pk, String lang) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            AttachmentServiceFactory.getAttachmentService().getBinaryContent(buffer, pk, lang);
            String string = new String(buffer.toByteArray(), Charsets.UTF_8);
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)buffer);
        }
    }

    public static String load(String componentId, String objectId, String language) {
        String currentLanguage = I18NHelper.checkLanguage(language);
        String content = WysiwygController.loadFileAndAttachment(new ForeignPK(objectId, componentId), DocumentType.wysiwyg, currentLanguage);
        if (!StringUtil.isDefined(content)) {
            try {
                content = WysiwygController.loadFromFileSystemDirectly(new ForeignPK(objectId, componentId), currentLanguage);
            }
            catch (IOException ex) {
                SilverTrace.error("wysiwyg", "WysiwygController.load()", "Error loading content", ex);
            }
        }
        if (content == null) {
            content = "";
        }
        return content;
    }

    public static List<String> getEmbeddedAttachmentIds(String content) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        if (content != null) {
            String fileId;
            Pattern attachmentLinkPattern = Pattern.compile("href=\\\"\\/silverpeas\\/File\\/(.*?)\\\"");
            Matcher linkMatcher = attachmentLinkPattern.matcher(content);
            while (linkMatcher.find()) {
                fileId = linkMatcher.group(1);
                attachmentIds.add(fileId);
            }
            attachmentLinkPattern = Pattern.compile("href=\\\"\\/silverpeas\\/FileServer\\/(.*?)attachmentId=(\\d*)");
            linkMatcher = attachmentLinkPattern.matcher(content);
            while (linkMatcher.find()) {
                fileId = linkMatcher.group(2);
                attachmentIds.add(fileId);
            }
        }
        return attachmentIds;
    }

    public static String loadFileWebsite(String path, String fileName) throws WysiwygException {
        WysiwygController.checkPath(path);
        try {
            return FileFolderManager.getCode(path, fileName);
        }
        catch (UtilException e) {
            throw new WysiwygException("WysiwygController.loadFileWebsite()", 3, "wysiwyg.NO_WYSIWYG_DOCUMENT_ASSOCIATED");
        }
    }

    public static boolean haveGotWysiwygToDisplay(String componentId, String objectId, String language) {
        String wysiwygContent = WysiwygController.load(componentId, objectId, language);
        if (!StringUtil.isDefined(wysiwygContent) && I18NHelper.isI18N) {
            Iterator<String> iter = I18NHelper.getLanguages();
            while (iter.hasNext() && !StringUtil.isDefined(wysiwygContent)) {
                wysiwygContent = WysiwygController.load(componentId, objectId, iter.next());
            }
        }
        return StringUtil.isDefined(wysiwygContent);
    }

    public static boolean haveGotWysiwyg(String componentId, String objectId, String language) {
        String wysiwygContent = WysiwygController.load(componentId, objectId, language);
        return StringUtil.isDefined(wysiwygContent);
    }

    private static SimpleDocument searchAttachmentDetail(WAPrimaryKey foreignKey, DocumentType context, String lang) {
        String language = I18NHelper.checkLanguage(lang);
        List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, context, language);
        if (!documents.isEmpty()) {
            return documents.get(0);
        }
        return null;
    }

    public static void updateWebsite(String cheminFichier, String nomFichier, String contenuFichier) throws WysiwygException {
        WysiwygController.checkPath(cheminFichier);
        SilverTrace.info("wysiwyg", "WysiwygController.updateWebsite()", "root.MSG_GEN_PARAM_VALUE", "cheminFichier=" + cheminFichier + " nomFichier=" + nomFichier);
        WysiwygController.createFile(cheminFichier, nomFichier, contenuFichier);
    }

    protected static File createFile(String cheminFichier, String nomFichier, String contenuFichier) throws WysiwygException {
        WysiwygController.checkPath(cheminFichier);
        SilverTrace.info("wysiwyg", "WysiwygController.createFile()", "root.MSG_GEN_ENTER_METHOD", "cheminFichier=" + cheminFichier + " nomFichier=" + nomFichier);
        FileFolderManager.createFile(cheminFichier, nomFichier, contenuFichier);
        File directory = new File(cheminFichier);
        return FileUtils.getFile((File)directory, (String[])new String[]{nomFichier});
    }

    public static Map<String, String> copy(String oldComponentId, String oldObjectId, String componentId, String objectId, String userId) {
        SilverTrace.info("wysiwyg", "WysiwygController.copy()", "root.MSG_GEN_ENTER_METHOD");
        ForeignPK foreignKey = new ForeignPK(oldObjectId, oldComponentId);
        List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, null);
        ForeignPK targetPk = new ForeignPK(objectId, componentId);
        HashMap<String, String> fileIds = new HashMap<String, String>();
        for (SimpleDocument doc : documents) {
            doc.getFile().setCreatedBy(userId);
            SimpleDocumentPK pk = AttachmentServiceFactory.getAttachmentService().copyDocument(doc, targetPk);
            SimpleDocument copy = AttachmentServiceFactory.getAttachmentService().searchDocumentById(pk, doc.getLanguage());
            String content = WysiwygController.replaceInternalImagesPath(WysiwygController.loadContent(copy, doc.getLanguage()), oldComponentId, oldObjectId, componentId, objectId);
            List<SimpleDocument> images = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
            for (SimpleDocument image : images) {
                SimpleDocumentPK imageCopyPk = AttachmentServiceFactory.getAttachmentService().copyDocument(image, targetPk);
                fileIds.put(image.getId(), imageCopyPk.getId());
                content = WysiwygController.replaceInternalImageId(content, image.getPk(), imageCopyPk);
            }
            AttachmentServiceFactory.getAttachmentService().updateAttachment(copy, new ByteArrayInputStream(content.getBytes(Charsets.UTF_8)), true, true);
        }
        return fileIds;
    }

    public static void move(String fromComponentId, String fromObjectId, String componentId, String objectId) {
        ForeignPK fromForeignPK = new ForeignPK(fromObjectId, fromComponentId);
        List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listAllDocumentsByForeignKey(fromForeignPK, null);
        ForeignPK toForeignPK = new ForeignPK(objectId, componentId);
        for (SimpleDocument document : documents) {
            AttachmentServiceFactory.getAttachmentService().moveDocument(document, toForeignPK);
        }
        WysiwygController.wysiwygPlaceHaveChanged(fromComponentId, fromObjectId, componentId, objectId);
    }

    static String replaceInternalImageId(String wysiwygContent, SimpleDocumentPK oldPK, SimpleDocumentPK newPK) {
        String from = "/componentId/" + oldPK.getInstanceId() + "/attachmentId/" + oldPK.getId() + "/";
        String fromOldId = "/componentId/" + oldPK.getInstanceId() + "/attachmentId/" + oldPK.getOldSilverpeasId() + "/";
        String to = "/componentId/" + newPK.getInstanceId() + "/attachmentId/" + newPK.getId() + "/";
        return wysiwygContent.replaceAll(from, to).replaceAll(fromOldId, to);
    }

    private static String replaceInternalImagesPath(String wysiwygContent, String oldComponentId, String oldObjectId, String componentId, String objectId) {
        String newStr = "";
        if (wysiwygContent.contains("FileServer")) {
            String co = "ComponentId=" + oldComponentId;
            String di = "Directory=Attachment/" + WysiwygController.getImagesFileName(oldObjectId);
            String diBis = "Directory=Attachment%2F" + WysiwygController.getImagesFileName(oldObjectId);
            String diTer = "Directory=Attachment\\" + WysiwygController.getImagesFileName(oldObjectId);
            String diQua = "Directory=Attachment%5C" + WysiwygController.getImagesFileName(oldObjectId);
            int begin = 0;
            int end = wysiwygContent.indexOf(co, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "ComponentId=" + componentId;
                begin = end + co.length();
                end = wysiwygContent.indexOf(co, begin);
            }
            wysiwygContent = newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
            newStr = "";
            begin = 0;
            end = wysiwygContent.indexOf(di, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "Directory=Attachment/" + WysiwygController.getImagesFileName(objectId);
                begin = end + di.length();
                end = wysiwygContent.indexOf(di, begin);
            }
            wysiwygContent = newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
            newStr = "";
            begin = 0;
            end = wysiwygContent.indexOf(diBis, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "Directory=Attachment%2F" + WysiwygController.getImagesFileName(objectId);
                begin = end + diBis.length();
                end = wysiwygContent.indexOf(diBis, begin);
            }
            wysiwygContent = newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
            newStr = "";
            begin = 0;
            end = wysiwygContent.indexOf(diTer, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "Directory=Attachment\\" + WysiwygController.getImagesFileName(objectId);
                begin = end + diTer.length();
                end = wysiwygContent.indexOf(diTer, begin);
            }
            wysiwygContent = newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
            newStr = "";
            begin = 0;
            end = wysiwygContent.indexOf(diQua, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "Directory=Attachment%5C" + WysiwygController.getImagesFileName(objectId);
                begin = end + diQua.length();
                end = wysiwygContent.indexOf(diQua, begin);
            }
            newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
        } else {
            newStr = wysiwygContent;
        }
        return newStr;
    }

    public static void wysiwygPlaceHaveChanged(String oldComponentId, String oldObjectId, String newComponentId, String newObjectId) {
        ForeignPK foreignKey = new ForeignPK(oldObjectId, newComponentId);
        List<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, null);
        if (documents != null && !documents.isEmpty()) {
            for (SimpleDocument document : documents) {
                for (String language : I18NHelper.getAllSupportedLanguages()) {
                    String wysiwyg = WysiwygController.load(newComponentId, newObjectId, language);
                    if (!StringUtil.isDefined(wysiwyg)) continue;
                    List<SimpleDocument> images = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
                    for (SimpleDocument image : images) {
                        wysiwyg = WysiwygController.replaceInternalImagesPath(wysiwyg, oldComponentId, oldObjectId, newComponentId, newObjectId);
                        image.getPk().setComponentName(oldComponentId);
                        SimpleDocumentPK imageCopyPk = new SimpleDocumentPK(image.getId(), newComponentId);
                        imageCopyPk.setOldSilverpeasId(image.getOldSilverpeasId());
                        wysiwyg = WysiwygController.replaceInternalImageId(wysiwyg, image.getPk(), imageCopyPk);
                    }
                    AttachmentServiceFactory.getAttachmentService().updateAttachment(document, new ByteArrayInputStream(wysiwyg.getBytes(Charsets.UTF_8)), true, true);
                }
            }
        }
    }

    public static String getWysiwygPath(String componentId, String objectId, String language) {
        List<SimpleDocument> attachements = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(new ForeignPK(objectId, componentId), DocumentType.wysiwyg, language);
        if (!attachements.isEmpty()) {
            return attachements.get(0).getAttachmentPath();
        }
        return "";
    }

    public static String getWysiwygPath(String componentId, String objectId) {
        return WysiwygController.getWysiwygPath(componentId, objectId, null);
    }

    public static List<ComponentInstLight> getGalleries() {
        String[] compoIds;
        ArrayList<ComponentInstLight> galleries = new ArrayList<ComponentInstLight>();
        OrganisationController orgaController = OrganisationControllerFactory.getOrganisationController();
        for (String compoId : compoIds = orgaController.getCompoId("gallery")) {
            if (!StringUtil.getBooleanValue(orgaController.getComponentParameterValue("gallery" + compoId, "viewInWysiwyg"))) continue;
            ComponentInstLight gallery = orgaController.getComponentInstLight("gallery" + compoId);
            galleries.add(gallery);
        }
        return galleries;
    }

    public static List<ComponentInstLight> getStorageFile(String userId) {
        String[] compoIds;
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
        OrganisationController controller = OrganisationControllerFactory.getOrganisationController();
        for (String compoId : compoIds = controller.getCompoId("kmelia")) {
            if (!StringUtil.getBooleanValue(controller.getComponentParameterValue(compoId, "publicFiles"))) continue;
            ComponentInstLight component = controller.getComponentInstLight(compoId);
            components.add(component);
        }
        return components;
    }

    public static void indexEmbeddedLinkedFiles(FullIndexEntry indexEntry, List<String> embeddedAttachmentIds) {
        for (String attachmentId : embeddedAttachmentIds) {
            try {
                SimpleDocument attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId), null);
                if (attachment == null) continue;
                indexEntry.addLinkedFileContent(attachment.getAttachmentPath(), "UTF-8", attachment.getContentType(), attachment.getLanguage());
                indexEntry.addLinkedFileId(attachmentId);
            }
            catch (Exception e) {
                SilverTrace.warn("wisiwyg", "WysiwygController", "root.MSG_GEN_PARAM_VALUE", "Erreur dans l'indexation d'un fichier joint li\u00e9 au contenu wysiwyg - attachmentId:" + attachmentId);
            }
        }
    }

    public static String createPath(String componentId, String context) {
        String path = WysiwygController.getLegacyWysiwygPath(context, componentId);
        try {
            File folder = new File(path);
            if (!folder.exists()) {
                FileFolderManager.createFolder(path);
            }
            return path;
        }
        catch (UtilException e) {
            throw new AttachmentException("Wysiwyg.createPath(spaceId, componentId, context)", 4, "root.EX_CANT_CREATE_FILE", e);
        }
    }

    private static void checkPath(String path) throws WysiwygException {
        if (path.contains("..")) {
            throw new WysiwygException(WysiwygController.class.getSimpleName() + ".checkPath", 4, "peasCore.RESOURCE_ACCESS_FORBIDDEN");
        }
    }
}

