/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.accesscontrol;

import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.util.ComponentHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.UserDetail;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

@Named
public class ComponentAccessController
implements AccessController<String> {
    @Inject
    private OrganisationController controller;

    protected void setOrganizationController(OrganisationController controller) {
        this.controller = controller;
    }

    public boolean isRightOnTopicsEnabled(String userId, String componentId) {
        return this.isThemeTracker(componentId) && StringUtil.getBooleanValue((String)this.getOrganisationController().getComponentParameterValue(componentId, "rightsOnTopics"));
    }

    private boolean isThemeTracker(String componentId) {
        return ComponentHelper.getInstance().isThemeTracker(componentId);
    }

    public boolean isUserAuthorized(String userId, String componentId) {
        if (componentId == null || this.getOrganisationController().isToolAvailable(componentId)) {
            return true;
        }
        if ("ADMIN".equals(componentId)) {
            return UserDetail.getById((String)userId).isAccessAdmin();
        }
        if (StringUtil.getBooleanValue((String)this.getOrganisationController().getComponentParameterValue(componentId, "publicFiles"))) {
            return true;
        }
        return this.getOrganisationController().isComponentAvailable(componentId, userId);
    }

    private OrganisationController getOrganisationController() {
        if (this.controller == null) {
            this.controller = OrganisationControllerFactory.getOrganisationController();
        }
        return this.controller;
    }
}

