/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.accesscontrol;

import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.accesscontrol.NodeAccessController;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.importExport.versioning.Document;

@Named(value="documentAccessController")
public class DocumentAccessController
implements AccessController<Document> {
    @Inject
    private NodeAccessController accessController;

    public DocumentAccessController() {
    }

    DocumentAccessController(NodeAccessController accessController) {
        this.accessController = accessController;
    }

    public boolean isUserAuthorized(String userId, Document object) {
        Collection nodes;
        try {
            nodes = this.getPublicationBm().getAllFatherPK(new PublicationPK(object.getForeignKey().getId(), object.getInstanceId()));
        }
        catch (Exception ex) {
            SilverTrace.error((String)"accesscontrol", (String)(this.getClass().getSimpleName() + ".isUserAuthorized()"), (String)"root.NO_EX_MESSAGE", (Throwable)ex);
            return false;
        }
        for (NodePK nodePk : nodes) {
            if (!this.getNodeAccessController().isUserAuthorized(userId, nodePk)) continue;
            return true;
        }
        return false;
    }

    protected PublicationBm getPublicationBm() throws Exception {
        return (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
    }

    protected NodeAccessController getNodeAccessController() {
        if (this.accessController == null) {
            this.accessController = new NodeAccessController();
        }
        return this.accessController;
    }
}

