/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.accesscontrol;

import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.util.ComponentHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ObjectType;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

@Named
public class NodeAccessController
implements AccessController<NodePK> {
    @Inject
    private OrganisationController controller;

    public NodeAccessController() {
    }

    NodeAccessController(OrganisationController controller) {
        this.controller = controller;
    }

    public boolean isUserAuthorized(String userId, NodePK nodePK) {
        NodeDetail node;
        try {
            if (this.isKmax(nodePK)) {
                return true;
            }
            node = this.getNodeBm().getHeader(nodePK, false);
        }
        catch (Exception ex) {
            SilverTrace.error((String)"accesscontrol", (String)(this.getClass().getSimpleName() + ".isUserAuthorized()"), (String)"root.NO_EX_MESSAGE", (Throwable)ex);
            return false;
        }
        if (node != null) {
            if (!node.haveRights()) {
                return true;
            }
            return this.getOrganisationController().isObjectAvailable(node.getRightsDependsOn(), ObjectType.NODE, nodePK.getInstanceId(), userId);
        }
        return false;
    }

    public NodeBm getNodeBm() throws Exception {
        return (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
    }

    private OrganisationController getOrganisationController() {
        if (this.controller == null) {
            this.controller = OrganisationControllerFactory.getOrganisationController();
        }
        return this.controller;
    }

    private boolean isKmax(NodePK nodePK) {
        return ComponentHelper.getInstance().isKmax(nodePK.getInstanceId());
    }
}

