/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.accesscontrol;

import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.accesscontrol.NodeAccessController;
import com.silverpeas.util.ComponentHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.util.Collection;
import javax.inject.Inject;
import org.silverpeas.attachment.model.SimpleDocument;

public class SimpleDocumentAccessController
implements AccessController<SimpleDocument> {
    @Inject
    private NodeAccessController accessController;

    public SimpleDocumentAccessController() {
    }

    SimpleDocumentAccessController(NodeAccessController accessController) {
        this.accessController = accessController;
    }

    public boolean isUserAuthorized(String userId, SimpleDocument object) {
        String componentId;
        ComponentHelper componentHelper = ComponentHelper.getInstance();
        if (componentHelper.isThemeTracker(componentId = object.getInstanceId())) {
            String foreignId = object.getForeignId();
            if (StringUtil.isInteger((String)foreignId)) {
                try {
                    foreignId = this.getActualForeignId(foreignId, object.getInstanceId());
                }
                catch (Exception e) {
                    SilverTrace.error((String)"accesscontrol", (String)(this.getClass().getSimpleName() + ".isUserAuthorized()"), (String)"root.NO_EX_MESSAGE", (Throwable)e);
                    return false;
                }
                if (!componentHelper.isKmax(componentId)) {
                    try {
                        Collection nodes = this.getPublicationBm().getAllFatherPK(new PublicationPK(foreignId, object.getInstanceId()));
                        for (NodePK nodePk : nodes) {
                            if (!this.getNodeAccessController().isUserAuthorized(userId, nodePk)) continue;
                            return true;
                        }
                    }
                    catch (Exception ex) {
                        SilverTrace.error((String)"accesscontrol", (String)(this.getClass().getSimpleName() + ".isUserAuthorized()"), (String)"root.NO_EX_MESSAGE", (Throwable)ex);
                        return false;
                    }
                    return false;
                }
            } else if (this.isFileAttachedToWysiwygDescriptionOfNode(foreignId)) {
                String nodeId = foreignId.substring("Node_".length());
                return this.getNodeAccessController().isUserAuthorized(userId, new NodePK(nodeId, object.getInstanceId()));
            }
        }
        return true;
    }

    private boolean isFileAttachedToWysiwygDescriptionOfNode(String foreignId) {
        return StringUtil.isDefined((String)foreignId) && foreignId.startsWith("Node_");
    }

    protected PublicationBm getPublicationBm() throws Exception {
        return (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
    }

    private String getActualForeignId(String foreignId, String instanceId) throws Exception {
        PublicationDetail pubDetail = this.getPublicationBm().getDetail(new PublicationPK(foreignId, instanceId));
        if (!pubDetail.isValid() && pubDetail.haveGotClone()) {
            return pubDetail.getCloneId();
        }
        return foreignId;
    }

    protected NodeAccessController getNodeAccessController() {
        if (this.accessController == null) {
            this.accessController = new NodeAccessController();
        }
        return this.accessController;
    }
}

