/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.accesscontrol;

import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.accesscontrol.ComponentAccessController;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

@Named
public class WorkspaceAccessController
implements AccessController<String> {
    @Inject
    private ComponentAccessController componentAccessController;
    @Inject
    private OrganisationController organizationController;

    public boolean isUserAuthorized(String userId, String spaceId) {
        boolean isAuthorized = false;
        if (spaceId == null) {
            isAuthorized = true;
        } else {
            String[] componentIds;
            for (String componentId : componentIds = this.getOrganisationController().getAllComponentIds(spaceId)) {
                if (!this.getComponentAccessController().isUserAuthorized(userId, componentId)) continue;
                isAuthorized = true;
                break;
            }
        }
        return isAuthorized;
    }

    private ComponentAccessController getComponentAccessController() {
        if (this.componentAccessController == null) {
            this.componentAccessController = new ComponentAccessController();
        }
        return this.componentAccessController;
    }

    private OrganisationController getOrganisationController() {
        if (this.organizationController == null) {
            this.organizationController = OrganisationControllerFactory.getOrganisationController();
        }
        return this.organizationController;
    }
}

