/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.localized;

import com.silverpeas.admin.components.Parameter;
import com.silverpeas.admin.components.Profile;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.admin.localized.LocalizedParameter;
import com.silverpeas.admin.localized.LocalizedProfile;
import com.silverpeas.ui.DisplayI18NHelper;
import java.util.ArrayList;
import java.util.List;

public class LocalizedComponent {
    private String lang;
    private WAComponent realComponent;

    public LocalizedComponent(WAComponent component, String lang) {
        this.realComponent = component;
        this.lang = lang;
    }

    public String getDescription() {
        if (this.realComponent.getDescription().containsKey(this.lang)) {
            return (String)this.realComponent.getDescription().get(this.lang);
        }
        return (String)this.realComponent.getDescription().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getInstanceClassName() {
        return this.realComponent.getInstanceClassName();
    }

    public String getLabel() {
        if (this.realComponent.getLabel().containsKey(this.lang)) {
            return (String)this.realComponent.getLabel().get(this.lang);
        }
        return (String)this.realComponent.getLabel().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getName() {
        return this.realComponent.getName();
    }

    public List<LocalizedParameter> getParameters() {
        ArrayList<LocalizedParameter> localizedParameters = new ArrayList<LocalizedParameter>();
        for (Parameter parameter : this.realComponent.getParameters()) {
            localizedParameters.add(new LocalizedParameter(parameter, this.lang));
        }
        return localizedParameters;
    }

    public List<LocalizedProfile> getProfiles() {
        ArrayList<LocalizedProfile> localizedProfiles = new ArrayList<LocalizedProfile>();
        for (Profile profile : this.realComponent.getProfiles()) {
            localizedProfiles.add(new LocalizedProfile(profile, this.lang));
        }
        return localizedProfiles;
    }

    public String getRouter() {
        return this.realComponent.getRouter();
    }

    public List<LocalizedParameter> getSortedParameters() {
        ArrayList<LocalizedParameter> localizedParameters = new ArrayList<LocalizedParameter>();
        for (Parameter parameter : this.realComponent.getSortedParameters()) {
            localizedParameters.add(new LocalizedParameter(parameter, this.lang));
        }
        return localizedParameters;
    }

    public String getSuite() {
        if (this.realComponent.getSuite().containsKey(this.lang)) {
            return (String)this.realComponent.getSuite().get(this.lang);
        }
        return (String)this.realComponent.getSuite().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public boolean isPortlet() {
        return this.realComponent.isPortlet();
    }

    public boolean isVisible() {
        return this.realComponent.isVisible();
    }

    public boolean isVisibleInPersonalSpace() {
        return this.realComponent.isVisibleInPersonalSpace();
    }
}

