/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.localized;

import com.silverpeas.admin.components.Option;
import com.silverpeas.admin.components.Parameter;
import com.silverpeas.admin.localized.LocalizedOption;
import com.silverpeas.ui.DisplayI18NHelper;
import java.util.ArrayList;
import java.util.List;

public class LocalizedParameter {
    private String lang;
    private Parameter realParameter;
    private List<LocalizedOption> localizedOptions;

    public LocalizedParameter(Parameter parameter, String lang) {
        this.realParameter = parameter;
        this.lang = lang;
    }

    public String getHelp() {
        if (this.realParameter.getHelp().containsKey(this.lang)) {
            return (String)this.realParameter.getHelp().get(this.lang);
        }
        return (String)this.realParameter.getHelp().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getWarning() {
        if (this.realParameter.getWarning().containsKey(this.lang)) {
            return (String)this.realParameter.getWarning().get(this.lang);
        }
        return (String)this.realParameter.getWarning().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getLabel() {
        if (this.realParameter.getLabel().containsKey(this.lang)) {
            return (String)this.realParameter.getLabel().get(this.lang);
        }
        return (String)this.realParameter.getLabel().get(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getName() {
        return this.realParameter.getName();
    }

    public List<LocalizedOption> getOptions() {
        if (this.localizedOptions == null) {
            this.localizedOptions = new ArrayList<LocalizedOption>();
            for (Option option : this.realParameter.getOptions()) {
                this.localizedOptions.add(new LocalizedOption(option, this.lang));
            }
        }
        return this.localizedOptions;
    }

    public void setOptions(List<LocalizedOption> options) {
        this.localizedOptions = options;
    }

    public int getOrder() {
        return this.realParameter.getOrder();
    }

    public String getPersonalSpaceValue() {
        return this.realParameter.getPersonalSpaceValue();
    }

    public Integer getSize() {
        return this.realParameter.getSize();
    }

    public String getType() {
        return this.realParameter.getType();
    }

    public String getUpdatable() {
        return this.realParameter.getUpdatable();
    }

    public String getValue() {
        return this.realParameter.getValue();
    }

    public boolean isAlwaysUpdatable() {
        return this.realParameter.isAlwaysUpdatable();
    }

    public boolean isCheckbox() {
        return this.realParameter.isCheckbox();
    }

    public boolean isHidden() {
        return this.realParameter.isHidden();
    }

    public boolean isMandatory() {
        return this.realParameter.isMandatory();
    }

    public boolean isNeverUpdatable() {
        return this.realParameter.isNeverUpdatable();
    }

    public boolean isRadio() {
        return this.realParameter.isRadio();
    }

    public boolean isSelect() {
        return this.realParameter.isSelect();
    }

    public boolean isText() {
        return this.realParameter.isText();
    }

    public boolean isUpdatableOnCreationOnly() {
        return this.realParameter.isUpdatableOnCreationOnly();
    }

    public boolean isVisible() {
        return this.realParameter.isVisible();
    }

    public boolean isXmlTemplate() {
        return this.realParameter.isXmlTemplate();
    }
}

