/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.annotation.processing;

import com.silverpeas.web.RESTWebService;
import com.silverpeas.web.UserPriviledgeValidation;
import com.silverpeas.web.UserPriviledgeValidationFactory;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class AuthenticatedAnnotationProcessor {
    @Pointcut(value="@within(com.silverpeas.annotation.Authenticated) && this(com.silverpeas.web.RESTWebService)")
    public void webServicesAnnotatedWithAuthenticated() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.GET) && execution(* *(..))")
    public void methodAnnotatedWithGET() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.POST) && execution(* *(..))")
    public void methodAnnotatedWithPOST() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.DELETE) && execution(* *(..))")
    public void methodAnnotatedWithDELETE() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.PUT) && execution(* *(..))")
    public void methodAnnotatedWithPUT() {
    }

    @Before(value="webServicesAnnotatedWithAuthenticated() && (methodAnnotatedWithGET() || methodAnnotatedWithPOST() || methodAnnotatedWithDELETE() || methodAnnotatedWithPUT()) && this(service)")
    public void validateTheAuthentication(RESTWebService service) throws Throwable {
        UserPriviledgeValidation validation = UserPriviledgeValidationFactory.getFactory().getUserPriviledgeValidation();
        service.validateUserAuthentication(validation);
    }
}

