/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.attachment.web;

import com.silverpeas.web.Exposable;
import com.stratelia.silverpeas.peasCore.URLManager;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.model.SimpleDocument;

@XmlRootElement
public class AttachmentEntity
implements Exposable {
    private static final long serialVersionUID = 6578990825699318566L;
    @XmlElement(required=true)
    private String id;
    @XmlElement(required=true)
    private String instanceId;
    @XmlElement(required=true)
    private String logicalName;
    @XmlElement(defaultValue="")
    private String description;
    @XmlElement(defaultValue="")
    private String type;
    @XmlElement(defaultValue="0")
    private long creationDate;
    @XmlElement(defaultValue="0")
    private long size;
    @XmlElement(defaultValue="")
    private String author;
    @XmlElement(defaultValue="")
    private String title;
    @XmlElement(required=true)
    private URI uri;
    @XmlElement(required=true)
    private String icon;
    @XmlElement(required=true)
    private String permalink;
    @XmlElement(required=false)
    private URI sharedUri;

    public static AttachmentEntity fromAttachment(SimpleDocument detail) {
        AttachmentEntity entity = new AttachmentEntity();
        try {
            entity.uri = new URI(URLManager.getSimpleURL((int)4, (String)detail.getId()));
        }
        catch (URISyntaxException e) {
            throw new AttachmentException("AttachmentEntity.fromAttachment(", 4, "Couldn't build the URI to the attachment", (Exception)e);
        }
        entity.id = detail.getId();
        entity.instanceId = detail.getInstanceId();
        entity.logicalName = detail.getFilename();
        entity.description = detail.getDescription();
        entity.size = detail.getSize();
        entity.creationDate = detail.getCreated().getTime();
        entity.author = detail.getCreatedBy();
        entity.title = detail.getTitle();
        entity.type = detail.getContentType();
        entity.icon = detail.getDisplayIcon();
        entity.permalink = URLManager.getSimpleURL((int)4, (String)detail.getId());
        return entity;
    }

    public AttachmentEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setSharedUri(URI sharedUri) {
        this.sharedUri = sharedUri;
    }
}

