/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.attachment.web;

import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.attachment.web.ZipEntity;
import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.security.ShareableAttachment;
import com.silverpeas.sharing.services.SharingServiceFactory;
import com.silverpeas.util.ZipManager;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;

@Service
@RequestScoped
@Path(value="attachments/{componentId}/{token}")
public class AttachmentRessource
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="token")
    private String token;

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @GET
    @Path(value="{id}/{name}")
    @Produces(value={"application/octet-stream"})
    public Response getFileContent(@PathParam(value="id") String attachmentId) {
        final SimpleDocument attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId), null).getLastPublicVersion();
        if (!this.isFileReadable(attachment)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        StreamingOutput data = new StreamingOutput(){

            public void write(OutputStream output) throws WebApplicationException {
                try {
                    AttachmentServiceFactory.getAttachmentService().getBinaryContent(output, attachment.getPk(), attachment.getLanguage());
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
        };
        return Response.ok().entity((Object)data).type(attachment.getContentType()).build();
    }

    @GET
    @Path(value="{ids}/zip")
    @Produces(value={"application/json"})
    public ZipEntity zipFiles(@PathParam(value="ids") String attachmentIds) {
        StringTokenizer tokenizer = new StringTokenizer(attachmentIds, ",");
        File folderToZip = FileUtils.getFile((String[])new String[]{FileRepositoryManager.getTemporaryPath(), UUID.randomUUID().toString()});
        while (tokenizer.hasMoreTokens()) {
            SimpleDocumentPK pk = new SimpleDocumentPK(tokenizer.nextToken());
            SimpleDocument attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(pk, null);
            if (!this.isFileReadable(attachment)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            FileOutputStream out = null;
            try {
                out = FileUtils.openOutputStream((File)FileUtils.getFile((File)folderToZip, (String[])new String[]{attachment.getFilename()}));
                AttachmentServiceFactory.getAttachmentService().getBinaryContent((OutputStream)out, pk, this.token);
            }
            catch (IOException e) {
                try {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        try {
            File zipFile = FileUtils.getFile((String[])new String[]{folderToZip.getPath() + ".zip"});
            URI downloadUri = this.getUriInfo().getBaseUriBuilder().path("attachments").path(this.componentId).path(this.token).path("zipcontent").path(zipFile.getName()).build(new Object[0]);
            long size = ZipManager.compressPathToZip((File)folderToZip, (File)zipFile);
            ZipEntity zipEntity = new ZipEntity(this.getUriInfo().getRequestUri(), downloadUri.toString(), size);
            return zipEntity;
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (UriBuilderException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            FileUtils.deleteQuietly((File)folderToZip);
        }
    }

    @GET
    @Path(value="zipcontent/{name}")
    @Produces(value={"application/octet-stream"})
    public Response getZipContent(@PathParam(value="name") String zipFileName) {
        Response response;
        String zipFilePath = FileRepositoryManager.getTemporaryPath() + zipFileName;
        File realFile = new File(zipFilePath);
        if (!realFile.exists() && !realFile.isFile()) {
            return Response.ok().build();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileInputStream in = null;
        try {
            in = new FileInputStream(realFile);
            output.write((InputStream)in);
            response = Response.ok().entity((Object)output.toByteArray()).type("application/zip").build();
        }
        catch (IOException e) {
            try {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((OutputStream)output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)output);
        return response;
    }

    private boolean isFileReadable(SimpleDocument attachment) {
        ShareableAttachment attachmentResource = new ShareableAttachment(this.token, attachment);
        Ticket ticket = SharingServiceFactory.getSharingTicketService().getTicket(this.token);
        return ticket != null && ticket.getAccessControl().isReadable(attachmentResource);
    }
}

