/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.authentication;

import com.silverpeas.authentication.CredentialEncryption;
import com.silverpeas.authentication.CredentialEncryptionFactory;
import com.silverpeas.socialnetwork.model.ExternalAccount;
import com.silverpeas.socialnetwork.model.SocialNetworkID;
import com.silverpeas.socialnetwork.service.AccessToken;
import com.silverpeas.socialnetwork.service.SocialNetworkService;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.spnego.SpnegoPrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class AuthenticationParameters {
    private final int keyMaxLength = 12;
    private String login;
    private String password;
    private String domainId;
    private String storedPassword;
    private String cryptedPassword;
    private String clearPassword;
    private boolean casMode;
    private boolean ssoMode;
    private boolean userByInternalAuthTokenMode;
    private boolean socialNetworkMode;
    private SocialNetworkID networkId;

    public AuthenticationParameters(HttpServletRequest request) {
        ResourceLocator authenticationSettings = new ResourceLocator("com.silverpeas.authentication.settings.authenticationSettings", "");
        HttpSession session = request.getSession();
        boolean cookieEnabled = authenticationSettings.getBoolean("cookieEnabled", false);
        UserDetail userByInternalAuthToken = this.getUserByInternalAuthToken(request);
        this.ssoMode = this.getSSOUser(request) != null;
        this.casMode = this.getCASUser(session) != null;
        this.checkSocialNetworkMode(session);
        String stringKey = this.convert2Alpha(session.getId());
        boolean useNewEncryptionMode = StringUtil.isDefined((String)request.getParameter("Var2"));
        if (userByInternalAuthToken != null) {
            this.userByInternalAuthTokenMode = true;
            this.login = userByInternalAuthToken.getLogin();
            this.domainId = userByInternalAuthToken.getDomainId();
            this.password = "";
        } else if (this.ssoMode) {
            this.login = this.getSSOUser(request);
            this.password = "";
        } else if (this.casMode) {
            this.login = this.getCASUser(session);
            this.password = "";
        } else if (!this.socialNetworkMode) {
            if (useNewEncryptionMode) {
                this.login = request.getParameter("Var2");
                this.password = request.getParameter("Var1");
                this.storedPassword = request.getParameter("tq");
                this.cryptedPassword = request.getParameter("dq");
            } else {
                this.login = request.getParameter("Login");
                this.password = request.getParameter("Password");
                this.storedPassword = request.getParameter("storePassword");
                this.cryptedPassword = request.getParameter("cryptedPassword");
            }
        }
        SilverTrace.debug((String)"authentication", (String)"AuthenticationServlet.doPost()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("sCryptedPassword = " + this.cryptedPassword));
        this.decodePassword(cookieEnabled, stringKey, useNewEncryptionMode);
    }

    private void checkSocialNetworkMode(HttpSession session) {
        this.socialNetworkMode = false;
        this.networkId = SocialNetworkService.getInstance().getSocialNetworkIDUsedForLogin(session);
        if (this.networkId != null) {
            AccessToken authorizationToken = SocialNetworkService.getInstance().getStoredAuthorizationToken(session, this.networkId);
            String profileId = SocialNetworkService.getInstance().getSocialNetworkConnector(this.networkId).getUserProfileId(authorizationToken);
            ExternalAccount account = SocialNetworkService.getInstance().getExternalAccount(this.networkId, profileId);
            UserDetail user = OrganisationControllerFactory.getOrganisationController().getUserDetail(account.getSilverpeasUserId());
            this.domainId = user.getDomainId();
            this.login = user.getLogin();
            this.socialNetworkMode = user != null;
        }
    }

    private void decodePassword(boolean cookieEnabled, String stringKey, boolean newEncryptMode) {
        CredentialEncryption encryption = CredentialEncryptionFactory.getInstance().getEncryption();
        if (newEncryptMode) {
            String decodedLogin = encryption.decode(this.login, stringKey, false);
            String string = this.clearPassword = !StringUtil.isDefined((String)this.cryptedPassword) ? encryption.decode(this.password, stringKey, false) : encryption.decode(this.password, stringKey, true);
            if (cookieEnabled && StringUtil.isDefined((String)this.cryptedPassword)) {
                decodedLogin = encryption.decode(this.login, stringKey, true);
            }
            this.login = decodedLogin;
        } else {
            this.clearPassword = !StringUtil.isDefined((String)this.cryptedPassword) ? this.password : encryption.decode(this.password);
        }
    }

    private String convert2Alpha(String toConvert) {
        String alphaString = "";
        for (int i = 0; i < toConvert.length() && alphaString.length() < 12; ++i) {
            char asciiCode = toConvert.toUpperCase().charAt(i);
            if (asciiCode < 'A' || asciiCode > 'Z') continue;
            alphaString = alphaString + toConvert.substring(i, i + 1);
        }
        if (alphaString.length() < 12) {
            alphaString = alphaString + "ZFGHZSZHHJNT".substring(0, 12 - alphaString.length());
        }
        return alphaString;
    }

    private String getCASUser(HttpSession session) {
        String casUser = null;
        if (session.getAttribute("_const_cas_assertion_") != null) {
            casUser = ((Assertion)session.getAttribute("_const_cas_assertion_")).getPrincipal().getName();
        }
        return casUser;
    }

    private String getSSOUser(HttpServletRequest request) {
        if (request.getUserPrincipal() instanceof SpnegoPrincipal) {
            return request.getRemoteUser();
        }
        return null;
    }

    private UserDetail getUserByInternalAuthToken(HttpServletRequest request) {
        String internalAuthToken = (String)request.getAttribute("internalAuthToken");
        if (StringUtil.isDefined((String)internalAuthToken) && CacheServiceFactory.getCacheService().get((Object)internalAuthToken) instanceof UserDetail) {
            return (UserDetail)CacheServiceFactory.getCacheService().remove((Object)internalAuthToken);
        }
        return null;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getStoredPassword() {
        return this.storedPassword;
    }

    public String getCryptedPassword() {
        return this.cryptedPassword;
    }

    public String getClearPassword() {
        return this.clearPassword;
    }

    public boolean isCasMode() {
        return this.casMode;
    }

    public boolean isSsoMode() {
        return this.ssoMode;
    }

    public boolean isUserByInternalAuthTokenMode() {
        return this.userByInternalAuthTokenMode;
    }

    public boolean isSocialNetworkMode() {
        return this.socialNetworkMode;
    }

    public String getDomainId() {
        return this.domainId;
    }
}

