/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.authentication;

import com.silverpeas.authentication.AuthenticationParameters;
import com.silverpeas.authentication.CredentialEncryptionFactory;
import com.silverpeas.authentication.MandatoryQuestionChecker;
import com.silverpeas.authentication.SilverpeasSessionOpener;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.AuthenticationService;
import org.silverpeas.authentication.exception.AuthenticationNoMoreUserConnectionAttemptException;
import org.silverpeas.authentication.exception.AuthenticationUserMustAcceptTermsOfService;
import org.silverpeas.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.authentication.verifier.UserCanTryAgainToLoginVerifier;
import org.silverpeas.authentication.verifier.UserMustAcceptTermsOfServiceVerifier;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class AuthenticationServlet
extends HttpServlet {
    private static AuthenticationService authService = new AuthenticationService();
    private static final long serialVersionUID = -8695946617361150513L;
    private static final SilverpeasSessionOpener silverpeasSessionOpener = new SilverpeasSessionOpener();
    private static final String SSO_UNEXISTANT_USER_ACCOUNT = "Error_SsoOnUnexistantUserAccount";
    private static final String TECHNICAL_ISSUE = "2";
    private static final String INCORRECT_LOGIN_PWD = "1";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String url;
        HttpSession session = request.getSession();
        if (!StringUtil.isDefined((String)request.getCharacterEncoding())) {
            request.setCharacterEncoding("UTF-8");
        }
        if (silverpeasSessionOpener.isAnonymousUser(request)) {
            silverpeasSessionOpener.closeSession(request);
        }
        ResourceLocator authenticationSettings = new ResourceLocator("org.silverpeas.authentication.settings.authenticationSettings", "");
        boolean securedAccess = silverpeasSessionOpener.isNavigationSecure(request);
        boolean isNewEncryptMode = StringUtil.isDefined((String)request.getParameter("Var2"));
        AuthenticationParameters authenticationParameters = new AuthenticationParameters(request);
        session.setAttribute("Silverpeas_pwdForHyperlink", (Object)authenticationParameters.getClearPassword());
        String domainId = this.getDomain(request, authenticationParameters, authenticationSettings);
        AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin((String)authenticationParameters.getLogin()).withAsPassword(authenticationParameters.getPassword()).withAsDomainId(domainId);
        String authenticationKey = this.authenticate(request, authenticationParameters, domainId);
        UserCanTryAgainToLoginVerifier userCanTryAgainToLoginVerifier = AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier((AuthenticationCredential)credential);
        userCanTryAgainToLoginVerifier.clearSession(request);
        if (authenticationKey != null && !authenticationKey.startsWith("Error")) {
            MandatoryQuestionChecker checker;
            userCanTryAgainToLoginVerifier.clearCache();
            if (domainId != null) {
                this.storeDomain(response, domainId, securedAccess);
            }
            this.storeLogin(response, isNewEncryptMode, authenticationParameters.getLogin(), securedAccess);
            this.storePassword(response, authenticationParameters.getStoredPassword(), isNewEncryptMode, authenticationParameters.getClearPassword(), securedAccess);
            if (request.getAttribute("skipTermsOfServiceAcceptance") == null) {
                UserMustAcceptTermsOfServiceVerifier verifier = AuthenticationUserVerifierFactory.getUserMustAcceptTermsOfServiceVerifier((AuthenticationCredential)credential);
                try {
                    verifier.verify();
                }
                catch (AuthenticationUserMustAcceptTermsOfService authenticationUserMustAcceptTermsOfService) {
                    this.forward(request, response, verifier.getDestination(request));
                    return;
                }
            }
            if ((checker = new MandatoryQuestionChecker()).check(request, authenticationKey)) {
                this.forward(request, response, checker.getDestination());
                return;
            }
            String absoluteUrl = silverpeasSessionOpener.openSession(request, authenticationKey);
            this.writeSessionCookie(response, request.getSession(), securedAccess);
            response.sendRedirect(response.encodeRedirectURL(absoluteUrl));
            return;
        }
        this.removeStoredPassword(response, securedAccess);
        if (authenticationParameters.isCasMode()) {
            url = "/admin/jsp/casAuthenticationError.jsp";
        } else if ("Error_1".equals(authenticationKey)) {
            try {
                if (userCanTryAgainToLoginVerifier.isActivated()) {
                    this.storeLogin(response, isNewEncryptMode, authenticationParameters.getLogin(), securedAccess);
                    this.storeDomain(response, domainId, securedAccess);
                }
                url = userCanTryAgainToLoginVerifier.verify().performRequestUrl(request, "/Login.jsp?ErrorCode=1");
            }
            catch (AuthenticationNoMoreUserConnectionAttemptException e) {
                url = userCanTryAgainToLoginVerifier.getErrorDestination();
            }
        } else if ("Error_PwdExpired".equals(authenticationKey)) {
            String allowPasswordChange = (String)session.getAttribute("Svp_Password_Change_Allowed");
            if (StringUtil.getBooleanValue((String)allowPasswordChange)) {
                ResourceLocator settings = new ResourceLocator("com.silverpeas.authentication.settings.passwordExpiration", "");
                url = settings.getString("passwordExpiredURL") + "?login=" + authenticationParameters.getLogin() + "&domainId=" + domainId;
            } else {
                url = "/Login.jsp?ErrorCode=Error_PwdExpired";
            }
        } else if ("Error_PwdMustBeChanged".equals(authenticationKey)) {
            String allowPasswordChange = (String)session.getAttribute("Svp_Password_Change_Allowed");
            if (StringUtil.getBooleanValue((String)allowPasswordChange)) {
                ResourceLocator settings = new ResourceLocator("com.silverpeas.authentication.settings.passwordExpiration", "");
                url = settings.getString("passwordExpiredURL") + "?login=" + authenticationParameters.getLogin() + "&domainId=" + domainId;
            } else {
                url = "/Login.jsp?ErrorCode=Error_PwdExpired";
            }
        } else {
            if ("Error_PwdMustBeChangedOnFirstLogin".equals(authenticationKey)) {
                this.storeLogin(response, isNewEncryptMode, authenticationParameters.getLogin(), securedAccess);
                this.storeDomain(response, domainId, securedAccess);
                String url2 = AuthenticationUserVerifierFactory.getUserMustChangePasswordVerifier((AuthenticationCredential)credential).getDestinationOnFirstLogin(request);
                this.forward(request, response, url2);
                return;
            }
            if ("Error_UserAccountBlocked".equals(authenticationKey)) {
                if (userCanTryAgainToLoginVerifier.isActivated() || StringUtil.isDefined((String)userCanTryAgainToLoginVerifier.getUser().getId())) {
                    this.storeLogin(response, isNewEncryptMode, authenticationParameters.getLogin(), securedAccess);
                    this.storeDomain(response, domainId, securedAccess);
                    url = AuthenticationUserVerifierFactory.getUserCanLoginVerifier((UserDetail)null).getErrorDestination();
                } else {
                    url = "/Login.jsp?ErrorCode=1";
                }
            } else if (authenticationParameters.isSsoMode()) {
                this.storeDomain(response, domainId, securedAccess);
                this.storeLogin(response, isNewEncryptMode, authenticationParameters.getLogin(), securedAccess);
                url = "/Login.jsp?ErrorCode=Error_SsoOnUnexistantUserAccount";
            } else {
                url = "/Login.jsp?ErrorCode=2";
            }
        }
        response.sendRedirect(response.encodeRedirectURL(URLManager.getFullApplicationURL((HttpServletRequest)request) + url));
    }

    private void forward(HttpServletRequest request, HttpServletResponse response, String destination) throws ServletException, IOException {
        RequestDispatcher dispatcher = request.getRequestDispatcher(destination);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void storePassword(HttpServletResponse response, String shoudStorePasword, boolean newEncryptMode, String clearPassword, boolean secured) {
        if (StringUtil.getBooleanValue((String)shoudStorePasword)) {
            SilverTrace.debug((String)"authentication", (String)"AuthenticationServlet.doPost()", (String)"root.MSG_GEN_ENTER_METHOD", (String)"Ok");
            if (newEncryptMode) {
                this.writeCookie(response, "var2", CredentialEncryptionFactory.getInstance().getEncryption().encode(clearPassword), -1, secured);
                this.writeCookie(response, "var2", CredentialEncryptionFactory.getInstance().getEncryption().encode(clearPassword), 31536000, secured);
            } else {
                this.writeCookie(response, "svpPassword", CredentialEncryptionFactory.getInstance().getEncryption().encode(clearPassword), -1, secured);
                this.writeCookie(response, "svpPassword", CredentialEncryptionFactory.getInstance().getEncryption().encode(clearPassword), 31536000, secured);
            }
        }
    }

    private void removeStoredPassword(HttpServletResponse response, boolean secured) {
        this.writeCookie(response, "var2", "", 0, secured);
        this.writeCookie(response, "svpPassword", "", 0, secured);
    }

    private void storeLogin(HttpServletResponse response, boolean newEncryptMode, String sLogin, boolean secured) {
        if (newEncryptMode) {
            this.writeCookie(response, "var1", CredentialEncryptionFactory.getInstance().getEncryption().encode(sLogin), -1, secured);
            this.writeCookie(response, "var1", CredentialEncryptionFactory.getInstance().getEncryption().encode(sLogin), 31536000, secured);
        } else {
            this.writeCookie(response, "svpLogin", sLogin, -1, secured);
            this.writeCookie(response, "svpLogin", sLogin, 31536000, secured);
        }
    }

    private void storeDomain(HttpServletResponse response, String sDomainId, boolean secured) {
        this.writeCookie(response, "defaultDomain", sDomainId, -1, secured);
        this.writeCookie(response, "defaultDomain", sDomainId, 31536000, secured);
    }

    private String getDomain(HttpServletRequest request, AuthenticationParameters authParameters, ResourceLocator authSettings) {
        if (authParameters.isUserByInternalAuthTokenMode()) {
            return authParameters.getDomainId();
        }
        if (authParameters.isSsoMode()) {
            return authSettings.getString("sso.authentication.domainId", "0");
        }
        if (authParameters.isCasMode()) {
            return authSettings.getString("cas.authentication.domainId", "0");
        }
        OrganisationController controller = OrganisationControllerFactory.getOrganisationController();
        return controller.getDomain(request.getParameter("DomainId")).getId();
    }

    private String authenticate(HttpServletRequest request, AuthenticationParameters authenticationParameters, String sDomainId) {
        String key = request.getParameter("TestKey");
        if (!StringUtil.isDefined((String)key)) {
            AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin((String)authenticationParameters.getLogin());
            key = authenticationParameters.isUserByInternalAuthTokenMode() || authenticationParameters.isSsoMode() || authenticationParameters.isCasMode() ? authService.authenticate(credential.withAsDomainId(sDomainId)) : (authenticationParameters.isSocialNetworkMode() ? authService.authenticate(credential.withAsDomainId(authenticationParameters.getDomainId())) : authService.authenticate(credential.withAsPassword(authenticationParameters.getClearPassword()).withAsDomainId(sDomainId)));
            HttpSession session = request.getSession(false);
            for (Map.Entry capability : credential.getCapabilities().entrySet()) {
                session.setAttribute((String)capability.getKey(), capability.getValue());
            }
            return key;
        }
        return null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private void writeSessionCookie(HttpServletResponse response, HttpSession session, boolean secured) {
        Cookie cookie = new Cookie("JSESSIONID", session.getId());
        cookie.setMaxAge(-1);
        cookie.setPath(session.getServletContext().getContextPath());
        cookie.setHttpOnly(true);
        if (secured) {
            cookie.setSecure(secured);
        }
        response.addCookie(cookie);
    }

    private void writeCookie(HttpServletResponse response, String name, String value, int duration, boolean secure) {
        String cookieValue;
        try {
            cookieValue = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            cookieValue = value;
        }
        Cookie cookie = new Cookie(name, cookieValue);
        cookie.setMaxAge(duration);
        cookie.setPath("/");
        if (secure) {
            cookie.setSecure(true);
        }
        response.addCookie(cookie);
    }
}

