/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.authentication;

import com.silverpeas.authentication.CredentialEncryption;
import com.silverpeas.authentication.CustomCredentialEncryption;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;

public class CredentialEncryptionFactory {
    private Class<? extends CredentialEncryption> encryptionClass;
    private static final CredentialEncryptionFactory instance = new CredentialEncryptionFactory();

    private CredentialEncryptionFactory() {
        ResourceLocator settingsFile = new ResourceLocator("com.silverpeas.authentication.settings.authenticationSettings", "");
        try {
            this.encryptionClass = Class.forName(settingsFile.getString("encryptionClass", "com.silverpeas.authentication.CustomCredentialEncryption"));
        }
        catch (ClassNotFoundException e) {
            SilverTrace.info((String)"authentication", (String)"CredentialEncryptionFactory.getCustomEncryption()", (String)"root.MSG_PARAM_ENTER_VALUE", (String)"Encrypt/Decrypt Custom Class not found", (Throwable)e);
        }
    }

    public static CredentialEncryptionFactory getInstance() {
        return instance;
    }

    public CredentialEncryption getEncryption() {
        try {
            return this.encryptionClass.newInstance();
        }
        catch (InstantiationException e) {
            SilverTrace.info((String)"authentication", (String)"CredentialEncryptionFactory.getCustomEncryption()", (String)"root.MSG_PARAM_ENTER_VALUE", (String)"Encrypt/Decrypt Custom Class not found", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            SilverTrace.info((String)"authentication", (String)"CredentialEncryptionFactory.getCustomEncryption()", (String)"root.MSG_PARAM_ENTER_VALUE", (String)"Encrypt/Decrypt Custom Class not found", (Throwable)e);
        }
        return new CustomCredentialEncryption();
    }
}

