/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.authentication;

import com.silverpeas.session.SessionInfo;
import com.silverpeas.session.SessionManagement;
import com.silverpeas.session.SessionManagementFactory;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationSender;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SilverpeasSessionOpener {
    private static final int HTTP_DEFAULT_PORT = 80;

    public boolean isAnonymousUser(HttpServletRequest request) {
        HttpSession session = request.getSession();
        MainSessionController controller = (MainSessionController)session.getAttribute("SilverSessionController");
        if (controller != null) {
            return controller.getCurrentUserDetail().isAnonymous();
        }
        return false;
    }

    public String openSession(HttpServletRequest request, String authKey) {
        this.closeSession(request);
        HttpSession session = request.getSession();
        try {
            SilverTrace.info((String)"peasCore", (String)"SilverpeasSessionOpenener.openSession()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("session id=" + session.getId()));
            MainSessionController controller = new MainSessionController(authKey, session.getId());
            String allowPasswordChange = (String)session.getAttribute("Svp_Password_Change_Allowed");
            controller.setAllowPasswordChange(StringUtil.getBooleanValue((String)allowPasswordChange));
            Boolean alertUserAboutPwdExpiration = (Boolean)session.getAttribute("Svp_Pwd_About_To_Expire");
            String redirectURL = null;
            if (alertUserAboutPwdExpiration != null && alertUserAboutPwdExpiration.booleanValue()) {
                redirectURL = this.alertUserAboutPwdExpiration(controller.getUserId(), controller.getOrganisationController().getAdministratorUserIds(controller.getUserId())[0], controller.getFavoriteLanguage(), StringUtil.getBooleanValue((String)allowPasswordChange));
            }
            if (!controller.getCurrentUserDetail().isDeletedState()) {
                SessionManagementFactory factory;
                SessionManagement sessionManagement;
                SessionInfo sessionInfo;
                if (!UserDetail.isAnonymousUser((String)controller.getUserId()) && (sessionInfo = (sessionManagement = (factory = SessionManagementFactory.getFactory()).getSessionManagement()).validateSession(session.getId())) == null) {
                    sessionManagement.openSession(controller.getCurrentUserDetail(), request);
                    this.registerSuccessfulConnexion(controller);
                }
                session.setAttribute("SilverSessionController", (Object)controller);
                return this.getHomePageUrl(request, redirectURL);
            }
        }
        catch (Exception e) {
            SilverTrace.error((String)"peasCore", (String)"SilverpeasSessionOpenener.openSession()", (String)"peasCore.EX_LOGIN_SERVLET_CANT_CREATE_MAIN_SESSION_CTRL", (String)("session id=" + session.getId()), (Throwable)e);
        }
        return this.getErrorPageUrl(request, authKey);
    }

    private void registerSuccessfulConnexion(MainSessionController controller) {
        UserDetail user = UserDetail.getById((String)controller.getUserId());
        user.setLastLoginDate(DateUtil.getNow());
        user.setNbSuccessfulLoginAttempts(user.getNbSuccessfulLoginAttempts() + 1);
        new AdminController(user.getId()).updateUser(user);
    }

    public void closeSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.removeAttribute("SilverSessionController");
        session.removeAttribute("SessionGraphicElementFactory");
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String attributeName = (String)names.nextElement();
            if (attributeName.startsWith("Redirect") || "gotoNew".equals(attributeName) || "Svp_Password_Change_Allowed".equals(attributeName) || "Svp_Pwd_About_To_Expire".equals(attributeName)) continue;
            session.removeAttribute(attributeName);
        }
        SessionManagementFactory factory = SessionManagementFactory.getFactory();
        SessionManagement sessionManagement = factory.getSessionManagement();
        sessionManagement.closeSession(session.getId());
    }

    protected String getErrorPageUrl(HttpServletRequest request, String authKey) {
        SilverTrace.error((String)"peasCore", (String)"SilverpeasSessionOpenener.openSession()", (String)"peasCore.EX_USER_KEY_NOT_FOUND", (String)("key=" + authKey));
        StringBuilder absoluteUrl = new StringBuilder(this.getAbsoluteUrl(request));
        if (absoluteUrl.charAt(absoluteUrl.length() - 1) != '/') {
            absoluteUrl.append('/');
        }
        absoluteUrl.append("Login.jsp");
        return absoluteUrl.toString();
    }

    protected String getHomePageUrl(HttpServletRequest request, String redirectURL) {
        StringBuilder absoluteUrl = new StringBuilder(this.getAbsoluteUrl(request));
        HttpSession session = request.getSession(false);
        MainSessionController controller = (MainSessionController)session.getAttribute("SilverSessionController");
        String serverName = request.getServerName();
        int serverPort = this.getServerPort(request);
        String port = "";
        if (serverPort != 80) {
            port = String.valueOf(serverPort);
        }
        controller.initServerProps(serverName, port);
        String personalWs = controller.getPersonalization().getPersonalWorkSpaceId();
        SilverTrace.debug((String)"peasCore", (String)"SilverpeasSessionOpenener.openSession", (String)("user personal workspace=" + personalWs));
        GraphicElementFactory gef = new GraphicElementFactory(controller.getFavoriteLook());
        if (StringUtil.isDefined((String)personalWs)) {
            gef.setSpaceId(personalWs);
        }
        gef.setHttpRequest(request);
        session.setAttribute("SessionGraphicElementFactory", (Object)gef);
        String favoriteFrame = gef.getLookFrame();
        SilverTrace.debug((String)"peasCore", (String)"SilverpeasSessionOpenener.openSession", (String)"root.MSG_GEN_PARAM_VALUE", (String)("controller.getUserAccessLevel()=" + controller.getUserAccessLevel()));
        SilverTrace.debug((String)"peasCore", (String)"SilverpeasSessionOpenener.openSession", (String)"root.MSG_GEN_PARAM_VALUE", (String)("controller.isAppInMaintenance()=" + controller.isAppInMaintenance()));
        String sDirectAccessSpace = request.getParameter("DirectAccessSpace");
        String sDirectAccessCompo = request.getParameter("DirectAccessCompo");
        if (controller.isAppInMaintenance() && !controller.getCurrentUserDetail().isAccessAdmin()) {
            absoluteUrl.append("/admin/jsp/appInMaintenance.jsp");
        } else if (StringUtil.isDefined((String)redirectURL)) {
            absoluteUrl.append(redirectURL);
        } else if (StringUtil.isDefined((String)sDirectAccessSpace) && StringUtil.isDefined((String)sDirectAccessCompo)) {
            absoluteUrl.append(URLManager.getURL((String)sDirectAccessSpace, (String)sDirectAccessCompo)).append("Main");
        } else {
            absoluteUrl.append("/Main/").append(favoriteFrame);
        }
        return absoluteUrl.toString();
    }

    protected String getAbsoluteUrl(HttpServletRequest request) {
        StringBuilder absoluteUrl = new StringBuilder(256);
        if (this.isNavigationSecure(request)) {
            absoluteUrl.append("https://");
        } else {
            absoluteUrl.append("http://");
        }
        absoluteUrl.append(request.getServerName()).append(':');
        absoluteUrl.append(this.getServerPort(request));
        absoluteUrl.append(URLManager.getApplicationURL());
        return absoluteUrl.toString();
    }

    public boolean isNavigationSecure(HttpServletRequest request) {
        return !GeneralPropertiesManager.getBoolean((String)"server.mixed", (boolean)false) && (request.isSecure() || GeneralPropertiesManager.getBoolean((String)"server.ssl", (boolean)false));
    }

    private int getServerPort(HttpServletRequest request) {
        return GeneralPropertiesManager.getInteger((String)"server.http.port", (int)request.getServerPort());
    }

    private String alertUserAboutPwdExpiration(String userId, String fromUserId, String language, boolean allowPasswordChange) {
        try {
            ResourceLocator settings = new ResourceLocator("org.silverpeas.authentication.settings.passwordExpiration", "");
            String notificationType = settings.getString("notificationType", "POPUP");
            String passwordChangeURL = settings.getString("passwordChangeURL", "defaultPasswordAboutToExpire.jsp");
            if ("POPUP".equalsIgnoreCase(notificationType) || !allowPasswordChange) {
                this.sendPopupNotificationAboutPwdExpiration(userId, fromUserId, language);
                return null;
            }
            return passwordChangeURL;
        }
        catch (NotificationManagerException e) {
            SilverTrace.warn((String)"peasCore", (String)"SilverpeasSessionOpenener.alertUserAboutPwdExpiration", (String)"peasCore.EX_CANT_SEND_PASSWORD_EXPIRATION_ALERT", (String)("userId = " + userId), (Throwable)e);
            return null;
        }
    }

    private void sendPopupNotificationAboutPwdExpiration(String userId, String fromUserId, String language) throws NotificationManagerException {
        ResourceLocator messages = new ResourceLocator("org.silverpeas.peasCore.multilang.peasCoreBundle", language);
        NotificationSender sender = new NotificationSender(null);
        NotificationMetaData notifMetaData = new NotificationMetaData(0, messages.getString("passwordExpirationAlert"), messages.getString("passwordExpirationMessage"));
        notifMetaData.setSender(fromUserId);
        notifMetaData.addUserRecipient(new UserRecipient(userId));
        sender.notifyUser(-10, notifMetaData);
    }
}

