/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.bundle.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.web.RESTWebService;
import com.silverpeas.web.UserPriviledgeValidation;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.MissingResourceException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="request")
@Path(value="bundles")
@Authenticated
public class BundleResource
extends RESTWebService {
    private static final String GENERAL_SETTINGS = "org.silverpeas.general";

    @Override
    public String getComponentId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void validateUserAuthentication(UserPriviledgeValidation validation) throws WebApplicationException {
        block2: {
            try {
                super.validateUserAuthentication(validation);
            }
            catch (WebApplicationException wae) {
                if (Response.Status.UNAUTHORIZED.getStatusCode() == wae.getResponse().getStatus()) break block2;
                throw wae;
            }
        }
    }

    @GET
    @Path(value="{bundle: (com|org)/[a-zA-Z0-9/._$]+}")
    @Produces(value={"text/plain"})
    public Response getLocalizedBundle(@PathParam(value="bundle") String bundle) throws IOException {
        String language = this.getLanguage();
        String localizedBundle = bundle;
        if (bundle.endsWith(".properties")) {
            localizedBundle = bundle.substring(0, bundle.indexOf(".properties"));
        }
        if (localizedBundle.lastIndexOf("_") == localizedBundle.length() - 3) {
            String askedLanguage = localizedBundle.substring(bundle.lastIndexOf("_") + 1);
            if (!askedLanguage.equals("$$")) {
                language = askedLanguage;
            }
            localizedBundle = localizedBundle.substring(0, bundle.lastIndexOf("_"));
        }
        localizedBundle = localizedBundle.replaceAll("/", ".");
        ResourceLocator generalResource = GeneralPropertiesManager.getGeneralMultilang((String)language);
        ResourceLocator resource = new ResourceLocator(localizedBundle, language);
        try {
            if (!bundle.trim().isEmpty() && bundle.contains("multilang")) {
                StringWriter messages = new StringWriter();
                resource.getProperties().store(messages, localizedBundle + " - " + resource.getLanguage());
                generalResource.getProperties().store(messages, "org.silverpeas.multilang.generalMultilang - " + generalResource.getLanguage());
                return Response.ok((Object)messages.toString()).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"It is not a localized bundle with translations").build();
        }
        catch (MissingResourceException ex) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="settings/{bundle: (com|org)/[a-zA-Z0-9/._$]+}")
    @Produces(value={"text/plain"})
    public Response getSettingsBundle(@PathParam(value="bundle") String bundle) throws IOException {
        String settingsBundle = bundle;
        if (bundle.endsWith(".properties")) {
            settingsBundle = bundle.substring(0, bundle.indexOf(".properties"));
        }
        if (settingsBundle.lastIndexOf("_") == settingsBundle.length() - 3) {
            settingsBundle = settingsBundle.substring(0, bundle.lastIndexOf("_"));
        }
        settingsBundle = settingsBundle.replaceAll("/", ".");
        ResourceLocator generalSettings = new ResourceLocator(GENERAL_SETTINGS, "");
        ResourceLocator settings = new ResourceLocator(settingsBundle, "");
        try {
            if (!bundle.trim().isEmpty() && !bundle.contains("multilang")) {
                StringWriter messages = new StringWriter();
                settings.getProperties().store(messages, settingsBundle);
                generalSettings.getProperties().store(messages, GENERAL_SETTINGS);
                return Response.ok((Object)messages.toString()).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"It is not a settings bundle").build();
        }
        catch (MissingResourceException ex) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    private String getLanguage() {
        String language = I18NHelper.defaultLanguage;
        if (this.getUserDetail() != null) {
            language = this.getUserPreferences().getLanguage();
        }
        return language;
    }
}

