/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.comment.web;

import com.silverpeas.calendar.Date;
import com.silverpeas.comment.model.Comment;
import com.silverpeas.comment.model.CommentPK;
import com.silverpeas.profile.web.ProfileResourceBaseURIs;
import com.silverpeas.profile.web.UserProfileEntity;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.Exposable;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.owasp.encoder.Encode;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CommentEntity
implements Exposable {
    private static final long serialVersionUID = 8023645204584179638L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private String id;
    @XmlElement(required=true)
    @NotNull
    @Size(min=2)
    private String componentId;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private String resourceType;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private String resourceId;
    @XmlElement(required=true)
    @NotNull
    private String text;
    @XmlElement(required=true)
    @NotNull
    private UserProfileEntity author;
    @XmlElement(required=true, defaultValue="")
    private String creationDate;
    @XmlElement(required=true, defaultValue="")
    private String modificationDate;
    @XmlElement
    private boolean indexed = false;

    public static CommentEntity fromComment(Comment comment) {
        return new CommentEntity(comment);
    }

    public static List<CommentEntity> fromComments(Comment ... comments) {
        return CommentEntity.fromComments(Arrays.asList(comments));
    }

    public static List<CommentEntity> fromComments(List<Comment> comments) {
        ArrayList<CommentEntity> entities = new ArrayList<CommentEntity>();
        for (Comment comment : comments) {
            entities.add(CommentEntity.fromComment(comment));
        }
        return entities;
    }

    public Comment toComment() {
        String safeText = Encode.forHtml((String)this.text);
        Comment comment = new Comment(new CommentPK(this.id, this.componentId), this.resourceType, (WAPrimaryKey)new PublicationPK(this.resourceId, this.componentId), Integer.valueOf(this.author.getId()).intValue(), this.author.getFullName(), safeText, CommentEntity.decodeFromDisplayDate(this.creationDate, this.getAuthor().getLanguage()), CommentEntity.decodeFromDisplayDate(this.modificationDate, this.getAuthor().getLanguage()));
        comment.setOwnerDetail(this.getAuthor().toUserDetail());
        return comment;
    }

    public CommentEntity withURI(URI uri) {
        this.uri = uri;
        String baseURI = uri.toString();
        String usersURI = baseURI.toString().substring(0, baseURI.indexOf("comments")) + "profile/users";
        this.author = this.author.withAsUri(ProfileResourceBaseURIs.uriOfUser(this.author, usersURI));
        return this;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public UserProfileEntity getAuthor() {
        return this.author;
    }

    public String getText() {
        return this.text;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getModificationDate() {
        return this.modificationDate;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public CommentEntity newText(String aText) {
        this.text = aText;
        return this;
    }

    private CommentEntity(Comment comment) {
        this.componentId = comment.getCommentPK().getInstanceId();
        this.id = comment.getCommentPK().getId();
        this.resourceType = comment.getResourceType();
        this.resourceId = comment.getForeignKey().getId();
        this.text = comment.getMessage();
        this.author = UserProfileEntity.fromUser(comment.getCreator());
        this.creationDate = CommentEntity.encodeToDisplayDate(comment.getCreationDate(), this.author.getLanguage());
        this.modificationDate = CommentEntity.encodeToDisplayDate(comment.getModificationDate(), this.author.getLanguage());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommentEntity other = (CommentEntity)obj;
        if (StringUtil.isDefined((String)this.id) && StringUtil.isDefined((String)other.getId())) {
            return this.id.equals(other.getId());
        }
        return this.componentId.equals(other.getComponentId()) && this.resourceType.equals(other.getResourceType()) && this.resourceId.equals(other.getResourceId()) && this.text.equals(other.getText()) && this.creationDate.equals(other.getCreationDate()) && this.modificationDate.equals(other.getModificationDate()) && this.author.equals(other.getAuthor());
    }

    public int hashCode() {
        int hash = 7;
        if (StringUtil.isDefined((String)this.id)) {
            hash = 17 * hash + this.id.hashCode();
        } else {
            hash = 17 * hash + (this.componentId != null ? this.componentId.hashCode() : 0);
            hash = 17 * hash + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            hash = 17 * hash + (this.resourceId != null ? this.resourceId.hashCode() : 0);
            hash = 17 * hash + (this.text != null ? this.text.hashCode() : 0);
            hash = 17 * hash + (this.creationDate != null ? this.creationDate.hashCode() : 0);
            hash = 17 * hash + (this.modificationDate != null ? this.modificationDate.hashCode() : 0);
            hash = 17 * hash + (this.author != null ? this.author.hashCode() : 0);
        }
        return hash;
    }

    protected CommentEntity() {
    }

    private static String encodeToDisplayDate(java.util.Date date, String language) {
        String displayDate = date != null ? DateUtil.getOutputDate((java.util.Date)date, (String)language) : DateUtil.getOutputDate((java.util.Date)Date.today(), (String)language);
        return displayDate;
    }

    private static java.util.Date decodeFromDisplayDate(String displayDate, String language) {
        java.util.Date date = new java.util.Date();
        if (StringUtil.isDefined((String)displayDate)) {
            try {
                String sqlDate = DateUtil.date2SQLDate((String)displayDate, (String)language);
                date = new Date(DateUtil.parseDate((String)sqlDate));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }
}

