/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.comment.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.comment.CommentRuntimeException;
import com.silverpeas.comment.model.Comment;
import com.silverpeas.comment.model.CommentPK;
import com.silverpeas.comment.service.CommentService;
import com.silverpeas.comment.web.CommentEntity;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Service
@RequestScoped
@Path(value="comments/{componentId}/{contentType}/{contentId}")
@Authorized
public class CommentResource
extends RESTWebService {
    @Inject
    private CommentService commentService;
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="contentType")
    private String contentType;
    @PathParam(value="contentId")
    private String contentId;

    @GET
    @Path(value="{commentId}")
    @Produces(value={"application/json"})
    public CommentEntity getComment(@PathParam(value="commentId") String onCommentId) {
        try {
            Comment theComment = this.commentService().getComment(this.byPK(onCommentId, this.inComponentId()));
            URI commentURI = this.getUriInfo().getRequestUri();
            return this.asWebEntity(theComment, this.identifiedBy(commentURI));
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public CommentEntity[] getAllComments() {
        try {
            List theComments = this.commentService().getAllCommentsOnPublication(this.onContentType(), (WAPrimaryKey)this.byPK(this.onContentId(), this.inComponentId()));
            return this.asWebEntities(theComments);
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response saveNewComment(CommentEntity commentToSave) {
        this.checkIsValid(commentToSave);
        try {
            Comment comment = commentToSave.toComment();
            if (commentToSave.isIndexed()) {
                this.commentService().createAndIndexComment(comment);
            } else {
                this.commentService().createComment(comment);
            }
            Comment savedComment = this.commentService().getComment(comment.getCommentPK());
            URI commentURI = this.getUriInfo().getRequestUriBuilder().path(savedComment.getCommentPK().getId()).build(new Object[0]);
            return Response.created((URI)commentURI).entity((Object)this.asWebEntity(savedComment, this.identifiedBy(commentURI))).build();
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.CONFLICT);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{commentId}")
    public CommentEntity updateComment(@PathParam(value="commentId") String commentId, CommentEntity commentToUpdate) {
        this.checkIsValid(commentToUpdate);
        if (!commentToUpdate.getId().equals(commentId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Comment comment = commentToUpdate.toComment();
        try {
            if (commentToUpdate.isIndexed()) {
                this.commentService().updateAndIndexComment(comment);
            } else {
                this.commentService().updateComment(comment);
            }
            URI commentURI = this.getUriInfo().getRequestUriBuilder().path(comment.getCommentPK().getId()).build(new Object[0]);
            return this.asWebEntity(comment, this.identifiedBy(commentURI));
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @DELETE
    @Path(value="{commentId}")
    public void deleteComment(@PathParam(value="commentId") String onCommentId) {
        try {
            this.commentService().deleteComment(this.byPK(onCommentId, this.inComponentId()));
        }
        catch (CommentRuntimeException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ex.getMessage());
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected String inComponentId() {
        return this.getComponentId();
    }

    protected String onContentType() {
        return this.contentType;
    }

    protected String onContentId() {
        return this.contentId;
    }

    protected CommentService commentService() {
        return this.commentService;
    }

    protected CommentPK byPK(String id, String componentId) {
        return new CommentPK(id, componentId);
    }

    protected CommentEntity[] asWebEntities(List<Comment> comments) {
        CommentEntity[] entities = new CommentEntity[comments.size()];
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = comments.get(i);
            URI commentURI = this.getUriInfo().getRequestUriBuilder().path(comment.getCommentPK().getId()).build(new Object[0]);
            entities[i] = this.asWebEntity(comment, this.identifiedBy(commentURI));
        }
        return entities;
    }

    protected CommentEntity asWebEntity(Comment comment, URI commentURI) {
        return CommentEntity.fromComment(comment).withURI(commentURI);
    }

    protected URI identifiedBy(URI uri) {
        return uri;
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    protected String getContentType() {
        return this.contentType;
    }

    protected String getContentId() {
        return this.contentId;
    }

    protected void checkIsValid(CommentEntity theComment) {
        if (!(theComment.getComponentId().equals(this.getComponentId()) && theComment.getResourceType().equals(this.getContentType()) && theComment.getResourceId().equals(this.getContentId()))) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    protected static Comparator<Comment> byId() {
        return new Comparator<Comment>(){

            @Override
            public int compare(Comment left, Comment right) {
                return left.getCommentPK().getId().compareTo(right.getCommentPK().getId());
            }
        };
    }
}

