/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.directory.model;

import com.silverpeas.session.SessionInfo;
import com.silverpeas.session.SessionManagement;
import com.silverpeas.session.SessionManagementFactory;
import com.silverpeas.socialnetwork.invitation.InvitationService;
import com.silverpeas.socialnetwork.relationShip.RelationShipService;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DateUtil;
import java.util.Collection;
import java.util.Date;
import org.silverpeas.admin.user.constant.UserAccessLevel;

public class Member {
    private UserDetail userDetail = null;
    private boolean connected = false;
    private String duration;

    private void refreshStatus() {
        SessionManagementFactory factory = SessionManagementFactory.getFactory();
        SessionManagement sessionManagement = factory.getSessionManagement();
        Collection sessionInfos = sessionManagement.getConnectedUsersList();
        for (SessionInfo varSi : sessionInfos) {
            if (!varSi.getUserDetail().equals((Object)this.userDetail)) continue;
            this.duration = DateUtil.formatDuration((long)(new Date().getTime() - varSi.getOpeningTimestamp()));
            this.connected = true;
            return;
        }
        this.duration = "";
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public UserDetail getUserDetail() {
        return this.userDetail;
    }

    public Member(UserDetail ud) {
        this.userDetail = ud;
        this.refreshStatus();
    }

    public UserAccessLevel getAccessLevel() {
        return this.getUserDetail().getAccessLevel();
    }

    public String getMail() {
        return this.getUserDetail().geteMail();
    }

    public String getFirstName() {
        return this.getUserDetail().getFirstName();
    }

    public String getId() {
        return this.getUserDetail().getId();
    }

    public String getLastName() {
        return this.getUserDetail().getLastName();
    }

    public String getDuration() {
        return this.duration;
    }

    public boolean isRelationOrInvitation(String myId) {
        RelationShipService relation = new RelationShipService();
        InvitationService invitation = new InvitationService();
        try {
            return relation.isInRelationShip(Integer.parseInt(myId), Integer.parseInt(this.getId())) || invitation.getInvitation(Integer.parseInt(myId), Integer.parseInt(this.getId())) != null;
        }
        catch (Exception e) {
            SilverTrace.warn((String)"directory", (String)this.getClass().getSimpleName(), (String)"root.EX_NO_MESSAGE", (Throwable)e);
            return false;
        }
    }

    public String getStatus() {
        if (!StringUtil.isDefined((String)this.userDetail.getStatus())) {
            return null;
        }
        return this.userDetail.getStatus();
    }
}

